/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.infrastructure.component;

import com.mojang.serialization.Codec;
import com.zurrtum.create.catnip.codecs.stream.CatnipStreamCodecBuilders;
import com.zurrtum.create.content.equipment.zapper.terrainzapper.Brush;
import com.zurrtum.create.content.equipment.zapper.terrainzapper.CuboidBrush;
import com.zurrtum.create.content.equipment.zapper.terrainzapper.CylinderBrush;
import com.zurrtum.create.content.equipment.zapper.terrainzapper.DynamicBrush;
import com.zurrtum.create.content.equipment.zapper.terrainzapper.SphereBrush;
import io.netty.buffer.ByteBuf;
import java.util.Locale;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.StringRepresentable;
import org.jetbrains.annotations.NotNull;

public enum TerrainBrushes implements StringRepresentable
{
    Cuboid(new CuboidBrush()),
    Sphere(new SphereBrush()),
    Cylinder(new CylinderBrush()),
    Surface(new DynamicBrush(true)),
    Cluster(new DynamicBrush(false));

    public static final Codec<TerrainBrushes> CODEC;
    public static final StreamCodec<ByteBuf, TerrainBrushes> STREAM_CODEC;
    private final Brush brush;

    private TerrainBrushes(Brush brush) {
        this.brush = brush;
    }

    public Brush get() {
        return this.brush;
    }

    @NotNull
    public String getSerializedName() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    static {
        CODEC = StringRepresentable.fromEnum(TerrainBrushes::values);
        STREAM_CODEC = CatnipStreamCodecBuilders.ofEnum(TerrainBrushes.class);
    }
}

