/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.infrastructure.fluids;

import com.zurrtum.create.infrastructure.fluids.FluidEntry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.WaterFluid;
import org.jetbrains.annotations.Nullable;

public abstract class FlowableFluid
extends WaterFluid {
    private final FluidEntry entry;

    FlowableFluid(FluidEntry entry) {
        this.entry = entry;
    }

    public FluidEntry getEntry() {
        return this.entry;
    }

    public Fluid getFlowing() {
        return this.entry.flowing;
    }

    public Fluid getSource() {
        return this.entry.still;
    }

    public Item getBucket() {
        if (this.entry.bucket == null) {
            return Items.AIR;
        }
        return this.entry.bucket;
    }

    public BlockState createLegacyBlock(FluidState state) {
        if (this.entry.block == null) {
            return Blocks.AIR.defaultBlockState();
        }
        return (BlockState)this.entry.block.defaultBlockState().setValue((Property)LiquidBlock.LEVEL, (Comparable)Integer.valueOf(FlowableFluid.getLegacyLevel((FluidState)state)));
    }

    public void animateTick(Level world, BlockPos pos, FluidState state, RandomSource random) {
    }

    @Nullable
    public ParticleOptions getDripParticle() {
        return null;
    }

    public boolean isSame(Fluid fluid) {
        return fluid == this.entry.still || fluid == this.entry.flowing;
    }

    protected void spreadTo(LevelAccessor world, BlockPos pos, BlockState state, Direction direction, FluidState fluidState) {
        Block block = state.getBlock();
        if (block instanceof LiquidBlockContainer) {
            LiquidBlockContainer fluidFillable = (LiquidBlockContainer)block;
            fluidFillable.placeLiquid(world, pos, state, fluidState);
        } else if (state.getFluidState().isEmpty()) {
            world.setBlock(pos, fluidState.createLegacyBlock(), 3);
        }
    }

    public int getDropOff(LevelReader world) {
        return 2;
    }

    public int getSlopeFindDistance(LevelReader world) {
        return 3;
    }

    public int getTickDelay(LevelReader world) {
        return 25;
    }

    protected boolean canConvertToSource(ServerLevel world) {
        return false;
    }

    public boolean canBeReplacedWith(FluidState state, BlockGetter world, BlockPos pos, Fluid fluid, Direction direction) {
        return false;
    }

    public static class Still
    extends FlowableFluid {
        public Still(FluidEntry entry) {
            super(entry);
        }

        public int getAmount(FluidState state) {
            return 8;
        }

        public boolean isSource(FluidState state) {
            return true;
        }
    }

    public static class Flowing
    extends FlowableFluid {
        public Flowing(FluidEntry entry) {
            super(entry);
        }

        protected void createFluidStateDefinition(StateDefinition.Builder<Fluid, FluidState> builder) {
            super.createFluidStateDefinition(builder);
            builder.add(new Property[]{LEVEL});
        }

        public int getAmount(FluidState state) {
            return (Integer)state.getValue((Property)LEVEL);
        }

        public boolean isSource(FluidState state) {
            return false;
        }
    }
}

