/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.infrastructure.packet.s2c;

import com.zurrtum.create.AllClientHandle;
import com.zurrtum.create.AllPackets;
import com.zurrtum.create.catnip.data.Couple;
import com.zurrtum.create.catnip.data.Pair;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.content.trains.graph.DimensionPalette;
import com.zurrtum.create.content.trains.graph.EdgeData;
import com.zurrtum.create.content.trains.graph.EdgePointType;
import com.zurrtum.create.content.trains.graph.TrackEdge;
import com.zurrtum.create.content.trains.graph.TrackNode;
import com.zurrtum.create.content.trains.graph.TrackNodeLocation;
import com.zurrtum.create.content.trains.signal.TrackEdgePoint;
import com.zurrtum.create.content.trains.track.BezierConnection;
import com.zurrtum.create.content.trains.track.TrackMaterial;
import com.zurrtum.create.infrastructure.packet.s2c.S2CPacket;
import com.zurrtum.create.infrastructure.packet.s2c.TrackGraphPacket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketType;
import net.minecraft.world.phys.Vec3;
import org.apache.logging.log4j.util.TriConsumer;

public class TrackGraphSyncPacket
extends TrackGraphPacket
implements S2CPacket {
    public static final StreamCodec<FriendlyByteBuf, TrackGraphSyncPacket> CODEC = StreamCodec.ofMember(TrackGraphSyncPacket::write, TrackGraphSyncPacket::new);
    public static final int NULL_GROUP = 0;
    public static final int PASSIVE_GROUP = 1;
    public static final int GROUP = 2;
    public Map<Integer, Pair<TrackNodeLocation, Vec3>> addedNodes;
    public List<Pair<Pair<Couple<Integer>, TrackMaterial>, BezierConnection>> addedEdges;
    public List<Integer> removedNodes;
    public List<TrackEdgePoint> addedEdgePoints;
    public List<UUID> removedEdgePoints;
    public Map<Integer, Pair<Integer, UUID>> splitSubGraphs;
    public Map<Couple<Integer>, Pair<Integer, List<UUID>>> updatedEdgeData;
    public boolean fullWipe;

    public <T> TriConsumer<AllClientHandle<T>, T, TrackGraphSyncPacket> callback() {
        return AllClientHandle::onTrackGraphSync;
    }

    public PacketType<TrackGraphSyncPacket> type() {
        return AllPackets.SYNC_RAIL_GRAPH;
    }

    public TrackGraphSyncPacket(UUID graphId, int netId) {
        this.graphId = graphId;
        this.netId = netId;
        this.addedNodes = new HashMap<Integer, Pair<TrackNodeLocation, Vec3>>();
        this.addedEdges = new ArrayList<Pair<Pair<Couple<Integer>, TrackMaterial>, BezierConnection>>();
        this.removedNodes = new ArrayList<Integer>();
        this.addedEdgePoints = new ArrayList<TrackEdgePoint>();
        this.removedEdgePoints = new ArrayList<UUID>();
        this.updatedEdgeData = new HashMap<Couple<Integer>, Pair<Integer, List<UUID>>>();
        this.splitSubGraphs = new HashMap<Integer, Pair<Integer, UUID>>();
        this.packetDeletesGraph = false;
    }

    public TrackGraphSyncPacket(FriendlyByteBuf buffer) {
        int i;
        this.graphId = buffer.readUUID();
        this.netId = buffer.readInt();
        this.packetDeletesGraph = buffer.readBoolean();
        this.fullWipe = buffer.readBoolean();
        if (this.packetDeletesGraph) {
            return;
        }
        DimensionPalette dimensions = (DimensionPalette)DimensionPalette.PACKET_CODEC.decode((Object)buffer);
        this.addedNodes = new HashMap<Integer, Pair<TrackNodeLocation, Vec3>>();
        this.addedEdges = new ArrayList<Pair<Pair<Couple<Integer>, TrackMaterial>, BezierConnection>>();
        this.addedEdgePoints = new ArrayList<TrackEdgePoint>();
        this.removedEdgePoints = new ArrayList<UUID>();
        this.removedNodes = new ArrayList<Integer>();
        this.splitSubGraphs = new HashMap<Integer, Pair<Integer, UUID>>();
        this.updatedEdgeData = new HashMap<Couple<Integer>, Pair<Integer, List<UUID>>>();
        int size = buffer.readVarInt();
        for (i = 0; i < size; ++i) {
            this.removedNodes.add(buffer.readVarInt());
        }
        size = buffer.readVarInt();
        for (i = 0; i < size; ++i) {
            this.addedNodes.put(buffer.readVarInt(), Pair.of(TrackNodeLocation.receive(buffer, dimensions), VecHelper.read(buffer)));
        }
        size = buffer.readVarInt();
        for (i = 0; i < size; ++i) {
            this.addedEdges.add(Pair.of(Pair.of(Couple.create(() -> ((FriendlyByteBuf)buffer).readVarInt()), (TrackMaterial)TrackMaterial.PACKET_CODEC.decode((Object)buffer)), buffer.readBoolean() ? new BezierConnection(buffer) : null));
        }
        size = buffer.readVarInt();
        for (i = 0; i < size; ++i) {
            this.addedEdgePoints.add(EdgePointType.read(buffer, dimensions));
        }
        size = buffer.readVarInt();
        for (i = 0; i < size; ++i) {
            this.removedEdgePoints.add(buffer.readUUID());
        }
        size = buffer.readVarInt();
        for (i = 0; i < size; ++i) {
            ArrayList<UUID> list = new ArrayList<UUID>();
            Couple<Integer> key = Couple.create(() -> ((FriendlyByteBuf)buffer).readInt());
            Pair entry = Pair.of(buffer.readVarInt(), list);
            int size2 = buffer.readVarInt();
            for (int j = 0; j < size2; ++j) {
                list.add(buffer.readUUID());
            }
            this.updatedEdgeData.put(key, entry);
        }
        size = buffer.readVarInt();
        for (i = 0; i < size; ++i) {
            this.splitSubGraphs.put(buffer.readVarInt(), Pair.of(buffer.readInt(), buffer.readUUID()));
        }
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.writeUUID(this.graphId);
        buffer.writeInt(this.netId);
        buffer.writeBoolean(this.packetDeletesGraph);
        buffer.writeBoolean(this.fullWipe);
        if (this.packetDeletesGraph) {
            return;
        }
        DimensionPalette dimensions = new DimensionPalette();
        this.addedNodes.forEach((node, loc) -> dimensions.encode(((TrackNodeLocation)((Object)((Object)loc.getFirst()))).dimension));
        this.addedEdgePoints.forEach(ep -> ep.edgeLocation.forEach(loc -> dimensions.encode(loc.dimension)));
        DimensionPalette.PACKET_CODEC.encode((Object)buffer, (Object)dimensions);
        buffer.writeVarInt(this.removedNodes.size());
        this.removedNodes.forEach(arg_0 -> ((FriendlyByteBuf)buffer).writeVarInt(arg_0));
        buffer.writeVarInt(this.addedNodes.size());
        this.addedNodes.forEach((node, loc) -> {
            buffer.writeVarInt(node.intValue());
            ((TrackNodeLocation)((Object)((Object)loc.getFirst()))).send(buffer, dimensions);
            Vec3.STREAM_CODEC.encode((Object)buffer, (Object)((Vec3)loc.getSecond()));
        });
        buffer.writeVarInt(this.addedEdges.size());
        this.addedEdges.forEach(pair -> {
            ((Couple)((Pair)pair.getFirst()).getFirst()).forEach(arg_0 -> ((FriendlyByteBuf)buffer).writeVarInt(arg_0));
            TrackMaterial.PACKET_CODEC.encode((Object)buffer, (Object)((TrackMaterial)((Pair)pair.getFirst()).getSecond()));
            BezierConnection turn = (BezierConnection)pair.getSecond();
            buffer.writeBoolean(turn != null);
            if (turn != null) {
                turn.write(buffer);
            }
        });
        buffer.writeVarInt(this.addedEdgePoints.size());
        this.addedEdgePoints.forEach(ep -> ep.write(buffer, dimensions));
        buffer.writeVarInt(this.removedEdgePoints.size());
        this.removedEdgePoints.forEach(arg_0 -> ((FriendlyByteBuf)buffer).writeUUID(arg_0));
        buffer.writeVarInt(this.updatedEdgeData.size());
        for (Map.Entry<Couple<Integer>, Pair<Integer, List<UUID>>> entry : this.updatedEdgeData.entrySet()) {
            entry.getKey().forEach(arg_0 -> ((FriendlyByteBuf)buffer).writeInt(arg_0));
            Pair<Integer, List<UUID>> pair2 = entry.getValue();
            buffer.writeVarInt(pair2.getFirst().intValue());
            List<UUID> list = pair2.getSecond();
            buffer.writeVarInt(list.size());
            list.forEach(arg_0 -> ((FriendlyByteBuf)buffer).writeUUID(arg_0));
        }
        buffer.writeVarInt(this.splitSubGraphs.size());
        this.splitSubGraphs.forEach((node, p) -> {
            buffer.writeVarInt(node.intValue());
            buffer.writeInt(((Integer)p.getFirst()).intValue());
            buffer.writeUUID((UUID)p.getSecond());
        });
    }

    public void syncEdgeData(TrackNode node1, TrackNode node2, TrackEdge edge) {
        int groupType;
        Couple<Integer> key = Couple.create(node1.getNetId(), node2.getNetId());
        ArrayList<UUID> list = new ArrayList<UUID>();
        EdgeData edgeData = edge.getEdgeData();
        int n = edgeData.hasSignalBoundaries() ? 0 : (groupType = EdgeData.passiveGroup.equals(edgeData.getSingleSignalGroup()) ? 1 : 2);
        if (groupType == 2) {
            list.add(edgeData.getSingleSignalGroup());
        }
        for (TrackEdgePoint point : edgeData.getPoints()) {
            list.add(point.getId());
        }
        this.updatedEdgeData.put(key, Pair.of(groupType, list));
    }
}

