package com.zurrtum.create;

import static com.zurrtum.create.Create.MOD_ID;

import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.Identifier;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTab.ItemDisplayParameters;
import net.minecraft.world.item.CreativeModeTab.Output;
import net.minecraft.world.item.ItemStack;

public class AllCreativeModeTabs {
    public static final ResourceKey<CreativeModeTab> BASE_GROUP = ResourceKey.create(
        Registries.CREATIVE_MODE_TAB,
        Identifier.fromNamespaceAndPath(MOD_ID, "base")
    );
    public static final ResourceKey<CreativeModeTab> PALETTES_GROUP = ResourceKey.create(
        Registries.CREATIVE_MODE_TAB,
        Identifier.fromNamespaceAndPath(MOD_ID, "palettes")
    );

    public static void register() {
        Registry.register(
            BuiltInRegistries.CREATIVE_MODE_TAB,
            BASE_GROUP,
            CreativeModeTab.builder(null, -1).title(Component.translatable("itemGroup.create.base")).icon(() -> new ItemStack(AllBlocks.COGWHEEL))
                .displayItems(AllCreativeModeTabs::base).build()
        );
        Registry.register(
            BuiltInRegistries.CREATIVE_MODE_TAB,
            PALETTES_GROUP,
            CreativeModeTab.builder(null, -1).title(Component.translatable("itemGroup.create.palettes"))
                .icon(() -> new ItemStack(AllBlocks.ORNATE_IRON_WINDOW)).displayItems(AllCreativeModeTabs::palettes).build()
        );
    }

    private static void base(ItemDisplayParameters displayContext, Output entries) {
        entries.accept(AllItems.COPPER_BACKTANK.getMaxAirStack());
        entries.accept(AllItems.NETHERITE_BACKTANK.getMaxAirStack());
        entries.accept(AllItems.WRENCH);
        entries.accept(AllItems.LINKED_CONTROLLER);
        entries.accept(AllItems.POTATO_CANNON);
        entries.accept(AllItems.EXTENDO_GRIP);
        entries.accept(AllItems.WAND_OF_SYMMETRY);
        entries.accept(AllItems.WORLDSHAPER);
        entries.accept(AllItems.SCHEMATICANNON);
        entries.accept(AllItems.SCHEMATIC_TABLE);
        entries.accept(AllItems.SHAFT);
        entries.accept(AllItems.COGWHEEL);
        entries.accept(AllItems.LARGE_COGWHEEL);
        entries.accept(AllItems.GEARBOX);
        entries.accept(AllItems.VERTICAL_GEARBOX);
        entries.accept(AllItems.CLUTCH);
        entries.accept(AllItems.GEARSHIFT);
        entries.accept(AllItems.ENCASED_CHAIN_DRIVE);
        entries.accept(AllItems.ADJUSTABLE_CHAIN_GEARSHIFT);
        entries.accept(AllItems.BELT_CONNECTOR);
        entries.accept(AllItems.CHAIN_CONVEYOR);
        entries.accept(AllItems.CREATIVE_MOTOR);
        entries.accept(AllItems.WATER_WHEEL);
        entries.accept(AllItems.LARGE_WATER_WHEEL);
        entries.accept(AllItems.ENCASED_FAN);
        entries.accept(AllItems.NOZZLE);
        entries.accept(AllItems.TURNTABLE);
        entries.accept(AllItems.HAND_CRANK);
        entries.accept(AllItems.CUCKOO_CLOCK);
        entries.accept(AllItems.MILLSTONE);
        entries.accept(AllItems.CRUSHING_WHEEL);
        entries.accept(AllItems.MECHANICAL_PRESS);
        entries.accept(AllItems.MECHANICAL_MIXER);
        entries.accept(AllItems.BASIN);
        entries.accept(AllItems.EMPTY_BLAZE_BURNER);
        entries.accept(AllItems.BLAZE_BURNER);
        entries.accept(AllItems.DEPOT);
        entries.accept(AllItems.WEIGHTED_EJECTOR);
        entries.accept(AllItems.CHUTE);
        entries.accept(AllItems.SMART_CHUTE);
        entries.accept(AllItems.SPEEDOMETER);
        entries.accept(AllItems.STRESSOMETER);
        entries.accept(AllItems.WOODEN_BRACKET);
        entries.accept(AllItems.METAL_BRACKET);
        entries.accept(AllItems.FLUID_PIPE);
        entries.accept(AllItems.MECHANICAL_PUMP);
        entries.accept(AllItems.SMART_FLUID_PIPE);
        entries.accept(AllItems.FLUID_VALVE);
        entries.accept(AllItems.COPPER_VALVE_HANDLE);
        entries.accept(AllItems.FLUID_TANK);
        entries.accept(AllItems.CREATIVE_FLUID_TANK);
        entries.accept(AllItems.HOSE_PULLEY);
        entries.accept(AllItems.ITEM_DRAIN);
        entries.accept(AllItems.SPOUT);
        entries.accept(AllItems.PORTABLE_FLUID_INTERFACE);
        entries.accept(AllItems.STEAM_ENGINE);
        entries.accept(AllItems.STEAM_WHISTLE);
        entries.accept(AllItems.MECHANICAL_PISTON);
        entries.accept(AllItems.STICKY_MECHANICAL_PISTON);
        entries.accept(AllItems.PISTON_EXTENSION_POLE);
        entries.accept(AllItems.GANTRY_CARRIAGE);
        entries.accept(AllItems.GANTRY_SHAFT);
        entries.accept(AllItems.WINDMILL_BEARING);
        entries.accept(AllItems.MECHANICAL_BEARING);
        entries.accept(AllItems.CLOCKWORK_BEARING);
        entries.accept(AllItems.ROPE_PULLEY);
        entries.accept(AllItems.ELEVATOR_PULLEY);
        entries.accept(AllItems.CART_ASSEMBLER);
        entries.accept(AllItems.CONTROLLER_RAIL);
        entries.accept(AllItems.LINEAR_CHASSIS);
        entries.accept(AllItems.SECONDARY_LINEAR_CHASSIS);
        entries.accept(AllItems.RADIAL_CHASSIS);
        entries.accept(AllItems.STICKER);
        entries.accept(AllItems.CONTRAPTION_CONTROLS);
        entries.accept(AllItems.MECHANICAL_DRILL);
        entries.accept(AllItems.MECHANICAL_SAW);
        entries.accept(AllItems.DEPLOYER);
        entries.accept(AllItems.PORTABLE_STORAGE_INTERFACE);
        entries.accept(AllItems.REDSTONE_CONTACT);
        entries.accept(AllItems.MECHANICAL_HARVESTER);
        entries.accept(AllItems.MECHANICAL_PLOUGH);
        entries.accept(AllItems.MECHANICAL_ROLLER);
        entries.accept(AllItems.SAIL_FRAME);
        entries.accept(AllItems.SAIL);
        entries.accept(AllItems.ANDESITE_CASING);
        entries.accept(AllItems.BRASS_CASING);
        entries.accept(AllItems.COPPER_CASING);
        entries.accept(AllItems.MECHANICAL_CRAFTER);
        entries.accept(AllItems.SEQUENCED_GEARSHIFT);
        entries.accept(AllItems.FLYWHEEL);
        entries.accept(AllItems.ROTATION_SPEED_CONTROLLER);
        entries.accept(AllItems.MECHANICAL_ARM);
        entries.accept(AllItems.TRACK);
        entries.accept(AllItems.RAILWAY_CASING);
        entries.accept(AllItems.SCHEDULE);
        entries.accept(AllItems.TRACK_STATION);
        entries.accept(AllItems.TRACK_SIGNAL);
        entries.accept(AllItems.TRACK_OBSERVER);
        entries.accept(AllItems.TRAIN_CONTROLS);
        entries.accept(AllItems.ANDESITE_FUNNEL);
        entries.accept(AllItems.BRASS_FUNNEL);
        entries.accept(AllItems.ANDESITE_TUNNEL);
        entries.accept(AllItems.BRASS_TUNNEL);
        entries.accept(AllItems.SMART_OBSERVER);
        entries.accept(AllItems.THRESHOLD_SWITCH);
        entries.accept(AllItems.CREATIVE_CRATE);
        entries.accept(AllItems.ITEM_VAULT);
        entries.accept(AllItems.ITEM_HATCH);
        entries.accept(AllItems.PACKAGER);
        entries.accept(AllItems.CARDBOARD_PACKAGE_12X10);
        entries.accept(AllItems.CARDBOARD_PACKAGE_10X8);
        entries.accept(AllItems.CARDBOARD_PACKAGE_10X12);
        entries.accept(AllItems.CARDBOARD_PACKAGE_12X12);
        entries.accept(AllItems.REPACKAGER);
        entries.accept(AllItems.PACKAGE_FROGPORT);
        entries.accept(AllItems.WHITE_POSTBOX);
        entries.accept(AllItems.STOCK_LINK);
        entries.accept(AllItems.STOCK_TICKER);
        entries.accept(AllItems.REDSTONE_REQUESTER);
        entries.accept(AllItems.FACTORY_GAUGE);
        entries.accept(AllItems.RED_TABLE_CLOTH);
        entries.accept(AllItems.ANDESITE_TABLE_CLOTH);
        entries.accept(AllItems.BRASS_TABLE_CLOTH);
        entries.accept(AllItems.COPPER_TABLE_CLOTH);
        entries.accept(AllItems.DISPLAY_LINK);
        entries.accept(AllItems.DISPLAY_BOARD);
        entries.accept(AllItems.ORANGE_NIXIE_TUBE);
        entries.accept(AllItems.ROSE_QUARTZ_LAMP);
        entries.accept(AllItems.REDSTONE_LINK);
        entries.accept(AllItems.ANALOG_LEVER);
        entries.accept(AllItems.PLACARD);
        entries.accept(AllItems.PULSE_REPEATER);
        entries.accept(AllItems.PULSE_EXTENDER);
        entries.accept(AllItems.PULSE_TIMER);
        entries.accept(AllItems.POWERED_LATCH);
        entries.accept(AllItems.POWERED_TOGGLE_LATCH);
        entries.accept(AllItems.PECULIAR_BELL);
        entries.accept(AllItems.HAUNTED_BELL);
        entries.accept(AllItems.DESK_BELL);
        entries.accept(AllItems.BROWN_TOOLBOX);
        entries.accept(AllItems.CLIPBOARD);
        entries.accept(AllItems.WHEAT_FLOUR);
        entries.accept(AllItems.DOUGH);
        entries.accept(AllItems.CINDER_FLOUR);
        entries.accept(AllItems.ROSE_QUARTZ);
        entries.accept(AllItems.POLISHED_ROSE_QUARTZ);
        entries.accept(AllItems.POWDERED_OBSIDIAN);
        entries.accept(AllItems.STURDY_SHEET);
        entries.accept(AllItems.PROPELLER);
        entries.accept(AllItems.WHISK);
        entries.accept(AllItems.BRASS_HAND);
        entries.accept(AllItems.CRAFTER_SLOT_COVER);
        entries.accept(AllItems.ELECTRON_TUBE);
        entries.accept(AllItems.TRANSMITTER);
        entries.accept(AllItems.PULP);
        entries.accept(AllItems.CARDBOARD);
        entries.accept(AllItems.PRECISION_MECHANISM);
        entries.accept(AllItems.BLAZE_CAKE);
        entries.accept(AllItems.CREATIVE_BLAZE_CAKE);
        entries.accept(AllItems.BAR_OF_CHOCOLATE);
        entries.accept(AllItems.SWEET_ROLL);
        entries.accept(AllItems.CHOCOLATE_BERRIES);
        entries.accept(AllItems.HONEYED_APPLE);
        entries.accept(AllItems.BUILDERS_TEA);
        entries.accept(AllItems.CARDBOARD_SWORD);
        entries.accept(AllItems.RAW_ZINC);
        entries.accept(AllItems.ANDESITE_ALLOY);
        entries.accept(AllItems.ZINC_INGOT);
        entries.accept(AllItems.BRASS_INGOT);
        entries.accept(AllItems.ZINC_NUGGET);
        entries.accept(AllItems.BRASS_NUGGET);
        entries.accept(AllItems.EXP_NUGGET);
        entries.accept(AllItems.COPPER_SHEET);
        entries.accept(AllItems.BRASS_SHEET);
        entries.accept(AllItems.IRON_SHEET);
        entries.accept(AllItems.GOLDEN_SHEET);
        entries.accept(AllItems.CRUSHED_IRON);
        entries.accept(AllItems.CRUSHED_GOLD);
        entries.accept(AllItems.CRUSHED_COPPER);
        entries.accept(AllItems.CRUSHED_ZINC);
        AllItems.CRUSHED_RAW_OSMIUM.addTo(entries);
        AllItems.CRUSHED_RAW_PLATINUM.addTo(entries);
        AllItems.CRUSHED_RAW_SILVER.addTo(entries);
        AllItems.CRUSHED_RAW_TIN.addTo(entries);
        AllItems.CRUSHED_RAW_LEAD.addTo(entries);
        AllItems.CRUSHED_RAW_QUICKSILVER.addTo(entries);
        AllItems.CRUSHED_RAW_ALUMINUM.addTo(entries);
        AllItems.CRUSHED_RAW_URANIUM.addTo(entries);
        AllItems.CRUSHED_RAW_NICKEL.addTo(entries);
        entries.accept(AllItems.GOGGLES);
        entries.accept(AllItems.SUPER_GLUE);
        entries.accept(AllItems.MINECART_COUPLING);
        entries.accept(AllItems.CRAFTING_BLUEPRINT);
        entries.accept(AllItems.COPPER_DIVING_HELMET);
        entries.accept(AllItems.NETHERITE_DIVING_HELMET);
        entries.accept(AllItems.COPPER_DIVING_BOOTS);
        entries.accept(AllItems.NETHERITE_DIVING_BOOTS);
        entries.accept(AllItems.CARDBOARD_HELMET);
        entries.accept(AllItems.CARDBOARD_CHESTPLATE);
        entries.accept(AllItems.CARDBOARD_LEGGINGS);
        entries.accept(AllItems.CARDBOARD_BOOTS);
        entries.accept(AllItems.SAND_PAPER);
        entries.accept(AllItems.RED_SAND_PAPER);
        entries.accept(AllItems.TREE_FERTILIZER);
        entries.accept(AllItems.FILTER);
        entries.accept(AllItems.ATTRIBUTE_FILTER);
        entries.accept(AllItems.PACKAGE_FILTER);
        entries.accept(AllItems.EMPTY_SCHEMATIC);
        entries.accept(AllItems.SCHEMATIC_AND_QUILL);
        entries.accept(AllItems.HONEY_BUCKET);
        entries.accept(AllItems.CHOCOLATE_BUCKET);

        entries.accept(AllItems.BLAZE_CAKE_BASE, CreativeModeTab.TabVisibility.SEARCH_TAB_ONLY);
        entries.accept(AllItems.WHITE_VALVE_HANDLE, CreativeModeTab.TabVisibility.SEARCH_TAB_ONLY);
        entries.accept(AllItems.ORANGE_VALVE_HANDLE, CreativeModeTab.TabVisibility.SEARCH_TAB_ONLY);
        entries.accept(AllItems.MAGENTA_VALVE_HANDLE, CreativeModeTab.TabVisibility.SEARCH_TAB_ONLY);
        entries.accept(AllItems.LIGHT_BLUE_VALVE_HANDLE, CreativeModeTab.TabVisibility.SEARCH_TAB_ONLY);
        entries.accept(AllItems.YELLOW_VALVE_HANDLE, CreativeModeTab.TabVisibility.SEARCH_TAB_ONLY);
        entries.accept(AllItems.LIME_VALVE_HANDLE, CreativeModeTab.TabVisibility.SEARCH_TAB_ONLY);
        entries.accept(AllItems.PINK_VALVE_HANDLE, CreativeModeTab.TabVisibility.SEARCH_TAB_ONLY);
        entries.accept(AllItems.GRAY_VALVE_HANDLE, CreativeModeTab.TabVisibility.SEARCH_TAB_ONLY);
        entries.accept(AllItems.LIGHT_GRAY_VALVE_HANDLE, CreativeModeTab.TabVisibility.SEARCH_TAB_ONLY);
        entries.accept(AllItems.CYAN_VALVE_HANDLE, CreativeModeTab.TabVisibility.SEARCH_TAB_ONLY);
        entries.accept(AllItems.PURPLE_VALVE_HANDLE, CreativeModeTab.TabVisibility.SEARCH_TAB_ONLY);
        entries.accept(AllItems.BLUE_VALVE_HANDLE, CreativeModeTab.TabVisibility.SEARCH_TAB_ONLY);
        entries.accept(AllItems.BROWN_VALVE_HANDLE, CreativeModeTab.TabVisibility.SEARCH_TAB_ONLY);
        entries.accept(AllItems.GREEN_VALVE_HANDLE, CreativeModeTab.TabVisibility.SEARCH_TAB_ONLY);
        entries.accept(AllItems.RED_VALVE_HANDLE, CreativeModeTab.TabVisibility.SEARCH_TAB_ONLY);
        entries.accept(AllItems.BLACK_VALVE_HANDLE, CreativeModeTab.TabVisibility.SEARCH_TAB_ONLY);
        entries.accept(AllItems.WHITE_TOOLBOX, CreativeModeTab.TabVisibility.SEARCH_TAB_ONLY);
        entries.accept(AllItems.ORANGE_TOOLBOX, CreativeModeTab.TabVisibility.SEARCH_TAB_ONLY);
        entries.accept(AllItems.MAGENTA_TOOLBOX, CreativeModeTab.TabVisibility.SEARCH_TAB_ONLY);
        entries.accept(AllItems.LIGHT_BLUE_TOOLBOX, CreativeModeTab.TabVisibility.SEARCH_TAB_ONLY);
        entries.accept(AllItems.YELLOW_TOOLBOX, CreativeModeTab.TabVisibility.SEARCH_TAB_ONLY);
        entries.accept(AllItems.LIME_TOOLBOX, CreativeModeTab.TabVisibility.SEARCH_TAB_ONLY);
        entries.accept(AllItems.PINK_TOOLBOX, CreativeModeTab.TabVisibility.SEARCH_TAB_ONLY);
        entries.accept(AllItems.GRAY_TOOLBOX, CreativeModeTab.TabVisibility.SEARCH_TAB_ONLY);
        entries.accept(AllItems.LIGHT_GRAY_TOOLBOX, CreativeModeTab.TabVisibility.SEARCH_TAB_ONLY);
        entries.accept(AllItems.CYAN_TOOLBOX, CreativeModeTab.TabVisibility.SEARCH_TAB_ONLY);
        entries.accept(AllItems.PURPLE_TOOLBOX, CreativeModeTab.TabVisibility.SEARCH_TAB_ONLY);
        entries.accept(AllItems.BLUE_TOOLBOX, CreativeModeTab.TabVisibility.SEARCH_TAB_ONLY);
        entries.accept(AllItems.BROWN_TOOLBOX, CreativeModeTab.TabVisibility.SEARCH_TAB_ONLY);
        entries.accept(AllItems.GREEN_TOOLBOX, CreativeModeTab.TabVisibility.SEARCH_TAB_ONLY);
        entries.accept(AllItems.RED_TOOLBOX, CreativeModeTab.TabVisibility.SEARCH_TAB_ONLY);
        entries.accept(AllItems.BLACK_TOOLBOX, CreativeModeTab.TabVisibility.SEARCH_TAB_ONLY);
        entries.accept(AllItems.ORANGE_POSTBOX, CreativeModeTab.TabVisibility.SEARCH_TAB_ONLY);
        entries.accept(AllItems.MAGENTA_POSTBOX, CreativeModeTab.TabVisibility.SEARCH_TAB_ONLY);
        entries.accept(AllItems.LIGHT_BLUE_POSTBOX, CreativeModeTab.TabVisibility.SEARCH_TAB_ONLY);
        entries.accept(AllItems.YELLOW_POSTBOX, CreativeModeTab.TabVisibility.SEARCH_TAB_ONLY);
        entries.accept(AllItems.LIME_POSTBOX, CreativeModeTab.TabVisibility.SEARCH_TAB_ONLY);
        entries.accept(AllItems.PINK_POSTBOX, CreativeModeTab.TabVisibility.SEARCH_TAB_ONLY);
        entries.accept(AllItems.GRAY_POSTBOX, CreativeModeTab.TabVisibility.SEARCH_TAB_ONLY);
        entries.accept(AllItems.LIGHT_GRAY_POSTBOX, CreativeModeTab.TabVisibility.SEARCH_TAB_ONLY);
        entries.accept(AllItems.CYAN_POSTBOX, CreativeModeTab.TabVisibility.SEARCH_TAB_ONLY);
        entries.accept(AllItems.PURPLE_POSTBOX, CreativeModeTab.TabVisibility.SEARCH_TAB_ONLY);
        entries.accept(AllItems.BLUE_POSTBOX, CreativeModeTab.TabVisibility.SEARCH_TAB_ONLY);
        entries.accept(AllItems.BROWN_POSTBOX, CreativeModeTab.TabVisibility.SEARCH_TAB_ONLY);
        entries.accept(AllItems.GREEN_POSTBOX, CreativeModeTab.TabVisibility.SEARCH_TAB_ONLY);
        entries.accept(AllItems.RED_POSTBOX, CreativeModeTab.TabVisibility.SEARCH_TAB_ONLY);
        entries.accept(AllItems.BLACK_POSTBOX, CreativeModeTab.TabVisibility.SEARCH_TAB_ONLY);
    }

    private static void palettes(ItemDisplayParameters displayContext, Output entries) {
        entries.accept(AllItems.ANDESITE_LADDER);
        entries.accept(AllItems.BRASS_LADDER);
        entries.accept(AllItems.COPPER_LADDER);
        entries.accept(AllItems.ANDESITE_BARS);
        entries.accept(AllItems.BRASS_BARS);
        entries.accept(AllItems.COPPER_BARS);
        entries.accept(AllItems.ANDESITE_SCAFFOLD);
        entries.accept(AllItems.BRASS_SCAFFOLD);
        entries.accept(AllItems.COPPER_SCAFFOLD);
        entries.accept(AllItems.METAL_GIRDER);
        entries.accept(AllItems.COPYCAT_STEP);
        entries.accept(AllItems.COPYCAT_PANEL);
        entries.accept(AllItems.RED_SEAT);
        entries.accept(AllItems.ANDESITE_DOOR);
        entries.accept(AllItems.BRASS_DOOR);
        entries.accept(AllItems.COPPER_DOOR);
        entries.accept(AllItems.TRAIN_DOOR);
        entries.accept(AllItems.TRAIN_TRAPDOOR);
        entries.accept(AllItems.FRAMED_GLASS_DOOR);
        entries.accept(AllItems.FRAMED_GLASS_TRAPDOOR);
        entries.accept(AllItems.ZINC_ORE);
        entries.accept(AllItems.DEEPSLATE_ZINC_ORE);
        entries.accept(AllItems.RAW_ZINC_BLOCK);
        entries.accept(AllItems.ZINC_BLOCK);
        entries.accept(AllItems.ANDESITE_ALLOY_BLOCK);
        entries.accept(AllItems.INDUSTRIAL_IRON_BLOCK);
        entries.accept(AllItems.WEATHERED_IRON_BLOCK);
        entries.accept(AllItems.BRASS_BLOCK);
        entries.accept(AllItems.CARDBOARD_BLOCK);
        entries.accept(AllItems.BOUND_CARDBOARD_BLOCK);
        entries.accept(AllItems.EXPERIENCE_BLOCK);
        entries.accept(AllItems.ROSE_QUARTZ_BLOCK);
        entries.accept(AllItems.ROSE_QUARTZ_TILES);
        entries.accept(AllItems.SMALL_ROSE_QUARTZ_TILES);
        entries.accept(AllItems.COPPER_SHINGLES);
        entries.accept(AllItems.EXPOSED_COPPER_SHINGLES);
        entries.accept(AllItems.WEATHERED_COPPER_SHINGLES);
        entries.accept(AllItems.OXIDIZED_COPPER_SHINGLES);
        entries.accept(AllItems.COPPER_SHINGLE_SLAB);
        entries.accept(AllItems.EXPOSED_COPPER_SHINGLE_SLAB);
        entries.accept(AllItems.WEATHERED_COPPER_SHINGLE_SLAB);
        entries.accept(AllItems.OXIDIZED_COPPER_SHINGLE_SLAB);
        entries.accept(AllItems.COPPER_SHINGLE_STAIRS);
        entries.accept(AllItems.EXPOSED_COPPER_SHINGLE_STAIRS);
        entries.accept(AllItems.WEATHERED_COPPER_SHINGLE_STAIRS);
        entries.accept(AllItems.OXIDIZED_COPPER_SHINGLE_STAIRS);
        entries.accept(AllItems.WAXED_COPPER_SHINGLES);
        entries.accept(AllItems.WAXED_EXPOSED_COPPER_SHINGLES);
        entries.accept(AllItems.WAXED_WEATHERED_COPPER_SHINGLES);
        entries.accept(AllItems.WAXED_OXIDIZED_COPPER_SHINGLES);
        entries.accept(AllItems.WAXED_COPPER_SHINGLE_SLAB);
        entries.accept(AllItems.WAXED_EXPOSED_COPPER_SHINGLE_SLAB);
        entries.accept(AllItems.WAXED_WEATHERED_COPPER_SHINGLE_SLAB);
        entries.accept(AllItems.WAXED_OXIDIZED_COPPER_SHINGLE_SLAB);
        entries.accept(AllItems.WAXED_COPPER_SHINGLE_STAIRS);
        entries.accept(AllItems.WAXED_EXPOSED_COPPER_SHINGLE_STAIRS);
        entries.accept(AllItems.WAXED_WEATHERED_COPPER_SHINGLE_STAIRS);
        entries.accept(AllItems.WAXED_OXIDIZED_COPPER_SHINGLE_STAIRS);
        entries.accept(AllItems.COPPER_TILES);
        entries.accept(AllItems.EXPOSED_COPPER_TILES);
        entries.accept(AllItems.WEATHERED_COPPER_TILES);
        entries.accept(AllItems.OXIDIZED_COPPER_TILES);
        entries.accept(AllItems.COPPER_TILE_SLAB);
        entries.accept(AllItems.EXPOSED_COPPER_TILE_SLAB);
        entries.accept(AllItems.WEATHERED_COPPER_TILE_SLAB);
        entries.accept(AllItems.OXIDIZED_COPPER_TILE_SLAB);
        entries.accept(AllItems.COPPER_TILE_STAIRS);
        entries.accept(AllItems.EXPOSED_COPPER_TILE_STAIRS);
        entries.accept(AllItems.WEATHERED_COPPER_TILE_STAIRS);
        entries.accept(AllItems.OXIDIZED_COPPER_TILE_STAIRS);
        entries.accept(AllItems.WAXED_COPPER_TILES);
        entries.accept(AllItems.WAXED_EXPOSED_COPPER_TILES);
        entries.accept(AllItems.WAXED_WEATHERED_COPPER_TILES);
        entries.accept(AllItems.WAXED_OXIDIZED_COPPER_TILES);
        entries.accept(AllItems.WAXED_COPPER_TILE_SLAB);
        entries.accept(AllItems.WAXED_EXPOSED_COPPER_TILE_SLAB);
        entries.accept(AllItems.WAXED_WEATHERED_COPPER_TILE_SLAB);
        entries.accept(AllItems.WAXED_OXIDIZED_COPPER_TILE_SLAB);
        entries.accept(AllItems.WAXED_COPPER_TILE_STAIRS);
        entries.accept(AllItems.WAXED_EXPOSED_COPPER_TILE_STAIRS);
        entries.accept(AllItems.WAXED_WEATHERED_COPPER_TILE_STAIRS);
        entries.accept(AllItems.WAXED_OXIDIZED_COPPER_TILE_STAIRS);
        entries.accept(AllItems.TILED_GLASS);
        entries.accept(AllItems.FRAMED_GLASS);
        entries.accept(AllItems.HORIZONTAL_FRAMED_GLASS);
        entries.accept(AllItems.VERTICAL_FRAMED_GLASS);
        entries.accept(AllItems.TILED_GLASS_PANE);
        entries.accept(AllItems.FRAMED_GLASS_PANE);
        entries.accept(AllItems.HORIZONTAL_FRAMED_GLASS_PANE);
        entries.accept(AllItems.VERTICAL_FRAMED_GLASS_PANE);
        entries.accept(AllItems.OAK_WINDOW);
        entries.accept(AllItems.SPRUCE_WINDOW);
        entries.accept(AllItems.BIRCH_WINDOW);
        entries.accept(AllItems.JUNGLE_WINDOW);
        entries.accept(AllItems.ACACIA_WINDOW);
        entries.accept(AllItems.DARK_OAK_WINDOW);
        entries.accept(AllItems.MANGROVE_WINDOW);
        entries.accept(AllItems.CRIMSON_WINDOW);
        entries.accept(AllItems.WARPED_WINDOW);
        entries.accept(AllItems.CHERRY_WINDOW);
        entries.accept(AllItems.BAMBOO_WINDOW);
        entries.accept(AllItems.ORNATE_IRON_WINDOW);
        entries.accept(AllItems.INDUSTRIAL_IRON_WINDOW);
        entries.accept(AllItems.WEATHERED_IRON_WINDOW);
        entries.accept(AllItems.OAK_WINDOW_PANE);
        entries.accept(AllItems.SPRUCE_WINDOW_PANE);
        entries.accept(AllItems.BIRCH_WINDOW_PANE);
        entries.accept(AllItems.JUNGLE_WINDOW_PANE);
        entries.accept(AllItems.ACACIA_WINDOW_PANE);
        entries.accept(AllItems.DARK_OAK_WINDOW_PANE);
        entries.accept(AllItems.MANGROVE_WINDOW_PANE);
        entries.accept(AllItems.CRIMSON_WINDOW_PANE);
        entries.accept(AllItems.WARPED_WINDOW_PANE);
        entries.accept(AllItems.CHERRY_WINDOW_PANE);
        entries.accept(AllItems.BAMBOO_WINDOW_PANE);
        entries.accept(AllItems.ORNATE_IRON_WINDOW_PANE);
        entries.accept(AllItems.INDUSTRIAL_IRON_WINDOW_PANE);
        entries.accept(AllItems.WEATHERED_IRON_WINDOW_PANE);
        entries.accept(AllItems.CUT_GRANITE);
        entries.accept(AllItems.CUT_GRANITE_STAIRS);
        entries.accept(AllItems.CUT_GRANITE_SLAB);
        entries.accept(AllItems.CUT_GRANITE_WALL);
        entries.accept(AllItems.POLISHED_CUT_GRANITE);
        entries.accept(AllItems.POLISHED_CUT_GRANITE_STAIRS);
        entries.accept(AllItems.POLISHED_CUT_GRANITE_SLAB);
        entries.accept(AllItems.POLISHED_CUT_GRANITE_WALL);
        entries.accept(AllItems.CUT_GRANITE_BRICKS);
        entries.accept(AllItems.CUT_GRANITE_BRICK_STAIRS);
        entries.accept(AllItems.CUT_GRANITE_BRICK_SLAB);
        entries.accept(AllItems.CUT_GRANITE_BRICK_WALL);
        entries.accept(AllItems.SMALL_GRANITE_BRICKS);
        entries.accept(AllItems.SMALL_GRANITE_BRICK_STAIRS);
        entries.accept(AllItems.SMALL_GRANITE_BRICK_SLAB);
        entries.accept(AllItems.SMALL_GRANITE_BRICK_WALL);
        entries.accept(AllItems.LAYERED_GRANITE);
        entries.accept(AllItems.GRANITE_PILLAR);
        entries.accept(AllItems.CUT_DIORITE);
        entries.accept(AllItems.CUT_DIORITE_STAIRS);
        entries.accept(AllItems.CUT_DIORITE_SLAB);
        entries.accept(AllItems.CUT_DIORITE_WALL);
        entries.accept(AllItems.POLISHED_CUT_DIORITE);
        entries.accept(AllItems.POLISHED_CUT_DIORITE_STAIRS);
        entries.accept(AllItems.POLISHED_CUT_DIORITE_SLAB);
        entries.accept(AllItems.POLISHED_CUT_DIORITE_WALL);
        entries.accept(AllItems.CUT_DIORITE_BRICKS);
        entries.accept(AllItems.CUT_DIORITE_BRICK_STAIRS);
        entries.accept(AllItems.CUT_DIORITE_BRICK_SLAB);
        entries.accept(AllItems.CUT_DIORITE_BRICK_WALL);
        entries.accept(AllItems.SMALL_DIORITE_BRICKS);
        entries.accept(AllItems.SMALL_DIORITE_BRICK_STAIRS);
        entries.accept(AllItems.SMALL_DIORITE_BRICK_SLAB);
        entries.accept(AllItems.SMALL_DIORITE_BRICK_WALL);
        entries.accept(AllItems.LAYERED_DIORITE);
        entries.accept(AllItems.DIORITE_PILLAR);
        entries.accept(AllItems.CUT_ANDESITE);
        entries.accept(AllItems.CUT_ANDESITE_STAIRS);
        entries.accept(AllItems.CUT_ANDESITE_SLAB);
        entries.accept(AllItems.CUT_ANDESITE_WALL);
        entries.accept(AllItems.POLISHED_CUT_ANDESITE);
        entries.accept(AllItems.POLISHED_CUT_ANDESITE_STAIRS);
        entries.accept(AllItems.POLISHED_CUT_ANDESITE_SLAB);
        entries.accept(AllItems.POLISHED_CUT_ANDESITE_WALL);
        entries.accept(AllItems.CUT_ANDESITE_BRICKS);
        entries.accept(AllItems.CUT_ANDESITE_BRICK_STAIRS);
        entries.accept(AllItems.CUT_ANDESITE_BRICK_SLAB);
        entries.accept(AllItems.CUT_ANDESITE_BRICK_WALL);
        entries.accept(AllItems.SMALL_ANDESITE_BRICKS);
        entries.accept(AllItems.SMALL_ANDESITE_BRICK_STAIRS);
        entries.accept(AllItems.SMALL_ANDESITE_BRICK_SLAB);
        entries.accept(AllItems.SMALL_ANDESITE_BRICK_WALL);
        entries.accept(AllItems.LAYERED_ANDESITE);
        entries.accept(AllItems.ANDESITE_PILLAR);
        entries.accept(AllItems.CUT_CALCITE);
        entries.accept(AllItems.CUT_CALCITE_STAIRS);
        entries.accept(AllItems.CUT_CALCITE_SLAB);
        entries.accept(AllItems.CUT_CALCITE_WALL);
        entries.accept(AllItems.POLISHED_CUT_CALCITE);
        entries.accept(AllItems.POLISHED_CUT_CALCITE_STAIRS);
        entries.accept(AllItems.POLISHED_CUT_CALCITE_SLAB);
        entries.accept(AllItems.POLISHED_CUT_CALCITE_WALL);
        entries.accept(AllItems.CUT_CALCITE_BRICKS);
        entries.accept(AllItems.CUT_CALCITE_BRICK_STAIRS);
        entries.accept(AllItems.CUT_CALCITE_BRICK_SLAB);
        entries.accept(AllItems.CUT_CALCITE_BRICK_WALL);
        entries.accept(AllItems.SMALL_CALCITE_BRICKS);
        entries.accept(AllItems.SMALL_CALCITE_BRICK_STAIRS);
        entries.accept(AllItems.SMALL_CALCITE_BRICK_SLAB);
        entries.accept(AllItems.SMALL_CALCITE_BRICK_WALL);
        entries.accept(AllItems.LAYERED_CALCITE);
        entries.accept(AllItems.CALCITE_PILLAR);
        entries.accept(AllItems.CUT_DRIPSTONE);
        entries.accept(AllItems.CUT_DRIPSTONE_STAIRS);
        entries.accept(AllItems.CUT_DRIPSTONE_SLAB);
        entries.accept(AllItems.CUT_DRIPSTONE_WALL);
        entries.accept(AllItems.POLISHED_CUT_DRIPSTONE);
        entries.accept(AllItems.POLISHED_CUT_DRIPSTONE_STAIRS);
        entries.accept(AllItems.POLISHED_CUT_DRIPSTONE_SLAB);
        entries.accept(AllItems.POLISHED_CUT_DRIPSTONE_WALL);
        entries.accept(AllItems.CUT_DRIPSTONE_BRICKS);
        entries.accept(AllItems.CUT_DRIPSTONE_BRICK_STAIRS);
        entries.accept(AllItems.CUT_DRIPSTONE_BRICK_SLAB);
        entries.accept(AllItems.CUT_DRIPSTONE_BRICK_WALL);
        entries.accept(AllItems.SMALL_DRIPSTONE_BRICKS);
        entries.accept(AllItems.SMALL_DRIPSTONE_BRICK_STAIRS);
        entries.accept(AllItems.SMALL_DRIPSTONE_BRICK_SLAB);
        entries.accept(AllItems.SMALL_DRIPSTONE_BRICK_WALL);
        entries.accept(AllItems.LAYERED_DRIPSTONE);
        entries.accept(AllItems.DRIPSTONE_PILLAR);
        entries.accept(AllItems.CUT_DEEPSLATE);
        entries.accept(AllItems.CUT_DEEPSLATE_STAIRS);
        entries.accept(AllItems.CUT_DEEPSLATE_SLAB);
        entries.accept(AllItems.CUT_DEEPSLATE_WALL);
        entries.accept(AllItems.POLISHED_CUT_DEEPSLATE);
        entries.accept(AllItems.POLISHED_CUT_DEEPSLATE_STAIRS);
        entries.accept(AllItems.POLISHED_CUT_DEEPSLATE_SLAB);
        entries.accept(AllItems.POLISHED_CUT_DEEPSLATE_WALL);
        entries.accept(AllItems.CUT_DEEPSLATE_BRICKS);
        entries.accept(AllItems.CUT_DEEPSLATE_BRICK_STAIRS);
        entries.accept(AllItems.CUT_DEEPSLATE_BRICK_SLAB);
        entries.accept(AllItems.CUT_DEEPSLATE_BRICK_WALL);
        entries.accept(AllItems.SMALL_DEEPSLATE_BRICKS);
        entries.accept(AllItems.SMALL_DEEPSLATE_BRICK_STAIRS);
        entries.accept(AllItems.SMALL_DEEPSLATE_BRICK_SLAB);
        entries.accept(AllItems.SMALL_DEEPSLATE_BRICK_WALL);
        entries.accept(AllItems.LAYERED_DEEPSLATE);
        entries.accept(AllItems.DEEPSLATE_PILLAR);
        entries.accept(AllItems.CUT_TUFF);
        entries.accept(AllItems.CUT_TUFF_STAIRS);
        entries.accept(AllItems.CUT_TUFF_SLAB);
        entries.accept(AllItems.CUT_TUFF_WALL);
        entries.accept(AllItems.POLISHED_CUT_TUFF);
        entries.accept(AllItems.POLISHED_CUT_TUFF_STAIRS);
        entries.accept(AllItems.POLISHED_CUT_TUFF_SLAB);
        entries.accept(AllItems.POLISHED_CUT_TUFF_WALL);
        entries.accept(AllItems.CUT_TUFF_BRICKS);
        entries.accept(AllItems.CUT_TUFF_BRICK_STAIRS);
        entries.accept(AllItems.CUT_TUFF_BRICK_SLAB);
        entries.accept(AllItems.CUT_TUFF_BRICK_WALL);
        entries.accept(AllItems.SMALL_TUFF_BRICKS);
        entries.accept(AllItems.SMALL_TUFF_BRICK_STAIRS);
        entries.accept(AllItems.SMALL_TUFF_BRICK_SLAB);
        entries.accept(AllItems.SMALL_TUFF_BRICK_WALL);
        entries.accept(AllItems.LAYERED_TUFF);
        entries.accept(AllItems.TUFF_PILLAR);
        entries.accept(AllItems.ASURINE);
        entries.accept(AllItems.CUT_ASURINE);
        entries.accept(AllItems.CUT_ASURINE_STAIRS);
        entries.accept(AllItems.CUT_ASURINE_SLAB);
        entries.accept(AllItems.CUT_ASURINE_WALL);
        entries.accept(AllItems.POLISHED_CUT_ASURINE);
        entries.accept(AllItems.POLISHED_CUT_ASURINE_STAIRS);
        entries.accept(AllItems.POLISHED_CUT_ASURINE_SLAB);
        entries.accept(AllItems.POLISHED_CUT_ASURINE_WALL);
        entries.accept(AllItems.CUT_ASURINE_BRICKS);
        entries.accept(AllItems.CUT_ASURINE_BRICK_STAIRS);
        entries.accept(AllItems.CUT_ASURINE_BRICK_SLAB);
        entries.accept(AllItems.CUT_ASURINE_BRICK_WALL);
        entries.accept(AllItems.SMALL_ASURINE_BRICKS);
        entries.accept(AllItems.SMALL_ASURINE_BRICK_STAIRS);
        entries.accept(AllItems.SMALL_ASURINE_BRICK_SLAB);
        entries.accept(AllItems.SMALL_ASURINE_BRICK_WALL);
        entries.accept(AllItems.LAYERED_ASURINE);
        entries.accept(AllItems.ASURINE_PILLAR);
        entries.accept(AllItems.CRIMSITE);
        entries.accept(AllItems.CUT_CRIMSITE);
        entries.accept(AllItems.CUT_CRIMSITE_STAIRS);
        entries.accept(AllItems.CUT_CRIMSITE_SLAB);
        entries.accept(AllItems.CUT_CRIMSITE_WALL);
        entries.accept(AllItems.POLISHED_CUT_CRIMSITE);
        entries.accept(AllItems.POLISHED_CUT_CRIMSITE_STAIRS);
        entries.accept(AllItems.POLISHED_CUT_CRIMSITE_SLAB);
        entries.accept(AllItems.POLISHED_CUT_CRIMSITE_WALL);
        entries.accept(AllItems.CUT_CRIMSITE_BRICKS);
        entries.accept(AllItems.CUT_CRIMSITE_BRICK_STAIRS);
        entries.accept(AllItems.CUT_CRIMSITE_BRICK_SLAB);
        entries.accept(AllItems.CUT_CRIMSITE_BRICK_WALL);
        entries.accept(AllItems.SMALL_CRIMSITE_BRICKS);
        entries.accept(AllItems.SMALL_CRIMSITE_BRICK_STAIRS);
        entries.accept(AllItems.SMALL_CRIMSITE_BRICK_SLAB);
        entries.accept(AllItems.SMALL_CRIMSITE_BRICK_WALL);
        entries.accept(AllItems.LAYERED_CRIMSITE);
        entries.accept(AllItems.CRIMSITE_PILLAR);
        entries.accept(AllItems.LIMESTONE);
        entries.accept(AllItems.CUT_LIMESTONE);
        entries.accept(AllItems.CUT_LIMESTONE_STAIRS);
        entries.accept(AllItems.CUT_LIMESTONE_SLAB);
        entries.accept(AllItems.CUT_LIMESTONE_WALL);
        entries.accept(AllItems.POLISHED_CUT_LIMESTONE);
        entries.accept(AllItems.POLISHED_CUT_LIMESTONE_STAIRS);
        entries.accept(AllItems.POLISHED_CUT_LIMESTONE_SLAB);
        entries.accept(AllItems.POLISHED_CUT_LIMESTONE_WALL);
        entries.accept(AllItems.CUT_LIMESTONE_BRICKS);
        entries.accept(AllItems.CUT_LIMESTONE_BRICK_STAIRS);
        entries.accept(AllItems.CUT_LIMESTONE_BRICK_SLAB);
        entries.accept(AllItems.CUT_LIMESTONE_BRICK_WALL);
        entries.accept(AllItems.SMALL_LIMESTONE_BRICKS);
        entries.accept(AllItems.SMALL_LIMESTONE_BRICK_STAIRS);
        entries.accept(AllItems.SMALL_LIMESTONE_BRICK_SLAB);
        entries.accept(AllItems.SMALL_LIMESTONE_BRICK_WALL);
        entries.accept(AllItems.LAYERED_LIMESTONE);
        entries.accept(AllItems.LIMESTONE_PILLAR);
        entries.accept(AllItems.OCHRUM);
        entries.accept(AllItems.CUT_OCHRUM);
        entries.accept(AllItems.CUT_OCHRUM_STAIRS);
        entries.accept(AllItems.CUT_OCHRUM_SLAB);
        entries.accept(AllItems.CUT_OCHRUM_WALL);
        entries.accept(AllItems.POLISHED_CUT_OCHRUM);
        entries.accept(AllItems.POLISHED_CUT_OCHRUM_STAIRS);
        entries.accept(AllItems.POLISHED_CUT_OCHRUM_SLAB);
        entries.accept(AllItems.POLISHED_CUT_OCHRUM_WALL);
        entries.accept(AllItems.CUT_OCHRUM_BRICKS);
        entries.accept(AllItems.CUT_OCHRUM_BRICK_STAIRS);
        entries.accept(AllItems.CUT_OCHRUM_BRICK_SLAB);
        entries.accept(AllItems.CUT_OCHRUM_BRICK_WALL);
        entries.accept(AllItems.SMALL_OCHRUM_BRICKS);
        entries.accept(AllItems.SMALL_OCHRUM_BRICK_STAIRS);
        entries.accept(AllItems.SMALL_OCHRUM_BRICK_SLAB);
        entries.accept(AllItems.SMALL_OCHRUM_BRICK_WALL);
        entries.accept(AllItems.LAYERED_OCHRUM);
        entries.accept(AllItems.OCHRUM_PILLAR);
        entries.accept(AllItems.SCORIA);
        entries.accept(AllItems.CUT_SCORIA);
        entries.accept(AllItems.CUT_SCORIA_STAIRS);
        entries.accept(AllItems.CUT_SCORIA_SLAB);
        entries.accept(AllItems.CUT_SCORIA_WALL);
        entries.accept(AllItems.POLISHED_CUT_SCORIA);
        entries.accept(AllItems.POLISHED_CUT_SCORIA_STAIRS);
        entries.accept(AllItems.POLISHED_CUT_SCORIA_SLAB);
        entries.accept(AllItems.POLISHED_CUT_SCORIA_WALL);
        entries.accept(AllItems.CUT_SCORIA_BRICKS);
        entries.accept(AllItems.CUT_SCORIA_BRICK_STAIRS);
        entries.accept(AllItems.CUT_SCORIA_BRICK_SLAB);
        entries.accept(AllItems.CUT_SCORIA_BRICK_WALL);
        entries.accept(AllItems.SMALL_SCORIA_BRICKS);
        entries.accept(AllItems.SMALL_SCORIA_BRICK_STAIRS);
        entries.accept(AllItems.SMALL_SCORIA_BRICK_SLAB);
        entries.accept(AllItems.SMALL_SCORIA_BRICK_WALL);
        entries.accept(AllItems.LAYERED_SCORIA);
        entries.accept(AllItems.SCORIA_PILLAR);
        entries.accept(AllItems.SCORCHIA);
        entries.accept(AllItems.CUT_SCORCHIA);
        entries.accept(AllItems.CUT_SCORCHIA_STAIRS);
        entries.accept(AllItems.CUT_SCORCHIA_SLAB);
        entries.accept(AllItems.CUT_SCORCHIA_WALL);
        entries.accept(AllItems.POLISHED_CUT_SCORCHIA);
        entries.accept(AllItems.POLISHED_CUT_SCORCHIA_STAIRS);
        entries.accept(AllItems.POLISHED_CUT_SCORCHIA_SLAB);
        entries.accept(AllItems.POLISHED_CUT_SCORCHIA_WALL);
        entries.accept(AllItems.CUT_SCORCHIA_BRICKS);
        entries.accept(AllItems.CUT_SCORCHIA_BRICK_STAIRS);
        entries.accept(AllItems.CUT_SCORCHIA_BRICK_SLAB);
        entries.accept(AllItems.CUT_SCORCHIA_BRICK_WALL);
        entries.accept(AllItems.SMALL_SCORCHIA_BRICKS);
        entries.accept(AllItems.SMALL_SCORCHIA_BRICK_STAIRS);
        entries.accept(AllItems.SMALL_SCORCHIA_BRICK_SLAB);
        entries.accept(AllItems.SMALL_SCORCHIA_BRICK_WALL);
        entries.accept(AllItems.LAYERED_SCORCHIA);
        entries.accept(AllItems.SCORCHIA_PILLAR);
        entries.accept(AllItems.VERIDIUM);
        entries.accept(AllItems.CUT_VERIDIUM);
        entries.accept(AllItems.CUT_VERIDIUM_STAIRS);
        entries.accept(AllItems.CUT_VERIDIUM_SLAB);
        entries.accept(AllItems.CUT_VERIDIUM_WALL);
        entries.accept(AllItems.POLISHED_CUT_VERIDIUM);
        entries.accept(AllItems.POLISHED_CUT_VERIDIUM_STAIRS);
        entries.accept(AllItems.POLISHED_CUT_VERIDIUM_SLAB);
        entries.accept(AllItems.POLISHED_CUT_VERIDIUM_WALL);
        entries.accept(AllItems.CUT_VERIDIUM_BRICKS);
        entries.accept(AllItems.CUT_VERIDIUM_BRICK_STAIRS);
        entries.accept(AllItems.CUT_VERIDIUM_BRICK_SLAB);
        entries.accept(AllItems.CUT_VERIDIUM_BRICK_WALL);
        entries.accept(AllItems.SMALL_VERIDIUM_BRICKS);
        entries.accept(AllItems.SMALL_VERIDIUM_BRICK_STAIRS);
        entries.accept(AllItems.SMALL_VERIDIUM_BRICK_SLAB);
        entries.accept(AllItems.SMALL_VERIDIUM_BRICK_WALL);
        entries.accept(AllItems.LAYERED_VERIDIUM);
        entries.accept(AllItems.VERIDIUM_PILLAR);

        entries.accept(AllItems.WHITE_SEAT, CreativeModeTab.TabVisibility.SEARCH_TAB_ONLY);
        entries.accept(AllItems.ORANGE_SEAT, CreativeModeTab.TabVisibility.SEARCH_TAB_ONLY);
        entries.accept(AllItems.MAGENTA_SEAT, CreativeModeTab.TabVisibility.SEARCH_TAB_ONLY);
        entries.accept(AllItems.LIGHT_BLUE_SEAT, CreativeModeTab.TabVisibility.SEARCH_TAB_ONLY);
        entries.accept(AllItems.YELLOW_SEAT, CreativeModeTab.TabVisibility.SEARCH_TAB_ONLY);
        entries.accept(AllItems.LIME_SEAT, CreativeModeTab.TabVisibility.SEARCH_TAB_ONLY);
        entries.accept(AllItems.PINK_SEAT, CreativeModeTab.TabVisibility.SEARCH_TAB_ONLY);
        entries.accept(AllItems.GRAY_SEAT, CreativeModeTab.TabVisibility.SEARCH_TAB_ONLY);
        entries.accept(AllItems.LIGHT_GRAY_SEAT, CreativeModeTab.TabVisibility.SEARCH_TAB_ONLY);
        entries.accept(AllItems.CYAN_SEAT, CreativeModeTab.TabVisibility.SEARCH_TAB_ONLY);
        entries.accept(AllItems.PURPLE_SEAT, CreativeModeTab.TabVisibility.SEARCH_TAB_ONLY);
        entries.accept(AllItems.BLUE_SEAT, CreativeModeTab.TabVisibility.SEARCH_TAB_ONLY);
        entries.accept(AllItems.BROWN_SEAT, CreativeModeTab.TabVisibility.SEARCH_TAB_ONLY);
        entries.accept(AllItems.GREEN_SEAT, CreativeModeTab.TabVisibility.SEARCH_TAB_ONLY);
        entries.accept(AllItems.BLACK_SEAT, CreativeModeTab.TabVisibility.SEARCH_TAB_ONLY);
        entries.accept(AllItems.WHITE_TABLE_CLOTH, CreativeModeTab.TabVisibility.SEARCH_TAB_ONLY);
        entries.accept(AllItems.ORANGE_TABLE_CLOTH, CreativeModeTab.TabVisibility.SEARCH_TAB_ONLY);
        entries.accept(AllItems.MAGENTA_TABLE_CLOTH, CreativeModeTab.TabVisibility.SEARCH_TAB_ONLY);
        entries.accept(AllItems.LIGHT_BLUE_TABLE_CLOTH, CreativeModeTab.TabVisibility.SEARCH_TAB_ONLY);
        entries.accept(AllItems.YELLOW_TABLE_CLOTH, CreativeModeTab.TabVisibility.SEARCH_TAB_ONLY);
        entries.accept(AllItems.LIME_TABLE_CLOTH, CreativeModeTab.TabVisibility.SEARCH_TAB_ONLY);
        entries.accept(AllItems.PINK_TABLE_CLOTH, CreativeModeTab.TabVisibility.SEARCH_TAB_ONLY);
        entries.accept(AllItems.GRAY_TABLE_CLOTH, CreativeModeTab.TabVisibility.SEARCH_TAB_ONLY);
        entries.accept(AllItems.LIGHT_GRAY_TABLE_CLOTH, CreativeModeTab.TabVisibility.SEARCH_TAB_ONLY);
        entries.accept(AllItems.CYAN_TABLE_CLOTH, CreativeModeTab.TabVisibility.SEARCH_TAB_ONLY);
        entries.accept(AllItems.PURPLE_TABLE_CLOTH, CreativeModeTab.TabVisibility.SEARCH_TAB_ONLY);
        entries.accept(AllItems.BLUE_TABLE_CLOTH, CreativeModeTab.TabVisibility.SEARCH_TAB_ONLY);
        entries.accept(AllItems.BROWN_TABLE_CLOTH, CreativeModeTab.TabVisibility.SEARCH_TAB_ONLY);
        entries.accept(AllItems.GREEN_TABLE_CLOTH, CreativeModeTab.TabVisibility.SEARCH_TAB_ONLY);
        entries.accept(AllItems.BLACK_TABLE_CLOTH, CreativeModeTab.TabVisibility.SEARCH_TAB_ONLY);
    }
}
