package com.zurrtum.create.client.content.kinetics.base;

import com.zurrtum.create.client.flywheel.api.visualization.VisualizationContext;
import com.zurrtum.create.client.flywheel.lib.visual.AbstractBlockEntityVisual;
import com.zurrtum.create.content.kinetics.base.IRotate;
import com.zurrtum.create.content.kinetics.base.KineticBlockEntity;
import com.zurrtum.create.content.kinetics.simpleRelays.ICogWheel;
import net.minecraft.core.Direction.Axis;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.block.state.BlockState;

public abstract class KineticBlockEntityVisual<T extends KineticBlockEntity> extends AbstractBlockEntityVisual<T> {

    public KineticBlockEntityVisual(VisualizationContext context, T blockEntity, float partialTick) {
        super(context, blockEntity, partialTick);
    }

    protected Axis rotationAxis() {
        return rotationAxis(blockState);
    }

    public static float rotationOffset(BlockState state, Axis axis, Vec3i pos) {
        if (shouldOffset(axis, pos)) {
            return 22.5f;
        } else {
            return ICogWheel.isLargeCog(state) ? 11.25f : 0;
        }
    }

    public static boolean shouldOffset(Axis axis, Vec3i pos) {
        // Sum the components of the other 2 axes.
        int x = (axis == Axis.X) ? 0 : pos.getX();
        int y = (axis == Axis.Y) ? 0 : pos.getY();
        int z = (axis == Axis.Z) ? 0 : pos.getZ();
        return ((x + y + z) % 2) == 0;
    }

    public static Axis rotationAxis(BlockState blockState) {
        return (blockState.getBlock() instanceof IRotate irotate) ? irotate.getRotationAxis(blockState) : Axis.Y;
    }
}
