package com.zurrtum.create.client.content.schematics.client.tools;

import com.mojang.blaze3d.vertex.PoseStack;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.client.AllKeys;
import com.zurrtum.create.client.AllSpecialTextures;
import com.zurrtum.create.client.Create;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.catnip.outliner.AABBOutline;
import com.zurrtum.create.client.catnip.render.SuperRenderTypeBuffer;
import com.zurrtum.create.client.content.schematics.client.SchematicHandler;
import com.zurrtum.create.client.content.schematics.client.SchematicTransformation;
import com.zurrtum.create.client.foundation.utility.RaycastHelper;
import com.zurrtum.create.client.foundation.utility.RaycastHelper.PredicateTraceResult;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult.Type;
import net.minecraft.world.phys.Vec3;

public abstract class SchematicToolBase implements ISchematicTool {

    protected SchematicHandler schematicHandler;

    protected BlockPos selectedPos;
    protected Vec3 chasingSelectedPos;
    protected Vec3 lastChasingSelectedPos;

    protected boolean selectIgnoreBlocks;
    protected int selectionRange;
    protected boolean schematicSelected;
    protected boolean renderSelectedFace;
    protected Direction selectedFace;

    @Override
    public void init() {
        schematicHandler = Create.SCHEMATIC_HANDLER;
        selectedPos = null;
        selectedFace = null;
        schematicSelected = false;
        chasingSelectedPos = Vec3.ZERO;
        lastChasingSelectedPos = Vec3.ZERO;
    }

    @Override
    public void updateSelection(Minecraft mc) {
        updateTargetPos();

        if (selectedPos == null)
            return;
        lastChasingSelectedPos = chasingSelectedPos;
        Vec3 target = Vec3.atLowerCornerOf(selectedPos);
        if (target.distanceTo(chasingSelectedPos) < 1 / 512f) {
            chasingSelectedPos = target;
            return;
        }

        chasingSelectedPos = chasingSelectedPos.add(target.subtract(chasingSelectedPos).scale(1 / 2f));
    }

    public void updateTargetPos() {
        LocalPlayer player = Minecraft.getInstance().player;

        // Select Blueprint
        if (schematicHandler.isDeployed()) {
            SchematicTransformation transformation = schematicHandler.getTransformation();
            AABB localBounds = schematicHandler.getBounds();

            Vec3 traceOrigin = player.getEyePosition();
            Vec3 start = transformation.toLocalSpace(traceOrigin);
            Vec3 end = transformation.toLocalSpace(RaycastHelper.getTraceTarget(player, 70, traceOrigin));
            PredicateTraceResult result = RaycastHelper.rayTraceUntil(start, end, pos -> localBounds.contains(VecHelper.getCenterOf(pos)));

            schematicSelected = !result.missed();
            selectedFace = schematicSelected ? result.getFacing() : null;
        }

        boolean snap = this.selectedPos == null;

        // Select location at distance
        if (selectIgnoreBlocks) {
            float pt = AnimationTickHolder.getPartialTicks();
            selectedPos = BlockPos.containing(player.getEyePosition(pt).add(player.getLookAngle().scale(selectionRange)));
            if (snap)
                lastChasingSelectedPos = chasingSelectedPos = Vec3.atLowerCornerOf(selectedPos);
            return;
        }

        // Select targeted Block
        selectedPos = null;
        BlockHitResult trace = RaycastHelper.rayTraceRange(player.level(), player, 75);
        if (trace == null || trace.getType() != Type.BLOCK)
            return;

        BlockPos hit = BlockPos.containing(trace.getLocation());
        boolean replaceable = player.level().getBlockState(hit).canBeReplaced();
        if (trace.getDirection().getAxis().isVertical() && !replaceable)
            hit = hit.relative(trace.getDirection());
        selectedPos = hit;
        if (snap)
            lastChasingSelectedPos = chasingSelectedPos = Vec3.atLowerCornerOf(selectedPos);
    }

    @Override
    public void renderTool(Minecraft mc, PoseStack ms, SuperRenderTypeBuffer buffer, Vec3 camera) {
    }

    @Override
    public void renderOverlay(Gui gui, GuiGraphics graphics, float partialTicks, int width, int height) {
    }

    @Override
    public void renderOnSchematic(Minecraft mc, PoseStack ms, SuperRenderTypeBuffer buffer) {
        if (!schematicHandler.isDeployed())
            return;

        ms.pushPose();
        AABBOutline outline = schematicHandler.getOutline();
        if (renderSelectedFace) {
            outline.getParams().highlightFace(selectedFace).withFaceTextures(
                AllSpecialTextures.CHECKERED,
                AllKeys.hasControlDown() ? AllSpecialTextures.HIGHLIGHT_CHECKERED : AllSpecialTextures.CHECKERED
            );
        }
        outline.getParams().colored(0x6886c5).withFaceTexture(AllSpecialTextures.CHECKERED).lineWidth(1 / 16f);
        outline.render(Minecraft.getInstance(), ms, buffer, Vec3.ZERO, AnimationTickHolder.getPartialTicks());
        outline.getParams().clearTextures();
        ms.popPose();
    }

}
