package com.zurrtum.create.content.logistics.packagePort.postbox;

import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllSoundEvents;
import com.zurrtum.create.catnip.animation.LerpedFloat;
import com.zurrtum.create.catnip.animation.LerpedFloat.Chaser;
import com.zurrtum.create.content.logistics.packagePort.PackagePortBlockEntity;
import com.zurrtum.create.content.trains.station.GlobalPackagePort;
import com.zurrtum.create.content.trains.station.GlobalStation;

import java.lang.ref.WeakReference;

import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.item.BoneMealItem;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;

public class PostboxBlockEntity extends PackagePortBlockEntity {

    public WeakReference<GlobalStation> trackedGlobalStation;

    public LerpedFloat flag;
    public boolean forceFlag;

    private boolean sendParticles;

    //TODO
    //    public AbstractComputerBehaviour computerBehaviour;

    public PostboxBlockEntity(BlockPos pos, BlockState state) {
        super(AllBlockEntityTypes.PACKAGE_POSTBOX, pos, state);
        trackedGlobalStation = new WeakReference<>(null);
        flag = LerpedFloat.linear().startWithValue(0);
    }

    //TODO
    //    @Override
    //    public void addBehaviours(List<BlockEntityBehaviour<?>> behaviours) {
    //        behaviours.add(computerBehaviour = ComputerCraftProxy.behaviour(this));
    //        super.addBehaviours(behaviours);
    //    }

    @Override
    public void tick() {
        super.tick();
        if (!level.isClientSide() && !isVirtual()) {
            if (sendParticles)
                sendData();
            return;
        }

        float currentTarget = flag.getChaseTarget();
        if (currentTarget == 0 || flag.settled()) {
            int target = (inventory.isEmpty() && !forceFlag) ? 0 : 1;
            if (target != currentTarget) {
                flag.chase(target, 0.1f, Chaser.LINEAR);
                if (target == 1)
                    AllSoundEvents.CONTRAPTION_ASSEMBLE.playAt(level, worldPosition, 1, 2, true);
            }
        }
        boolean settled = flag.getValue() > .15f;
        flag.tickChaser();
        if (currentTarget == 0 && settled != flag.getValue() > .15f)
            AllSoundEvents.CONTRAPTION_DISASSEMBLE.playAt(level, worldPosition, 0.75f, 1.5f, true);

        if (sendParticles) {
            sendParticles = false;
            BoneMealItem.addGrowthParticles(level, worldPosition, 40);
        }
    }

    @Override
    protected void onOpenChange(boolean open) {
        level.setBlockAndUpdate(worldPosition, getBlockState().setValue(PostboxBlock.OPEN, open));
        level.playSound(null, worldPosition, open ? SoundEvents.BARREL_OPEN : SoundEvents.BARREL_CLOSE, SoundSource.BLOCKS);
    }

    public void spawnParticles() {
        sendParticles = true;
    }

    @Override
    protected void write(ValueOutput view, boolean clientPacket) {
        super.write(view, clientPacket);
        if (clientPacket && sendParticles)
            view.putBoolean("Particles", true);
        sendParticles = false;
    }

    @Override
    protected void read(ValueInput view, boolean clientPacket) {
        super.read(view, clientPacket);
        sendParticles = clientPacket && view.getBooleanOr("Particles", false);
    }

    @Override
    public void setChanged() {
        saveOfflineBuffer();
        super.setChanged();
    }

    private void saveOfflineBuffer() {
        if (level == null || level.isClientSide()) {
            return;
        }
        GlobalStation station = trackedGlobalStation.get();
        if (station == null) {
            return;
        }
        GlobalPackagePort globalPackagePort = station.connectedPorts.get(worldPosition);
        if (globalPackagePort == null) {
            return;
        }
        globalPackagePort.saveOfflineBuffer(inventory);
    }

    //TODO
    //    @Override
    //    public void invalidate() {
    //        super.invalidate();
    //        computerBehaviour.removePeripheral();
    //    }
}