/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create;

import com.zurrtum.create.content.equipment.sandPaper.SandPaperPolishingRecipe;
import com.zurrtum.create.content.fluids.transfer.EmptyingRecipe;
import com.zurrtum.create.content.fluids.transfer.FillingRecipe;
import com.zurrtum.create.content.kinetics.crafter.MechanicalCraftingRecipe;
import com.zurrtum.create.content.kinetics.crusher.CrushingRecipe;
import com.zurrtum.create.content.kinetics.deployer.DeployerApplicationRecipe;
import com.zurrtum.create.content.kinetics.deployer.ItemApplicationRecipe;
import com.zurrtum.create.content.kinetics.deployer.ManualApplicationRecipe;
import com.zurrtum.create.content.kinetics.fan.processing.HauntingRecipe;
import com.zurrtum.create.content.kinetics.fan.processing.SplashingRecipe;
import com.zurrtum.create.content.kinetics.millstone.MillingRecipe;
import com.zurrtum.create.content.kinetics.mixer.CompactingRecipe;
import com.zurrtum.create.content.kinetics.mixer.MixingRecipe;
import com.zurrtum.create.content.kinetics.mixer.PotionRecipe;
import com.zurrtum.create.content.kinetics.press.PressingRecipe;
import com.zurrtum.create.content.kinetics.saw.CuttingRecipe;
import com.zurrtum.create.content.processing.sequenced.SequencedAssemblyRecipe;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;

public class AllRecipeTypes {
    public static final List<RecipeType<? extends ItemApplicationRecipe>> DEPLOYER_RECIPES = new ArrayList<RecipeType<? extends ItemApplicationRecipe>>();
    public static final RecipeType<CrushingRecipe> CRUSHING = AllRecipeTypes.register("crushing");
    public static final RecipeType<CuttingRecipe> CUTTING = AllRecipeTypes.register("cutting");
    public static final RecipeType<MillingRecipe> MILLING = AllRecipeTypes.register("milling");
    public static final RecipeType<MixingRecipe> MIXING = AllRecipeTypes.register("mixing");
    public static final RecipeType<CompactingRecipe> COMPACTING = AllRecipeTypes.register("compacting");
    public static final RecipeType<PressingRecipe> PRESSING = AllRecipeTypes.register("pressing");
    public static final RecipeType<SandPaperPolishingRecipe> SANDPAPER_POLISHING = AllRecipeTypes.register("sandpaper_polishing");
    public static final RecipeType<SplashingRecipe> SPLASHING = AllRecipeTypes.register("splashing");
    public static final RecipeType<HauntingRecipe> HAUNTING = AllRecipeTypes.register("haunting");
    public static final RecipeType<DeployerApplicationRecipe> DEPLOYING = AllRecipeTypes.register("deploying");
    public static final RecipeType<FillingRecipe> FILLING = AllRecipeTypes.register("filling");
    public static final RecipeType<EmptyingRecipe> EMPTYING = AllRecipeTypes.register("emptying");
    public static final RecipeType<ManualApplicationRecipe> ITEM_APPLICATION = AllRecipeTypes.register("item_application");
    public static final RecipeType<MechanicalCraftingRecipe> MECHANICAL_CRAFTING = AllRecipeTypes.register("mechanical_crafting");
    public static final RecipeType<SequencedAssemblyRecipe> SEQUENCED_ASSEMBLY = AllRecipeTypes.register("sequenced_assembly");
    public static final RecipeType<PotionRecipe> POTION = AllRecipeTypes.register("potion");
    private static final TagKey<RecipeSerializer<?>> AUTOMATION_IGNORE_TAG = TagKey.create((ResourceKey)Registries.RECIPE_SERIALIZER, (Identifier)Identifier.fromNamespaceAndPath((String)"create", (String)"automation_ignore"));
    public static final Predicate<RecipeHolder<?>> CAN_BE_AUTOMATED = r -> !r.id().identifier().getPath().endsWith("_manual_only");

    public static boolean shouldIgnoreInAutomation(RecipeHolder<?> recipe) {
        RecipeSerializer serializer = recipe.value().getSerializer();
        if (serializer != null && BuiltInRegistries.RECIPE_SERIALIZER.wrapAsHolder((Object)serializer).is(AUTOMATION_IGNORE_TAG)) {
            return true;
        }
        return !CAN_BE_AUTOMATED.test(recipe);
    }

    private static <T extends Recipe<?>> RecipeType<T> register(String name) {
        final Identifier id = Identifier.fromNamespaceAndPath((String)"create", (String)name);
        return (RecipeType)Registry.register((Registry)BuiltInRegistries.RECIPE_TYPE, (Identifier)id, (Object)new RecipeType<T>(){

            public String toString() {
                return id.toString();
            }
        });
    }

    public static void register() {
        DEPLOYER_RECIPES.add(DEPLOYING);
        DEPLOYER_RECIPES.add(ITEM_APPLICATION);
    }
}

