/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client;

import com.zurrtum.create.AllMovementBehaviours;
import com.zurrtum.create.api.behaviour.movement.MovementBehaviour;
import com.zurrtum.create.client.api.behaviour.movement.MovementRenderBehaviour;
import com.zurrtum.create.client.content.contraptions.actors.contraptionControls.ContraptionControlsMovementRender;
import com.zurrtum.create.client.content.contraptions.actors.harvester.HarvesterMovementRenderBehaviour;
import com.zurrtum.create.client.content.contraptions.actors.psi.PortableStorageInterfaceMovementRender;
import com.zurrtum.create.client.content.contraptions.actors.roller.RollerMovementRenderBehaviour;
import com.zurrtum.create.client.content.contraptions.actors.trainControls.ControlsMovementRenderBehaviour;
import com.zurrtum.create.client.content.contraptions.bearing.StabilizedBearingMovementRenderBehaviour;
import com.zurrtum.create.client.content.kinetics.deployer.DeployerMovementRenderBehaviour;
import com.zurrtum.create.client.content.kinetics.drill.DrillMovementRenderBehaviour;
import com.zurrtum.create.client.content.kinetics.saw.SawMovementRenderBehaviour;
import com.zurrtum.create.client.content.processing.burner.BlazeBurnerMovementRenderBehaviour;
import java.util.function.Supplier;

public class AllMovementRenders {
    private static void register(MovementBehaviour behaviour, Supplier<MovementRenderBehaviour> factory) {
        behaviour.attachRender = factory.get();
    }

    public static void register() {
        AllMovementRenders.register(AllMovementBehaviours.MECHANICAL_HARVESTER, HarvesterMovementRenderBehaviour::new);
        AllMovementRenders.register(AllMovementBehaviours.MECHANICAL_BEARING, StabilizedBearingMovementRenderBehaviour::new);
        AllMovementRenders.register(AllMovementBehaviours.PORTABLE_FLUID_INTERFACE, PortableStorageInterfaceMovementRender::new);
        AllMovementRenders.register(AllMovementBehaviours.PORTABLE_STORAGE_INTERFACE, PortableStorageInterfaceMovementRender::new);
        AllMovementRenders.register(AllMovementBehaviours.DEPLOYER, DeployerMovementRenderBehaviour::new);
        AllMovementRenders.register(AllMovementBehaviours.MECHANICAL_DRILL, DrillMovementRenderBehaviour::new);
        AllMovementRenders.register(AllMovementBehaviours.CONTRAPTION_CONTROLS, ContraptionControlsMovementRender::new);
        AllMovementRenders.register(AllMovementBehaviours.MECHANICAL_SAW, SawMovementRenderBehaviour::new);
        AllMovementRenders.register(AllMovementBehaviours.TRAIN_CONTROLS, ControlsMovementRenderBehaviour::new);
        AllMovementRenders.register(AllMovementBehaviours.BLAZE_BURNER, BlazeBurnerMovementRenderBehaviour::new);
        AllMovementRenders.register(AllMovementBehaviours.MECHANICAL_ROLLER, RollerMovementRenderBehaviour::new);
    }
}

