/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.catnip.animation;

import com.zurrtum.create.client.catnip.levelWrappers.WrappedClientLevel;
import com.zurrtum.create.client.ponder.api.level.PonderLevel;
import com.zurrtum.create.client.ponder.foundation.ui.PonderUI;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.world.level.LevelAccessor;

public class AnimationTickHolder {
    private static int ticks;
    private static int pausedTicks;

    public static void reset() {
        ticks = 0;
        pausedTicks = 0;
    }

    public static void tick() {
        if (!Minecraft.getInstance().isPaused()) {
            ticks = (ticks + 1) % 1728000;
        } else {
            pausedTicks = (pausedTicks + 1) % 1728000;
        }
    }

    public static int getTicks() {
        return AnimationTickHolder.getTicks(false);
    }

    public static int getTicks(boolean includePaused) {
        return includePaused ? ticks + pausedTicks : ticks;
    }

    public static int getTicks(LevelAccessor level) {
        if (level instanceof WrappedClientLevel) {
            WrappedClientLevel wrappedLevel = (WrappedClientLevel)level;
            return AnimationTickHolder.getTicks((LevelAccessor)wrappedLevel.getWrappedLevel());
        }
        if (level instanceof PonderLevel) {
            return PonderUI.ponderTicks;
        }
        return AnimationTickHolder.getTicks();
    }

    public static float getPartialTicks(LevelAccessor level) {
        if (level instanceof PonderLevel) {
            return PonderUI.getPartialTicks();
        }
        return AnimationTickHolder.getPartialTicks();
    }

    public static float getRenderTime() {
        return (float)AnimationTickHolder.getTicks() + AnimationTickHolder.getPartialTicks();
    }

    public static float getRenderTime(LevelAccessor level) {
        return (float)AnimationTickHolder.getTicks(level) + AnimationTickHolder.getPartialTicks(level);
    }

    public static float getPartialTicks() {
        Minecraft mc = Minecraft.getInstance();
        return mc.getDeltaTracker().getGameTimeDeltaPartialTick(false);
    }

    public static float getPartialTicksUI(DeltaTracker timer) {
        if (timer instanceof DeltaTracker.Timer) {
            DeltaTracker.Timer timerAccessor = (DeltaTracker.Timer)timer;
            return timerAccessor.deltaTickResidual;
        }
        return timer.getGameTimeDeltaPartialTick(false);
    }
}

