/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.catnip.gui;

import com.zurrtum.create.catnip.theme.Color;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.catnip.gui.NavigatableSimiScreen;
import com.zurrtum.create.client.catnip.gui.TickableGuiEventListener;
import com.zurrtum.create.client.catnip.gui.widget.AbstractSimiWidget;
import java.util.Collection;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import org.joml.Matrix3x2fStack;

public abstract class AbstractSimiScreen
extends Screen {
    protected static final Color BACKGROUND_COLOR = new Color(0x50101010, true);
    protected int windowWidth;
    protected int windowHeight;
    protected int windowXOffset;
    protected int windowYOffset;
    protected int guiLeft;
    protected int guiTop;

    protected AbstractSimiScreen(Component title) {
        super(title);
    }

    protected AbstractSimiScreen() {
        this(CommonComponents.EMPTY);
    }

    protected void setWindowSize(int width, int height) {
        this.windowWidth = width;
        this.windowHeight = height;
    }

    protected void setWindowOffset(int xOffset, int yOffset) {
        this.windowXOffset = xOffset;
        this.windowYOffset = yOffset;
    }

    protected void init() {
        this.guiLeft = (this.width - this.windowWidth) / 2;
        this.guiTop = (this.height - this.windowHeight) / 2;
        this.guiLeft += this.windowXOffset;
        this.guiTop += this.windowYOffset;
    }

    public void tick() {
        for (GuiEventListener listener : this.children()) {
            if (!(listener instanceof TickableGuiEventListener)) continue;
            TickableGuiEventListener tickable = (TickableGuiEventListener)listener;
            tickable.tick();
        }
    }

    public boolean isPauseScreen() {
        return false;
    }

    protected <W extends GuiEventListener & Renderable> void addRenderableWidgets(W ... widgets) {
        for (W widget : widgets) {
            this.addRenderableWidget((GuiEventListener)widget);
        }
    }

    protected <W extends GuiEventListener & Renderable> void addRenderableWidgets(Collection<W> widgets) {
        for (GuiEventListener widget : widgets) {
            this.addRenderableWidget(widget);
        }
    }

    protected void removeWidgets(GuiEventListener ... widgets) {
        for (GuiEventListener widget : widgets) {
            this.removeWidget(widget);
        }
    }

    protected void removeWidgets(Collection<? extends GuiEventListener> widgets) {
        for (GuiEventListener guiEventListener : widgets) {
            this.removeWidget(guiEventListener);
        }
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        partialTicks = NavigatableSimiScreen.currentlyRenderingPreviousScreen ? 0.0f : AnimationTickHolder.getPartialTicksUI(this.minecraft.getDeltaTracker());
        Matrix3x2fStack poseStack = graphics.pose();
        poseStack.pushMatrix();
        this.prepareFrame();
        this.renderWindowBackground(graphics, mouseX, mouseY, partialTicks);
        this.renderWindow(graphics, mouseX, mouseY, partialTicks);
        for (Renderable renderable : this.getRenderables()) {
            renderable.render(graphics, mouseX, mouseY, partialTicks);
        }
        this.renderWindowForeground(graphics, mouseX, mouseY, partialTicks);
        this.endFrame();
        poseStack.popMatrix();
    }

    public boolean keyPressed(KeyEvent input) {
        boolean keyPressed = super.keyPressed(input);
        if (keyPressed || this.getFocused() != null) {
            return keyPressed;
        }
        if (this.minecraft.options.keyInventory.matches(input)) {
            this.onClose();
            return true;
        }
        boolean consumed = false;
        for (GuiEventListener widget : this.children()) {
            AbstractSimiWidget simiWidget;
            if (!(widget instanceof AbstractSimiWidget) || !(simiWidget = (AbstractSimiWidget)widget).keyPressed(input)) continue;
            consumed = true;
        }
        return consumed;
    }

    protected void prepareFrame() {
    }

    protected void renderWindowBackground(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.renderMenuBackground(graphics);
    }

    protected abstract void renderWindow(GuiGraphics var1, int var2, int var3, float var4);

    protected void renderWindowForeground(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
    }

    protected void endFrame() {
    }

    @Deprecated
    protected void debugWindowArea(GuiGraphics graphics) {
        graphics.fill(this.guiLeft + this.windowWidth, this.guiTop + this.windowHeight, this.guiLeft, this.guiTop, -741092397);
    }

    protected List<Renderable> getRenderables() {
        return this.renderables;
    }

    public GuiEventListener getFocused() {
        GuiEventListener focused = super.getFocused();
        if (focused instanceof AbstractWidget && !focused.isFocused()) {
            focused = null;
        }
        this.setFocused(focused);
        return focused;
    }
}

