/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.catnip.gui;

import com.zurrtum.create.catnip.animation.LerpedFloat;
import com.zurrtum.create.client.catnip.gui.NavigatableSimiScreen;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import org.jetbrains.annotations.Nullable;

public class ScreenOpener {
    private static final Deque<Screen> backStack = new ArrayDeque<Screen>();
    @Nullable
    private static Screen backSteppedFrom = null;

    public static void open(@Nullable Screen screen) {
        ScreenOpener.open(Minecraft.getInstance().screen, screen);
    }

    public static void open(@Nullable Screen current, @Nullable Screen toOpen) {
        backSteppedFrom = null;
        if (current != null) {
            if (backStack.size() >= 15) {
                backStack.pollLast();
            }
            backStack.push(current);
        } else {
            backStack.clear();
        }
        ScreenOpener.openScreen(toOpen);
    }

    public static void openPreviousScreen(Screen current, @Nullable NavigatableSimiScreen screenWithContext) {
        if (backStack.isEmpty()) {
            return;
        }
        backSteppedFrom = current;
        Screen previousScreen = backStack.pop();
        if (previousScreen instanceof NavigatableSimiScreen) {
            NavigatableSimiScreen previousNavScreen = (NavigatableSimiScreen)previousScreen;
            if (screenWithContext != null) {
                screenWithContext.shareContextWith(previousNavScreen);
            }
            previousNavScreen.transition.startWithValue(-0.001).chase(-1.0, 0.3f, LerpedFloat.Chaser.EXP);
        }
        ScreenOpener.openScreen(previousScreen);
    }

    public static void transitionTo(NavigatableSimiScreen screen) {
        if (ScreenOpener.tryBackTracking(screen)) {
            return;
        }
        screen.transition.startWithValue(0.001).chase(1.0, 0.3f, LerpedFloat.Chaser.EXP);
        ScreenOpener.open(screen);
    }

    private static boolean tryBackTracking(NavigatableSimiScreen screen) {
        List<Screen> screenHistory = ScreenOpener.getScreenHistory();
        if (screenHistory.isEmpty()) {
            return false;
        }
        Screen previouslyRenderedScreen = screenHistory.get(0);
        if (!(previouslyRenderedScreen instanceof NavigatableSimiScreen)) {
            return false;
        }
        if (!screen.isEquivalentTo((NavigatableSimiScreen)previouslyRenderedScreen)) {
            return false;
        }
        ScreenOpener.openPreviousScreen(Minecraft.getInstance().screen, screen);
        return true;
    }

    public static void clearStack() {
        backStack.clear();
    }

    public static List<Screen> getScreenHistory() {
        return new ArrayList<Screen>(backStack);
    }

    @Nullable
    public static Screen getBackStepScreen() {
        return backStack.peek();
    }

    @Nullable
    public static Screen getPreviouslyRenderedScreen() {
        return backSteppedFrom != null ? backSteppedFrom : backStack.peek();
    }

    private static void openScreen(@Nullable Screen screen) {
        Minecraft.getInstance().schedule(() -> {
            Minecraft.getInstance().setScreen(screen);
            Screen previouslyRenderedScreen = ScreenOpener.getPreviouslyRenderedScreen();
            if (previouslyRenderedScreen != null && screen instanceof NavigatableSimiScreen) {
                previouslyRenderedScreen.init(screen.width, screen.height);
            }
        });
    }
}

