/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.catnip.gui.element;

import com.mojang.blaze3d.vertex.PoseStack;
import com.zurrtum.create.client.catnip.gui.element.AbstractRenderElement;
import com.zurrtum.create.client.catnip.gui.render.BlockTransformElementRenderer;
import com.zurrtum.create.client.catnip.gui.render.BlockTransformRenderState;
import com.zurrtum.create.client.catnip.gui.render.ItemTransformElementRenderer;
import com.zurrtum.create.client.catnip.gui.render.ItemTransformRenderState;
import com.zurrtum.create.client.catnip.gui.render.PartialElementRenderer;
import com.zurrtum.create.client.catnip.gui.render.PartialRenderState;
import com.zurrtum.create.client.flywheel.lib.model.baked.PartialModel;
import java.util.function.BiConsumer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.render.state.pip.PictureInPictureRenderState;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import org.joml.Matrix3x2fStack;

public class GuiGameElement {
    public static GuiItemRenderBuilder of(ItemStack stack) {
        return new GuiItemRenderBuilder(stack);
    }

    public static GuiBlockStateRenderBuilder of(BlockState block) {
        return new GuiBlockStateRenderBuilder(block);
    }

    public static GuiPartialRenderBuilder partial() {
        return new GuiPartialRenderBuilder();
    }

    public static GuiPartialRenderBuilder of(PartialModel model) {
        return new GuiPartialRenderBuilder(model);
    }

    public static class GuiItemRenderBuilder
    extends GuiRenderBuilder<GuiItemRenderBuilder> {
        private final ItemStack stack;
        private Object key;

        public GuiItemRenderBuilder(ItemStack stack) {
            this.stack = stack;
        }

        @Override
        GuiItemRenderBuilder self() {
            return this;
        }

        @Override
        public void render(GuiGraphics graphics) {
            if (this.scale <= 1.0f && this.xRot == 0.0f && this.yRot == 0.0f && this.zRot == 0.0f) {
                if (this.scale == 1.0f) {
                    graphics.renderItem(this.stack, (int)this.x, (int)this.y);
                } else {
                    Matrix3x2fStack matrices = graphics.pose();
                    matrices.pushMatrix();
                    matrices.scale(this.scale);
                    graphics.renderItem(this.stack, (int)this.x, (int)this.y);
                    matrices.popMatrix();
                }
                return;
            }
            ItemTransformRenderState state = ItemTransformRenderState.create(graphics, this.stack, this.x, this.y, this.scale, this.padding, this.xRot, this.yRot, this.zRot);
            this.key = state.getKey();
            graphics.guiRenderState.submitPicturesInPictureState((PictureInPictureRenderState)state);
        }

        @Override
        public GuiItemRenderBuilder scale(float scale) {
            this.clear();
            return (GuiItemRenderBuilder)super.scale(scale);
        }

        @Override
        public GuiItemRenderBuilder padding(int padding) {
            this.clear();
            return (GuiItemRenderBuilder)super.padding(padding);
        }

        @Override
        public GuiItemRenderBuilder rotate(float x, float y, float z) {
            this.clear();
            return (GuiItemRenderBuilder)super.rotate(x, y, z);
        }

        @Override
        public void clear() {
            if (this.key != null) {
                ItemTransformElementRenderer.clear(this.key);
                this.key = null;
            }
        }
    }

    public static class GuiBlockStateRenderBuilder
    extends GuiRenderBuilder<GuiBlockStateRenderBuilder> {
        private final BlockState block;
        boolean rendering = false;

        public GuiBlockStateRenderBuilder(BlockState block) {
            this.block = block;
        }

        @Override
        GuiBlockStateRenderBuilder self() {
            return this;
        }

        @Override
        public void render(GuiGraphics graphics) {
            graphics.guiRenderState.submitPicturesInPictureState((PictureInPictureRenderState)BlockTransformRenderState.create(graphics, this.block, this.x, this.y, this.scale, this.padding, this.xRot, this.yRot, this.zRot));
            this.rendering = true;
        }

        @Override
        public GuiBlockStateRenderBuilder scale(float scale) {
            this.clear();
            return (GuiBlockStateRenderBuilder)super.scale(scale);
        }

        @Override
        public GuiBlockStateRenderBuilder padding(int padding) {
            this.clear();
            return (GuiBlockStateRenderBuilder)super.padding(padding);
        }

        @Override
        public GuiBlockStateRenderBuilder rotate(float x, float y, float z) {
            this.clear();
            return (GuiBlockStateRenderBuilder)super.rotate(x, y, z);
        }

        @Override
        public void clear() {
            if (this.rendering) {
                BlockTransformElementRenderer.clear(BlockTransformRenderState.getKey(this.block, this.scale, this.padding, this.xRot, this.yRot, this.zRot));
                this.rendering = false;
            }
        }
    }

    public static class GuiPartialRenderBuilder
    extends AbstractRenderElement {
        private final PartialRenderState state = new PartialRenderState();
        private PartialModel model;
        private float scale = 1.0f;
        private BiConsumer<PoseStack, Float> transform;
        private float partialTicks;
        private int padding;
        private float xLocal;
        private float yLocal;

        public GuiPartialRenderBuilder() {
        }

        public GuiPartialRenderBuilder(PartialModel model) {
            this.model = model;
        }

        @Override
        public void render(GuiGraphics graphics) {
            if (this.model == null) {
                return;
            }
            this.state.update(graphics, this.model, this.x, this.y, this.xLocal, this.yLocal, this.scale, this.padding, this.partialTicks, this.transform);
            graphics.guiRenderState.submitPicturesInPictureState((PictureInPictureRenderState)this.state);
        }

        public GuiPartialRenderBuilder scale(float scale) {
            this.scale = scale;
            return this;
        }

        public GuiPartialRenderBuilder transform(BiConsumer<PoseStack, Float> transform) {
            this.transform = transform;
            return this;
        }

        public GuiPartialRenderBuilder partial(PartialModel model) {
            this.model = model;
            return this;
        }

        public GuiPartialRenderBuilder padding(int padding) {
            this.padding = padding;
            return this;
        }

        public GuiPartialRenderBuilder atLocal(float x, float y) {
            this.xLocal = x;
            this.yLocal = y;
            return this;
        }

        public void markDirty() {
            this.state.dirty = true;
        }

        public void tick(float partialTicks) {
            this.partialTicks = partialTicks;
        }

        @Override
        public void clear() {
            PartialElementRenderer.clear(this.state);
        }
    }

    public static abstract class GuiRenderBuilder<T extends GuiRenderBuilder<T>>
    extends AbstractRenderElement {
        protected float xRot;
        protected float yRot;
        protected float zRot;
        protected float scale = 1.0f;
        protected int padding;

        abstract T self();

        public T padding(int padding) {
            this.padding = padding;
            return this.self();
        }

        public T rotate(float x, float y, float z) {
            this.xRot = (float)Math.PI / 180 * x;
            this.yRot = (float)Math.PI / 180 * y;
            this.zRot = (float)Math.PI / 180 * z;
            return this.self();
        }

        public T scale(float scale) {
            this.scale = scale;
            return this.self();
        }
    }
}

