/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.catnip.gui.render;

import com.mojang.blaze3d.ProjectionType;
import com.mojang.blaze3d.buffers.GpuBufferSlice;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.FilterMode;
import com.mojang.blaze3d.textures.GpuSampler;
import com.mojang.blaze3d.textures.GpuTextureView;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.zurrtum.create.client.catnip.gui.render.BlockTransformRenderState;
import com.zurrtum.create.client.catnip.gui.render.GpuTexture;
import com.zurrtum.create.client.flywheel.lib.model.baked.SinglePosVirtualBlockGetter;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.render.TextureSetup;
import net.minecraft.client.gui.render.pip.PictureInPictureRenderer;
import net.minecraft.client.gui.render.state.BlitRenderState;
import net.minecraft.client.gui.render.state.GuiRenderState;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.chunk.ChunkSectionLayer;
import net.minecraft.client.renderer.rendertype.RenderType;
import net.minecraft.client.renderer.rendertype.RenderTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RedstoneTorchBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Quaternionfc;

public class BlockTransformElementRenderer
extends PictureInPictureRenderer<BlockTransformRenderState> {
    private static final Map<Object, GpuTexture> TEXTURES = new HashMap<Object, GpuTexture>();
    private final PoseStack matrices = new PoseStack();
    private int windowScaleFactor;

    public BlockTransformElementRenderer(MultiBufferSource.BufferSource vertexConsumers) {
        super(vertexConsumers);
    }

    public static void clear(Object key) {
        GpuTexture texture = TEXTURES.remove(key);
        if (texture != null) {
            texture.close();
        }
    }

    public void prepare(BlockTransformRenderState block, GuiRenderState state, int windowScaleFactor) {
        Object key;
        GpuTexture texture;
        if (this.windowScaleFactor != windowScaleFactor) {
            this.windowScaleFactor = windowScaleFactor;
            TEXTURES.values().forEach(GpuTexture::close);
            TEXTURES.clear();
        }
        if ((texture = TEXTURES.get(key = block.getKey())) == null) {
            float size = block.scale() * (float)windowScaleFactor;
            texture = GpuTexture.create((int)size);
            TEXTURES.put(key, texture);
            RenderSystem.setProjectionMatrix((GpuBufferSlice)this.projectionMatrixBuffer.getBuffer(size, size), (ProjectionType)ProjectionType.ORTHOGRAPHIC);
            texture.prepare();
            this.matrices.pushPose();
            this.matrices.translate(size / 2.0f, size / 2.0f, 0.0f);
            if (block.padding() != 0) {
                size -= (float)(block.padding() * windowScaleFactor);
            }
            this.matrices.scale(size, size, size);
            if (block.zRot() != 0.0f) {
                this.matrices.mulPose((Quaternionfc)Axis.ZP.rotation(block.zRot()));
            }
            if (block.xRot() != 0.0f) {
                this.matrices.mulPose((Quaternionfc)Axis.XP.rotation(block.xRot()));
            }
            if (block.yRot() != 0.0f) {
                this.matrices.mulPose((Quaternionfc)Axis.YP.rotation(block.yRot()));
            }
            this.matrices.scale(1.0f, -1.0f, 1.0f);
            this.matrices.translate(-0.5f, -0.5f, -0.5f);
            Minecraft mc = Minecraft.getInstance();
            RenderType layer = block.state().is(Blocks.REDSTONE_TORCH) && (Boolean)block.state().getValue((Property)RedstoneTorchBlock.LIT) != false ? RenderTypes.cutoutMovingBlock() : (ItemBlockRenderTypes.getChunkRenderType((BlockState)block.state()) == ChunkSectionLayer.TRANSLUCENT ? Sheets.translucentItemSheet() : Sheets.cutoutBlockSheet());
            SinglePosVirtualBlockGetter world = SinglePosVirtualBlockGetter.createFullBright();
            world.blockState(block.state());
            mc.getBlockRenderer().renderBatched(block.state(), BlockPos.ZERO, (BlockAndTintGetter)world, this.matrices, this.bufferSource.getBuffer(layer), false, block.parts());
            this.bufferSource.endBatch();
            this.matrices.popPose();
            texture.clear();
        }
        state.submitBlitToCurrentLayer(new BlitRenderState(RenderPipelines.GUI_TEXTURED_PREMULTIPLIED_ALPHA, TextureSetup.singleTexture((GpuTextureView)texture.textureView(), (GpuSampler)RenderSystem.getSamplerCache().getRepeat(FilterMode.NEAREST)), block.pose(), block.x0(), block.y0(), block.x1(), block.y1(), 0.0f, 1.0f, 1.0f, 0.0f, -1, block.scissorArea(), null));
    }

    protected void renderToTexture(BlockTransformRenderState block, PoseStack matrices) {
    }

    protected String getTextureLabel() {
        return "Block Transform";
    }

    public Class<BlockTransformRenderState> getRenderStateClass() {
        return BlockTransformRenderState.class;
    }
}

