/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.catnip.gui.render;

import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.gui.render.state.pip.PictureInPictureRenderState;
import net.minecraft.client.renderer.block.model.BlockModelPart;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3x2f;
import org.joml.Matrix3x2fc;

public record BlockTransformRenderState(BlockState state, List<BlockModelPart> parts, Matrix3x2f pose, ScreenRectangle bounds, int x0, int y0, int x1, int y1, int padding, float scale, float xRot, float yRot, float zRot, @Nullable ScreenRectangle scissorArea) implements PictureInPictureRenderState
{
    public static BlockTransformRenderState create(GuiGraphics graphics, BlockState block, float x, float y, float scale, int padding, float xRot, float yRot, float zRot) {
        float size = scale * 16.0f + (float)padding;
        Minecraft mc = graphics.minecraft;
        List parts = mc.getBlockRenderer().getBlockModel(block).collectParts(mc.level.random);
        Matrix3x2f pose = new Matrix3x2f((Matrix3x2fc)graphics.pose());
        int x1 = (int)x;
        int y1 = (int)y;
        int x2 = (int)(x + size);
        int y2 = (int)(y + size);
        ScreenRectangle bounds = new ScreenRectangle(x1, y1, (int)size, (int)size).transformMaxBounds((Matrix3x2fc)pose);
        ScreenRectangle scissor = graphics.scissorStack.peek();
        if (scissor != null) {
            bounds = bounds.intersection(scissor);
        }
        return new BlockTransformRenderState(block, parts, pose, bounds, x1, y1, x2, y2, padding, size, xRot, yRot, zRot, scissor);
    }

    public Object getKey() {
        return List.of(this.state, Float.valueOf(this.scale), Integer.valueOf(this.padding), Float.valueOf(this.xRot), Float.valueOf(this.yRot), Float.valueOf(this.zRot));
    }

    public static Object getKey(BlockState state, float scale, int padding, float xRot, float yRot, float zRot) {
        return List.of(state, Float.valueOf(scale * 16.0f + (float)padding), Integer.valueOf(padding), Float.valueOf(xRot), Float.valueOf(yRot), Float.valueOf(zRot));
    }
}

