/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.catnip.gui.render;

import com.mojang.blaze3d.systems.GpuDevice;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.GpuTextureView;
import com.mojang.blaze3d.textures.TextureFormat;

public record GpuTexture(int width, int height, com.mojang.blaze3d.textures.GpuTexture texture, GpuTextureView textureView, com.mojang.blaze3d.textures.GpuTexture depthTexture, GpuTextureView depthTextureView) {
    public static GpuTexture create(int size) {
        return GpuTexture.create(size, size);
    }

    public static GpuTexture create(int width, int height) {
        GpuDevice gpuDevice = RenderSystem.getDevice();
        com.mojang.blaze3d.textures.GpuTexture texture = gpuDevice.createTexture(() -> "UI Item Transform texture", 12, TextureFormat.RGBA8, width, height, 1, 1);
        GpuTextureView textureView = gpuDevice.createTextureView(texture);
        com.mojang.blaze3d.textures.GpuTexture depthTexture = gpuDevice.createTexture(() -> "UI Item Transform depth texture", 8, TextureFormat.DEPTH32, width, height, 1, 1);
        GpuTextureView depthTextureView = gpuDevice.createTextureView(depthTexture);
        return new GpuTexture(width, height, texture, textureView, depthTexture, depthTextureView);
    }

    public void prepare() {
        RenderSystem.getDevice().createCommandEncoder().clearColorAndDepthTextures(this.texture, 0, this.depthTexture, 1.0);
        RenderSystem.outputColorTextureOverride = this.textureView;
        RenderSystem.outputDepthTextureOverride = this.depthTextureView;
    }

    public void clear() {
        RenderSystem.outputColorTextureOverride = null;
        RenderSystem.outputDepthTextureOverride = null;
    }

    public void close() {
        this.texture.close();
        this.textureView.close();
        this.depthTexture.close();
        this.depthTextureView.close();
    }
}

