/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.catnip.gui.render;

import com.mojang.blaze3d.ProjectionType;
import com.mojang.blaze3d.buffers.GpuBufferSlice;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.FilterMode;
import com.mojang.blaze3d.textures.GpuSampler;
import com.mojang.blaze3d.textures.GpuTextureView;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.zurrtum.create.client.catnip.gui.render.GpuTexture;
import com.zurrtum.create.client.catnip.gui.render.ItemTransformRenderState;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.render.TextureSetup;
import net.minecraft.client.gui.render.pip.PictureInPictureRenderer;
import net.minecraft.client.gui.render.state.BlitRenderState;
import net.minecraft.client.gui.render.state.GuiRenderState;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.SubmitNodeStorage;
import net.minecraft.client.renderer.feature.FeatureRenderDispatcher;
import net.minecraft.client.renderer.texture.OverlayTexture;
import org.joml.Quaternionfc;

public class ItemTransformElementRenderer
extends PictureInPictureRenderer<ItemTransformRenderState> {
    private static final Map<Object, GpuTexture> TEXTURES = new HashMap<Object, GpuTexture>();
    private final PoseStack matrices = new PoseStack();
    private int windowScaleFactor;

    public ItemTransformElementRenderer(MultiBufferSource.BufferSource vertexConsumers) {
        super(vertexConsumers);
    }

    public static void clear(Object key) {
        GpuTexture texture = TEXTURES.remove(key);
        if (texture != null) {
            texture.close();
        }
    }

    public void prepare(ItemTransformRenderState item, GuiRenderState state, int windowScaleFactor) {
        boolean draw;
        if (this.windowScaleFactor != windowScaleFactor) {
            this.windowScaleFactor = windowScaleFactor;
            TEXTURES.values().forEach(GpuTexture::close);
            TEXTURES.clear();
        }
        float size = item.scale() * (float)windowScaleFactor;
        Object key = item.getKey();
        GpuTexture texture = TEXTURES.get(key);
        if (texture == null) {
            texture = GpuTexture.create((int)size);
            TEXTURES.put(key, texture);
            draw = true;
        } else {
            draw = item.state().isAnimated();
        }
        if (draw) {
            RenderSystem.setProjectionMatrix((GpuBufferSlice)this.projectionMatrixBuffer.getBuffer(size, size), (ProjectionType)ProjectionType.ORTHOGRAPHIC);
            texture.prepare();
            this.matrices.pushPose();
            this.matrices.translate(size / 2.0f, size / 2.0f, 0.0f);
            if (item.padding() != 0) {
                size -= (float)(item.padding() * windowScaleFactor);
            }
            this.matrices.scale(size, -size, size);
            if (item.zRot() != 0.0f) {
                this.matrices.mulPose((Quaternionfc)Axis.ZP.rotation(item.zRot()));
            }
            if (item.xRot() != 0.0f) {
                this.matrices.mulPose((Quaternionfc)Axis.XP.rotation(item.xRot()));
            }
            if (item.yRot() != 0.0f) {
                this.matrices.mulPose((Quaternionfc)Axis.YP.rotation(item.yRot()));
            }
            boolean blockLight = item.state().usesBlockLight();
            Lighting lighting = Minecraft.getInstance().gameRenderer.getLighting();
            if (blockLight) {
                lighting.setupFor(Lighting.Entry.ITEMS_3D);
            } else {
                lighting.setupFor(Lighting.Entry.ITEMS_FLAT);
            }
            FeatureRenderDispatcher renderDispatcher = Minecraft.getInstance().gameRenderer.getFeatureRenderDispatcher();
            SubmitNodeStorage queue = renderDispatcher.getSubmitNodeStorage();
            item.state().submit(this.matrices, (SubmitNodeCollector)queue, 0xF000F0, OverlayTexture.NO_OVERLAY, 0);
            renderDispatcher.renderAllFeatures();
            this.bufferSource.endBatch();
            this.matrices.popPose();
            texture.clear();
        }
        state.submitBlitToCurrentLayer(new BlitRenderState(RenderPipelines.GUI_TEXTURED_PREMULTIPLIED_ALPHA, TextureSetup.singleTexture((GpuTextureView)texture.textureView(), (GpuSampler)RenderSystem.getSamplerCache().getRepeat(FilterMode.NEAREST)), item.pose(), item.x0(), item.y0(), item.x1(), item.y1(), 0.0f, 1.0f, 1.0f, 0.0f, -1, item.scissorArea(), null));
    }

    protected void renderToTexture(ItemTransformRenderState item, PoseStack matrices) {
    }

    protected String getTextureLabel() {
        return "Item Transform";
    }

    public Class<ItemTransformRenderState> getRenderStateClass() {
        return ItemTransformRenderState.class;
    }
}

