/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.catnip.gui.render;

import com.google.common.base.Supplier;
import com.mojang.blaze3d.ProjectionType;
import com.mojang.blaze3d.buffers.GpuBufferSlice;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.FilterMode;
import com.mojang.blaze3d.textures.GpuSampler;
import com.mojang.blaze3d.textures.GpuTextureView;
import com.mojang.blaze3d.vertex.PoseStack;
import com.zurrtum.create.client.catnip.gui.render.GpuTexture;
import com.zurrtum.create.client.catnip.gui.render.PartialRenderState;
import com.zurrtum.create.client.flywheel.lib.model.baked.SinglePosVirtualBlockGetter;
import com.zurrtum.create.client.model.LayerBakedModel;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.render.TextureSetup;
import net.minecraft.client.gui.render.pip.PictureInPictureRenderer;
import net.minecraft.client.gui.render.state.BlitRenderState;
import net.minecraft.client.gui.render.state.GuiRenderState;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.chunk.ChunkSectionLayer;
import net.minecraft.client.renderer.rendertype.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.Blocks;

public class PartialElementRenderer
extends PictureInPictureRenderer<PartialRenderState> {
    private static final Map<PartialRenderState, GpuTexture> TEXTURES = new IdentityHashMap<PartialRenderState, GpuTexture>();
    private final PoseStack matrices = new PoseStack();
    private int windowScaleFactor;

    public PartialElementRenderer(MultiBufferSource.BufferSource vertexConsumers) {
        super(vertexConsumers);
    }

    public static void clear(PartialRenderState block) {
        GpuTexture texture = TEXTURES.remove(block);
        if (texture != null) {
            texture.close();
        }
    }

    public void prepare(PartialRenderState partial, GuiRenderState state, int windowScaleFactor) {
        GpuTexture texture;
        boolean draw;
        if (this.windowScaleFactor != windowScaleFactor) {
            this.windowScaleFactor = windowScaleFactor;
            TEXTURES.values().forEach(GpuTexture::close);
            TEXTURES.clear();
        }
        boolean bl = draw = (texture = TEXTURES.get(partial)) == null || partial.dirty;
        if (draw) {
            float size = partial.size * (float)windowScaleFactor;
            if (partial.dirty) {
                partial.clearDirty();
                if (texture != null && (float)texture.width() != size) {
                    texture.close();
                    texture = null;
                }
            }
            if (texture == null) {
                texture = GpuTexture.create((int)size);
                TEXTURES.put(partial, texture);
            }
            RenderSystem.setProjectionMatrix((GpuBufferSlice)this.projectionMatrixBuffer.getBuffer(size, size), (ProjectionType)ProjectionType.ORTHOGRAPHIC);
            texture.prepare();
            this.matrices.pushPose();
            if (partial.padding != 0) {
                size -= (float)(partial.padding * windowScaleFactor);
            }
            this.matrices.scale(size, size, size);
            partial.transform(this.matrices);
            Minecraft mc = Minecraft.getInstance();
            ChunkSectionLayer blockRenderLayer = LayerBakedModel.getBlockRenderLayer(partial.model, (Supplier<ChunkSectionLayer>)((Supplier)() -> ChunkSectionLayer.SOLID));
            RenderType layer = blockRenderLayer == ChunkSectionLayer.TRANSLUCENT ? Sheets.translucentItemSheet() : Sheets.cutoutBlockSheet();
            SinglePosVirtualBlockGetter world = SinglePosVirtualBlockGetter.createFullBright();
            mc.getBlockRenderer().renderBatched(Blocks.AIR.defaultBlockState(), BlockPos.ZERO, (BlockAndTintGetter)world, this.matrices, this.bufferSource.getBuffer(layer), false, List.of(partial.model));
            this.bufferSource.endBatch();
            this.matrices.popPose();
            texture.clear();
        }
        state.submitBlitToCurrentLayer(new BlitRenderState(RenderPipelines.GUI_TEXTURED_PREMULTIPLIED_ALPHA, TextureSetup.singleTexture((GpuTextureView)texture.textureView(), (GpuSampler)RenderSystem.getSamplerCache().getRepeat(FilterMode.NEAREST)), partial.IDENTITY_POSE, partial.x1, partial.y1, partial.x2, partial.y2, 0.0f, 1.0f, 1.0f, 0.0f, -1, partial.scissor, null));
    }

    protected void renderToTexture(PartialRenderState partial, PoseStack matrices) {
    }

    protected String getTextureLabel() {
        return "Partial";
    }

    public Class<PartialRenderState> getRenderStateClass() {
        return PartialRenderState.class;
    }
}

