/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.catnip.placement;

import com.zurrtum.create.catnip.animation.LerpedFloat;
import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.catnip.placement.IPlacementHelper;
import com.zurrtum.create.catnip.placement.PlacementHelpers;
import com.zurrtum.create.catnip.placement.PlacementOffset;
import com.zurrtum.create.client.catnip.ghostblock.GhostBlocks;
import com.zurrtum.create.client.catnip.gui.render.ArrowRenderState;
import com.zurrtum.create.client.catnip.gui.render.TextureArrowRenderState;
import com.zurrtum.create.client.catnip.outliner.Outliner;
import com.zurrtum.create.client.ponder.config.CClient;
import com.zurrtum.create.client.ponder.enums.PonderConfig;
import com.zurrtum.create.client.ponder.enums.PonderGuiTextures;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.render.TextureSetup;
import net.minecraft.client.gui.render.state.GuiElementRenderState;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3x2f;
import org.joml.Matrix3x2fStack;
import org.joml.Matrix3x2fc;

public class PlacementClient {
    static final LerpedFloat angle = LerpedFloat.angular().chase(0.0, 0.25, LerpedFloat.Chaser.EXP);
    @Nullable
    static BlockPos target = null;
    @Nullable
    static BlockPos lastTarget = null;
    static int animationTick = 0;

    public static void tick(Minecraft mc) {
        PlacementClient.setTarget(null);
        PlacementClient.checkHelpers(mc);
        if (target == null) {
            if (animationTick > 0) {
                animationTick = Math.max(animationTick - 2, 0);
            }
            return;
        }
        if (animationTick < 10) {
            ++animationTick;
        }
    }

    private static void checkHelpers(Minecraft mc) {
        ClientLevel world = mc.level;
        if (world == null) {
            return;
        }
        InteractionHand[] interactionHandArray = mc.hitResult;
        if (!(interactionHandArray instanceof BlockHitResult)) {
            return;
        }
        BlockHitResult ray = (BlockHitResult)interactionHandArray;
        if (mc.player == null) {
            return;
        }
        if (mc.player.isShiftKeyDown()) {
            return;
        }
        for (InteractionHand hand : InteractionHand.values()) {
            ItemStack heldItem = mc.player.getItemInHand(hand);
            ArrayList<IPlacementHelper> filteredForHeldItem = new ArrayList<IPlacementHelper>();
            for (IPlacementHelper helper : PlacementHelpers.getHelpersView()) {
                if (!helper.matchesItem(heldItem)) continue;
                filteredForHeldItem.add(helper);
            }
            if (filteredForHeldItem.isEmpty()) continue;
            BlockPos pos = ray.getBlockPos();
            BlockState state = world.getBlockState(pos);
            ArrayList<IPlacementHelper> filteredForState = new ArrayList<IPlacementHelper>();
            for (IPlacementHelper helper : filteredForHeldItem) {
                if (!helper.matchesState(state)) continue;
                filteredForState.add(helper);
            }
            if (filteredForState.isEmpty()) continue;
            boolean atLeastOneMatch = false;
            for (IPlacementHelper h : filteredForState) {
                PlacementOffset offset = h.getOffset((Player)mc.player, (Level)world, state, pos, ray, heldItem);
                if (!offset.isSuccessful()) continue;
                PlacementClient.renderAt(h, offset);
                PlacementClient.setTarget(offset.getBlockPos());
                atLeastOneMatch = true;
                break;
            }
            if (!atLeastOneMatch) continue;
            return;
        }
    }

    static void setTarget(@Nullable BlockPos target) {
        PlacementClient.target = target;
        if (target == null) {
            return;
        }
        if (lastTarget == null) {
            lastTarget = target;
            return;
        }
        if (!lastTarget.equals((Object)target)) {
            lastTarget = target;
        }
    }

    public static void onRenderCrosshairOverlay(Minecraft mc, GuiGraphics graphics, float partialTicks) {
        LocalPlayer player = mc.player;
        if (player != null && animationTick > 0) {
            float screenY = (float)graphics.guiHeight() / 2.0f;
            float screenX = (float)graphics.guiWidth() / 2.0f;
            float progress = PlacementClient.getCurrentAlpha();
            PlacementClient.drawDirectionIndicator(graphics, partialTicks, screenX, screenY, progress);
        }
    }

    public static float getCurrentAlpha() {
        return Math.min((float)animationTick / 10.0f, 1.0f);
    }

    private static void drawDirectionIndicator(GuiGraphics graphics, float partialTicks, float centerX, float centerY, float progress) {
        float r = 0.8f;
        float g = 0.8f;
        float b = 0.8f;
        float a = progress * progress;
        Vec3 projTarget = com.zurrtum.create.client.catnip.math.VecHelper.projectToPlayerView(VecHelper.getCenterOf((Vec3i)lastTarget), partialTicks);
        Vec3 target = new Vec3(projTarget.x, projTarget.y, 0.0);
        if (projTarget.z > 0.0) {
            target = target.reverse();
        }
        Vec3 norm = target.normalize();
        Vec3 ref = new Vec3(0.0, 1.0, 0.0);
        float targetAngle = AngleHelper.deg(-Math.acos(norm.dot(ref)));
        if (norm.x < 0.0) {
            targetAngle = 360.0f - targetAngle;
        }
        if (animationTick < 10) {
            angle.setValue(targetAngle);
        }
        angle.chase(targetAngle, 0.25, LerpedFloat.Chaser.EXP);
        angle.tickChaser();
        float snapSize = 22.5f;
        float snappedAngle = snapSize * (float)Math.round(angle.getValue(0.0f) / snapSize) % 360.0f;
        float length = 10.0f;
        CClient.PlacementIndicatorSetting mode = (CClient.PlacementIndicatorSetting)((Object)PonderConfig.client().placementIndicator.get());
        if (mode == CClient.PlacementIndicatorSetting.TRIANGLE) {
            PlacementClient.fadedArrow(graphics, centerX, centerY, r, g, b, a, length, snappedAngle);
        } else if (mode == CClient.PlacementIndicatorSetting.TEXTURE) {
            PlacementClient.textured(graphics, centerX, centerY, a, snappedAngle);
        }
    }

    private static void fadedArrow(GuiGraphics graphics, float centerX, float centerY, float r, float g, float b, float a, float length, float snappedAngle) {
        Matrix3x2fStack ms = graphics.pose();
        ms.pushMatrix();
        ms.translate(centerX, centerY);
        ms.rotate(angle.getValue(0.0f) * ((float)Math.PI / 180));
        double scale = ((Float)PonderConfig.client().indicatorScale.get()).floatValue();
        ms.scale((float)scale, (float)scale);
        int size = (int)((double)(10.0f + length) * scale);
        graphics.guiRenderState.submitGuiElement((GuiElementRenderState)new ArrowRenderState(new Matrix3x2f((Matrix3x2fc)ms), size, r, g, b, a, length));
        ms.popMatrix();
    }

    public static void textured(GuiGraphics graphics, float centerX, float centerY, float alpha, float snappedAngle) {
        Matrix3x2fStack ms = graphics.pose();
        ms.pushMatrix();
        ms.translate(centerX, centerY);
        float scale = ((Float)PonderConfig.client().indicatorScale.get()).floatValue() * 0.75f;
        ms.scale(scale, scale);
        ms.scale(12.0f, 12.0f);
        float index = snappedAngle / 22.5f;
        float tex_size = 0.0625f;
        float tx = 0.0f;
        float ty = index * tex_size;
        float tw = 1.0f;
        float th = tex_size;
        int size = (int)(36.0f * scale);
        TextureSetup texture = PonderGuiTextures.PLACEMENT_INDICATOR_SHEET.bind();
        graphics.guiRenderState.submitGuiElement((GuiElementRenderState)new TextureArrowRenderState(new Matrix3x2f((Matrix3x2fc)ms), size, alpha, texture, tx, ty, tw, th));
        ms.popMatrix();
    }

    public static void renderAt(Object slot, PlacementOffset offset) {
        PlacementClient.displayGhost(slot, offset);
    }

    public static void renderArrow(Vec3 center, Vec3 target, Direction arrowPlane) {
        PlacementClient.renderArrow(center, target, arrowPlane, 1.0);
    }

    public static void renderArrow(Vec3 center, Vec3 target, Direction arrowPlane, double distanceFromCenter) {
        Vec3 direction = target.subtract(center).normalize();
        Vec3 facing = Vec3.atLowerCornerOf((Vec3i)arrowPlane.getUnitVec3i());
        Vec3 start = center.add(direction);
        Vec3 offset = direction.scale(distanceFromCenter - 1.0);
        Vec3 offsetA = direction.cross(facing).normalize().scale(0.25);
        Vec3 offsetB = facing.cross(direction).normalize().scale(0.25);
        Vec3 endA = center.add(direction.scale(0.75)).add(offsetA);
        Vec3 endB = center.add(direction.scale(0.75)).add(offsetB);
        Outliner.getInstance().showLine("placementArrowA" + String.valueOf(center) + String.valueOf(target), start.add(offset), endA.add(offset)).lineWidth(0.0625f);
        Outliner.getInstance().showLine("placementArrowB" + String.valueOf(center) + String.valueOf(target), start.add(offset), endB.add(offset)).lineWidth(0.0625f);
    }

    public static void displayGhost(Object slot, PlacementOffset offset) {
        if (!offset.hasGhostState()) {
            return;
        }
        GhostBlocks.getInstance().showGhostState(slot, offset.getTransform().apply(offset.getGhostState())).at(offset.getBlockPos()).breathingAlpha();
    }
}

