/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.catnip.render;

import com.mojang.blaze3d.vertex.ByteBufferBuilder;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.zurrtum.create.client.catnip.render.PonderRenderTypes;
import com.zurrtum.create.client.catnip.render.SuperRenderTypeBuffer;
import com.zurrtum.create.client.foundation.render.CreateRenderTypes;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.util.SortedMap;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.SectionBufferBuilderPack;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.chunk.ChunkSectionLayer;
import net.minecraft.client.renderer.rendertype.RenderType;
import net.minecraft.client.renderer.rendertype.RenderTypes;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.util.Util;

public class DefaultSuperRenderTypeBuffer
implements SuperRenderTypeBuffer {
    private static final DefaultSuperRenderTypeBuffer INSTANCE = new DefaultSuperRenderTypeBuffer();
    protected SuperRenderTypeBufferPhase earlyBuffer = new SuperRenderTypeBufferPhase();
    protected SuperRenderTypeBufferPhase defaultBuffer = new SuperRenderTypeBufferPhase();
    protected SuperRenderTypeBufferPhase lateBuffer = new SuperRenderTypeBufferPhase();

    public static DefaultSuperRenderTypeBuffer getInstance() {
        return INSTANCE;
    }

    @Override
    public VertexConsumer getEarlyBuffer(RenderType type) {
        return this.earlyBuffer.bufferSource.getBuffer(type);
    }

    @Override
    public VertexConsumer getBuffer(RenderType type) {
        return this.defaultBuffer.bufferSource.getBuffer(type);
    }

    @Override
    public VertexConsumer getLateBuffer(RenderType type) {
        return this.lateBuffer.bufferSource.getBuffer(type);
    }

    @Override
    public void draw() {
        this.earlyBuffer.bufferSource.endBatch();
        this.defaultBuffer.bufferSource.endBatch();
        this.lateBuffer.bufferSource.endBatch();
    }

    @Override
    public void draw(RenderType type) {
        this.earlyBuffer.bufferSource.endBatch(type);
        this.defaultBuffer.bufferSource.endBatch(type);
        this.lateBuffer.bufferSource.endBatch(type);
    }

    public static class SuperRenderTypeBufferPhase {
        private final SectionBufferBuilderPack fixedBufferPack = new SectionBufferBuilderPack();
        private final SortedMap<RenderType, ByteBufferBuilder> fixedBuffers = (SortedMap)Util.make((Object)new Object2ObjectLinkedOpenHashMap(), map -> {
            map.put((Object)Sheets.solidBlockSheet(), (Object)this.fixedBufferPack.buffer(ChunkSectionLayer.SOLID));
            map.put((Object)Sheets.cutoutBlockSheet(), (Object)this.fixedBufferPack.buffer(ChunkSectionLayer.CUTOUT));
            map.put((Object)Sheets.translucentItemSheet(), (Object)this.fixedBufferPack.buffer(ChunkSectionLayer.TRANSLUCENT));
            SuperRenderTypeBufferPhase.put((Object2ObjectLinkedOpenHashMap<RenderType, ByteBufferBuilder>)map, Sheets.translucentBlockItemSheet());
            SuperRenderTypeBufferPhase.put((Object2ObjectLinkedOpenHashMap<RenderType, ByteBufferBuilder>)map, Sheets.shieldSheet());
            SuperRenderTypeBufferPhase.put((Object2ObjectLinkedOpenHashMap<RenderType, ByteBufferBuilder>)map, Sheets.bedSheet());
            SuperRenderTypeBufferPhase.put((Object2ObjectLinkedOpenHashMap<RenderType, ByteBufferBuilder>)map, Sheets.shulkerBoxSheet());
            SuperRenderTypeBufferPhase.put((Object2ObjectLinkedOpenHashMap<RenderType, ByteBufferBuilder>)map, Sheets.signSheet());
            SuperRenderTypeBufferPhase.put((Object2ObjectLinkedOpenHashMap<RenderType, ByteBufferBuilder>)map, Sheets.hangingSignSheet());
            map.put((Object)Sheets.chestSheet(), (Object)new ByteBufferBuilder(786432));
            SuperRenderTypeBufferPhase.put((Object2ObjectLinkedOpenHashMap<RenderType, ByteBufferBuilder>)map, RenderTypes.armorEntityGlint());
            SuperRenderTypeBufferPhase.put((Object2ObjectLinkedOpenHashMap<RenderType, ByteBufferBuilder>)map, RenderTypes.glint());
            SuperRenderTypeBufferPhase.put((Object2ObjectLinkedOpenHashMap<RenderType, ByteBufferBuilder>)map, RenderTypes.glintTranslucent());
            SuperRenderTypeBufferPhase.put((Object2ObjectLinkedOpenHashMap<RenderType, ByteBufferBuilder>)map, RenderTypes.entityGlint());
            SuperRenderTypeBufferPhase.put((Object2ObjectLinkedOpenHashMap<RenderType, ByteBufferBuilder>)map, RenderTypes.waterMask());
            ModelBakery.DESTROY_TYPES.forEach(renderType -> SuperRenderTypeBufferPhase.put((Object2ObjectLinkedOpenHashMap<RenderType, ByteBufferBuilder>)map, renderType));
            SuperRenderTypeBufferPhase.put((Object2ObjectLinkedOpenHashMap<RenderType, ByteBufferBuilder>)map, PonderRenderTypes.outlineSolid());
            SuperRenderTypeBufferPhase.put((Object2ObjectLinkedOpenHashMap<RenderType, ByteBufferBuilder>)map, CreateRenderTypes.translucent());
            SuperRenderTypeBufferPhase.put((Object2ObjectLinkedOpenHashMap<RenderType, ByteBufferBuilder>)map, CreateRenderTypes.additive());
        });
        private final MultiBufferSource.BufferSource bufferSource = MultiBufferSource.immediateWithBuffers(this.fixedBuffers, (ByteBufferBuilder)new ByteBufferBuilder(256));

        private static void put(Object2ObjectLinkedOpenHashMap<RenderType, ByteBufferBuilder> map, RenderType type) {
            map.put((Object)type, (Object)new ByteBufferBuilder(type.bufferSize()));
        }
    }
}

