/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.catnip.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.zurrtum.create.catnip.theme.Color;
import com.zurrtum.create.client.catnip.render.SpriteShiftEntry;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.catnip.render.TemplateMesh;
import com.zurrtum.create.client.flywheel.backend.engine.uniform.LevelUniforms;
import com.zurrtum.create.client.flywheel.lib.util.ShadersModHelper;
import it.unimi.dsi.fastutil.longs.Long2IntMap;
import it.unimi.dsi.fastutil.longs.Long2IntOpenHashMap;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockAndTintGetter;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;

public class ShadeSeparatingSuperByteBuffer
implements SuperByteBuffer {
    private static final Long2IntMap WORLD_LIGHT_CACHE = new Long2IntOpenHashMap();
    private final TemplateMesh template;
    private final int[] shadeSwapVertices;
    private final PoseStack transforms = new PoseStack();
    private float r;
    private float g;
    private float b;
    private float a;
    private boolean disableDiffuse;
    @Nullable
    private SuperByteBuffer.SpriteShiftFunc spriteShiftFunc;
    private boolean hasCustomOverlay;
    private int overlay;
    private boolean hasCustomLight;
    private int packedLight;
    private boolean useLevelLight;
    @Nullable
    private BlockAndTintGetter levelWithLight;
    @Nullable
    private Matrix4f lightTransform;
    private boolean invertFakeDiffuseNormal;
    private final Matrix4f modelMat = new Matrix4f();
    private final Matrix3f normalMat = new Matrix3f();
    private final Vector4f pos = new Vector4f();
    private final Vector3f normal = new Vector3f();
    private final Vector3f lightDir0 = new Vector3f();
    private final Vector3f lightDir1 = new Vector3f();
    private final SuperByteBuffer.ShiftOutput shiftOutput = new SuperByteBuffer.ShiftOutput();
    private final Vector4f lightPos = new Vector4f();

    public ShadeSeparatingSuperByteBuffer(TemplateMesh template, int[] shadeSwapVertices, boolean invertFakeDiffuseNormal) {
        this.template = template;
        this.shadeSwapVertices = shadeSwapVertices;
        this.invertFakeDiffuseNormal = invertFakeDiffuseNormal;
        this.reset();
    }

    public ShadeSeparatingSuperByteBuffer(TemplateMesh template, int[] shadeSwapVertices) {
        this(template, shadeSwapVertices, false);
    }

    public ShadeSeparatingSuperByteBuffer(TemplateMesh template) {
        this(template, new int[0]);
    }

    @Override
    public void renderInto(PoseStack.Pose entry, VertexConsumer builder) {
        if (this.isEmpty()) {
            return;
        }
        if (this.useLevelLight) {
            WORLD_LIGHT_CACHE.clear();
        }
        Matrix4f modelMat = this.modelMat.set((Matrix4fc)entry.pose());
        Matrix4f localTransforms = this.transforms.last().pose();
        modelMat.mul((Matrix4fc)localTransforms);
        Matrix3f normalMat = this.normalMat.set((Matrix3fc)entry.normal());
        Matrix3f localNormalTransforms = this.transforms.last().normal();
        normalMat.mul((Matrix3fc)localNormalTransforms);
        Vector4f pos = this.pos;
        Vector3f normal = this.normal;
        SuperByteBuffer.ShiftOutput shiftOutput = this.shiftOutput;
        Vector3f lightDir0 = this.lightDir0;
        Vector3f lightDir1 = this.lightDir1;
        Vector4f lightPos = this.lightPos;
        boolean applyDiffuse = !this.disableDiffuse && !ShadersModHelper.isShaderPackInUse();
        boolean shaded = true;
        int shadeSwapIndex = 0;
        int nextShadeSwapVertex = shadeSwapIndex < this.shadeSwapVertices.length ? this.shadeSwapVertices[shadeSwapIndex] : -1;
        float unshadedDiffuse = 1.0f;
        if (applyDiffuse) {
            float[] currentLight = LevelUniforms.LIGHT_DIRECTION;
            lightDir0.set(currentLight[0], currentLight[1], currentLight[2]);
            lightDir1.set(currentLight[3], currentLight[4], currentLight[5]);
            if (this.shadeSwapVertices.length > 0) {
                normal.set(0.0f, this.invertFakeDiffuseNormal ? -1.0f : 1.0f, 0.0f);
            }
        }
        int vertexCount = this.template.vertexCount();
        for (int i = 0; i < vertexCount; ++i) {
            if (i == nextShadeSwapVertex) {
                shaded = !shaded;
                nextShadeSwapVertex = ++shadeSwapIndex < this.shadeSwapVertices.length ? this.shadeSwapVertices[shadeSwapIndex] : -1;
            }
            float x = this.template.x(i);
            float y = this.template.y(i);
            float z = this.template.z(i);
            pos.set(x, y, z, 1.0f);
            pos.mul((Matrix4fc)modelMat);
            int packedNormal = this.template.normal(i);
            float normalX = (float)((byte)(packedNormal & 0xFF)) / 127.0f;
            float normalY = (float)((byte)(packedNormal >>> 8 & 0xFF)) / 127.0f;
            float normalZ = (float)((byte)(packedNormal >>> 16 & 0xFF)) / 127.0f;
            normal.set(normalX, normalY, normalZ);
            normal.mul((Matrix3fc)normalMat);
            int color = this.template.color(i);
            float r = (float)(color & 0xFF) / 255.0f * this.r;
            float g = (float)(color >>> 8 & 0xFF) / 255.0f * this.g;
            float b = (float)(color >>> 16 & 0xFF) / 255.0f * this.b;
            float a = (float)(color >>> 24 & 0xFF) / 255.0f * this.a;
            if (applyDiffuse) {
                float diffuse = shaded ? ShadeSeparatingSuperByteBuffer.calculateDiffuse((Vector3fc)normal, (Vector3fc)lightDir0, (Vector3fc)lightDir1) : unshadedDiffuse;
                r *= diffuse;
                g *= diffuse;
                b *= diffuse;
            }
            float u = this.template.u(i);
            float v = this.template.v(i);
            if (this.spriteShiftFunc != null) {
                this.spriteShiftFunc.shift(u, v, shiftOutput);
                u = shiftOutput.u;
                v = shiftOutput.v;
            }
            int overlay = this.hasCustomOverlay ? this.overlay : this.template.overlay(i);
            int light = this.template.light(i);
            if (this.hasCustomLight) {
                light = SuperByteBuffer.maxLight(light, this.packedLight);
            }
            if (this.useLevelLight) {
                lightPos.set((x - 0.5f) * 15.0f / 16.0f + 0.5f, (y - 0.5f) * 15.0f / 16.0f + 0.5f, (z - 0.5f) * 15.0f / 16.0f + 0.5f, 1.0f);
                lightPos.mul((Matrix4fc)localTransforms);
                if (this.lightTransform != null) {
                    lightPos.mul((Matrix4fc)this.lightTransform);
                }
                light = SuperByteBuffer.maxLight(light, ShadeSeparatingSuperByteBuffer.getLight(this.levelWithLight, lightPos));
            }
            builder.addVertex(pos.x(), pos.y(), pos.z()).setColor(r, g, b, a).setUv(u, v).setOverlay(overlay).setLight(light).setNormal(normal.x(), normal.y(), normal.z());
        }
        this.reset();
    }

    public SuperByteBuffer reset() {
        while (!this.transforms.isEmpty()) {
            this.transforms.popPose();
        }
        this.transforms.pushPose();
        this.r = 1.0f;
        this.g = 1.0f;
        this.b = 1.0f;
        this.a = 1.0f;
        this.disableDiffuse = false;
        this.spriteShiftFunc = null;
        this.hasCustomOverlay = false;
        this.overlay = OverlayTexture.NO_OVERLAY;
        this.hasCustomLight = false;
        this.packedLight = 0;
        this.useLevelLight = false;
        this.levelWithLight = null;
        this.lightTransform = null;
        return this;
    }

    @Override
    public boolean isEmpty() {
        return this.template.isEmpty();
    }

    @Override
    public PoseStack getTransforms() {
        return this.transforms;
    }

    @Override
    public SuperByteBuffer scale(float factorX, float factorY, float factorZ) {
        this.transforms.scale(factorX, factorY, factorZ);
        return this;
    }

    @Override
    public SuperByteBuffer rotate(Quaternionfc quaternion) {
        PoseStack.Pose last = this.transforms.last();
        last.pose().rotate(quaternion);
        last.normal().rotate(quaternion);
        return this;
    }

    @Override
    public SuperByteBuffer translate(float x, float y, float z) {
        this.transforms.translate(x, y, z);
        return this;
    }

    @Override
    public SuperByteBuffer mulPose(Matrix4fc pose) {
        this.transforms.last().pose().mul(pose);
        return this;
    }

    @Override
    public SuperByteBuffer mulNormal(Matrix3fc normal) {
        this.transforms.last().normal().mul(normal);
        return this;
    }

    @Override
    public SuperByteBuffer pushPose() {
        this.transforms.pushPose();
        return this;
    }

    @Override
    public SuperByteBuffer popPose() {
        this.transforms.popPose();
        return this;
    }

    public SuperByteBuffer color(float r, float g, float b, float a) {
        this.r = r;
        this.g = g;
        this.b = b;
        this.a = a;
        return this;
    }

    public SuperByteBuffer color(int r, int g, int b, int a) {
        this.color((float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f, (float)a / 255.0f);
        return this;
    }

    public SuperByteBuffer color(int color) {
        this.color(color >> 16 & 0xFF, color >> 8 & 0xFF, color & 0xFF, 255);
        return this;
    }

    public SuperByteBuffer color(Color c) {
        return this.color(c.getRGB());
    }

    public SuperByteBuffer disableDiffuse() {
        this.disableDiffuse = true;
        return this;
    }

    public SuperByteBuffer shiftUV(SpriteShiftEntry entry) {
        this.spriteShiftFunc = (u, v, output) -> output.accept(entry.getTargetU(u), entry.getTargetV(v));
        return this;
    }

    public SuperByteBuffer shiftUVScrolling(SpriteShiftEntry entry, float scrollV) {
        return this.shiftUVScrolling(entry, 0.0f, scrollV);
    }

    public SuperByteBuffer shiftUVScrolling(SpriteShiftEntry entry, float scrollU, float scrollV) {
        this.spriteShiftFunc = (u, v, output) -> {
            float targetU = u - entry.getOriginal().getU0() + entry.getTarget().getU0() + scrollU;
            float targetV = v - entry.getOriginal().getV0() + entry.getTarget().getV0() + scrollV;
            output.accept(targetU, targetV);
        };
        return this;
    }

    public SuperByteBuffer shiftUVtoSheet(SpriteShiftEntry entry, float uTarget, float vTarget, int sheetSize) {
        this.spriteShiftFunc = (u, v, output) -> {
            float targetU = entry.getTarget().getU(SpriteShiftEntry.getUnInterpolatedU(entry.getOriginal(), u) / (float)sheetSize + uTarget);
            float targetV = entry.getTarget().getV(SpriteShiftEntry.getUnInterpolatedV(entry.getOriginal(), v) / (float)sheetSize + vTarget);
            output.accept(targetU, targetV);
        };
        return this;
    }

    public SuperByteBuffer overlay(int overlay) {
        this.hasCustomOverlay = true;
        this.overlay = overlay;
        return this;
    }

    public SuperByteBuffer light(int packedLight) {
        this.hasCustomLight = true;
        this.packedLight = packedLight;
        return this;
    }

    public SuperByteBuffer useLevelLight(BlockAndTintGetter level) {
        this.useLevelLight = true;
        this.levelWithLight = level;
        return this;
    }

    public SuperByteBuffer useLevelLight(BlockAndTintGetter level, Matrix4f lightTransform) {
        this.useLevelLight = true;
        this.levelWithLight = level;
        this.lightTransform = lightTransform;
        return this;
    }

    private static float calculateDiffuse(Vector3fc normal, Vector3fc lightDir0, Vector3fc lightDir1) {
        float light0 = Math.max(0.0f, lightDir0.dot(normal));
        float light1 = Math.max(0.0f, lightDir1.dot(normal));
        return Math.min(1.0f, (light0 + light1) * 0.6f + 0.4f);
    }

    private static int getLight(BlockAndTintGetter world, Vector4f lightPos) {
        BlockPos pos = BlockPos.containing((double)lightPos.x(), (double)lightPos.y(), (double)lightPos.z());
        return WORLD_LIGHT_CACHE.computeIfAbsent(pos.asLong(), $ -> LevelRenderer.getLightColor((BlockAndTintGetter)world, (BlockPos)pos));
    }
}

