/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.catnip.render;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.Identifier;

public class StitchedSprite {
    private static final Map<Identifier, List<StitchedSprite>> ALL = new HashMap<Identifier, List<StitchedSprite>>();
    protected final Identifier atlasLocation;
    protected final Identifier location;
    protected TextureAtlasSprite sprite;

    public StitchedSprite(Identifier atlas, Identifier location) {
        this.atlasLocation = atlas;
        this.location = location;
        ALL.computeIfAbsent(this.atlasLocation, $ -> new ArrayList()).add(this);
    }

    public StitchedSprite(Identifier location) {
        this(TextureAtlas.LOCATION_BLOCKS, location);
    }

    public static void onTextureStitchPost(TextureAtlas atlas) {
        Identifier atlasLocation = atlas.location();
        List<StitchedSprite> sprites = ALL.get(atlasLocation);
        if (sprites != null) {
            for (StitchedSprite sprite : sprites) {
                sprite.loadSprite(atlas);
            }
        }
    }

    protected void loadSprite(TextureAtlas atlas) {
        this.sprite = atlas.getSprite(this.location);
    }

    public Identifier getAtlasLocation() {
        return this.atlasLocation;
    }

    public Identifier getLocation() {
        return this.location;
    }

    public TextureAtlasSprite get() {
        return this.sprite;
    }
}

