/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.contraptions.actors.contraptionControls;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.catnip.data.Couple;
import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.catnip.theme.Color;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.api.behaviour.movement.MovementRenderBehaviour;
import com.zurrtum.create.client.api.behaviour.movement.MovementRenderState;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.content.contraptions.render.ClientContraption;
import com.zurrtum.create.client.foundation.utility.DyeHelper;
import com.zurrtum.create.client.foundation.virtualWorld.VirtualRenderWorld;
import com.zurrtum.create.content.contraptions.actors.contraptionControls.ContraptionControlsBlock;
import com.zurrtum.create.content.contraptions.actors.contraptionControls.ContraptionControlsBlockEntity;
import com.zurrtum.create.content.contraptions.actors.contraptionControls.ContraptionControlsMovement;
import com.zurrtum.create.content.contraptions.behaviour.MovementContext;
import java.util.Random;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.rendertype.RenderType;
import net.minecraft.client.renderer.rendertype.RenderTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public class ContraptionControlsMovementRender
implements MovementRenderBehaviour {
    private static final ThreadLocal<Random> RANDOM = ThreadLocal.withInitial(Random::new);

    @Override
    public MovementRenderState getRenderState(Vec3 camera, Font textRenderer, MovementContext context, VirtualRenderWorld renderWorld, Matrix4f worldMatrix4f) {
        int width;
        int actualWidth;
        boolean hideDescription;
        Object object = context.temporaryData;
        if (!(object instanceof ContraptionControlsMovement.ElevatorFloorSelection)) {
            return null;
        }
        ContraptionControlsMovement.ElevatorFloorSelection efs = (ContraptionControlsMovement.ElevatorFloorSelection)object;
        BlockState blockState = context.state;
        if (!blockState.is((Block)AllBlocks.CONTRAPTION_CONTROLS)) {
            return null;
        }
        BlockPos pos = context.localPos;
        ContraptionControlsMovementRenderState state = new ContraptionControlsMovementRenderState(pos);
        float flicker = RANDOM.get().nextFloat();
        BlockEntity blockEntity = ClientContraption.getBlockEntityClientSide(context.contraption, pos);
        if (blockEntity instanceof ContraptionControlsBlockEntity) {
            ContraptionControlsBlockEntity cbe = (ContraptionControlsBlockEntity)blockEntity;
            state.buttondepth = -0.041666668f * cbe.button.getValue(AnimationTickHolder.getPartialTicks(renderWorld));
        }
        state.layer = RenderTypes.solidMovingBlock();
        Direction facing = (Direction)blockState.getValue((Property)ContraptionControlsBlock.FACING);
        state.button = CachedBuffers.partialFacing(AllPartialModels.CONTRAPTION_CONTROLS_BUTTON, blockState, facing.getOpposite());
        state.light = LevelRenderer.getLightColor((BlockAndTintGetter)renderWorld, (BlockPos)pos);
        state.world = context.world;
        state.worldMatrix4f = worldMatrix4f;
        String text = efs.currentShortName;
        String description = efs.currentLongName;
        Vec3 position = context.position;
        float playerDistance = (float)(position == null ? 0.0 : camera.distanceToSqr(position));
        boolean hideText = text.isBlank() || playerDistance > 100.0f;
        boolean bl = hideDescription = description.isBlank() || playerDistance > 20.0f;
        if (hideText && hideDescription) {
            return state;
        }
        state.upAngle = AngleHelper.rad(AngleHelper.horizontalAngle(facing));
        state.westAngle = AngleHelper.rad(67.5);
        Couple<Integer> couple = DyeHelper.getDyeColors(efs.targetYEqualsSelection ? DyeColor.WHITE : DyeColor.ORANGE);
        int brightColor = (Integer)couple.getFirst();
        int darkColor = (Integer)couple.getSecond();
        state.color = Color.mixColors(brightColor, darkColor, flicker / 4.0f) | 0xFF000000;
        state.offsetZ = state.buttondepth - 0.25f;
        if (!hideText) {
            state.shadowColor = Color.mixColors(darkColor, 0, 0.35f) | 0xFF000000;
            actualWidth = textRenderer.width(text);
            width = Math.max(actualWidth, 12);
            state.textScale = 1.0f / (5.0f * ((float)width - 0.5f));
            state.textX = (float)Math.max(0, width - actualWidth) / 2.0f;
            state.textY = ((float)width - 8.0f) / 2.0f;
            state.text = Component.literal((String)text).getVisualOrderText();
        }
        if (!hideDescription) {
            actualWidth = textRenderer.width(description);
            width = Math.max(actualWidth, 55);
            state.descriptionScale = 1.0f / (3.0f * ((float)width - 0.5f));
            state.descriptionX = (float)Math.max(0, width - actualWidth) / 2.0f;
            state.descriptionY = ((float)width - 8.0f) / 2.0f;
            state.description = Component.literal((String)description).getVisualOrderText();
        }
        return state;
    }

    public static class ContraptionControlsMovementRenderState
    extends MovementRenderState
    implements SubmitNodeCollector.CustomGeometryRenderer {
        public RenderType layer;
        public SuperByteBuffer button;
        public int light;
        public Level world;
        public Matrix4f worldMatrix4f;
        public float buttondepth;
        public float upAngle;
        public float westAngle;
        public float offsetZ;
        public FormattedCharSequence text;
        public FormattedCharSequence description;
        public float textScale;
        public float textX;
        public float textY;
        public float descriptionScale;
        public float descriptionX;
        public float descriptionY;
        public int color;
        public int shadowColor;

        public ContraptionControlsMovementRenderState(BlockPos pos) {
            super(pos);
        }

        @Override
        public void render(PoseStack matrices, SubmitNodeCollector queue) {
            matrices.pushPose();
            matrices.translate(0.0f, this.buttondepth, 0.0f);
            queue.submitCustomGeometry(matrices, this.layer, (SubmitNodeCollector.CustomGeometryRenderer)this);
            matrices.popPose();
            if (this.text != null || this.description != null) {
                matrices.rotateAround((Quaternionfc)new Quaternionf().setAngleAxis(this.upAngle, 0.0f, 1.0f, 0.0f), 0.5f, 0.5f, 0.5f);
                matrices.translate(0.4f, 1.125f, 0.5f);
                matrices.mulPose((Quaternionfc)new Quaternionf().setAngleAxis(this.westAngle, -1.0f, 0.0f, 0.0f));
                if (this.text != null) {
                    matrices.pushPose();
                    matrices.translate(0.0f, 0.15f, this.offsetZ);
                    matrices.scale(this.textScale, -this.textScale, this.textScale);
                    queue.submitText(matrices, this.textX, this.textY, this.text, false, Font.DisplayMode.NORMAL, 0xF000F0, this.color, 0, 0);
                    matrices.translate(0.5f, 0.5f, -0.0625f);
                    queue.submitText(matrices, this.textX, this.textY, this.text, false, Font.DisplayMode.NORMAL, 0xF000F0, this.shadowColor, 0, 0);
                    matrices.popPose();
                }
                if (this.description != null) {
                    matrices.pushPose();
                    matrices.translate(-0.0635f, 0.06f, this.offsetZ);
                    matrices.scale(this.descriptionScale, -this.descriptionScale, this.descriptionScale);
                    queue.submitText(matrices, this.descriptionX, this.descriptionY, this.description, false, Font.DisplayMode.NORMAL, 0xF000F0, this.color, 0, 0);
                    matrices.popPose();
                }
            }
        }

        public void render(PoseStack.Pose matricesEntry, VertexConsumer vertexConsumer) {
            this.button.light(this.light).useLevelLight((BlockAndTintGetter)this.world, this.worldMatrix4f).renderInto(matricesEntry, vertexConsumer);
        }
    }
}

