/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.contraptions.actors.psi;

import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.client.content.contraptions.actors.psi.PortableStorageInterfaceRenderer;
import com.zurrtum.create.client.flywheel.api.instance.Instance;
import com.zurrtum.create.client.flywheel.api.instance.InstancerProvider;
import com.zurrtum.create.client.flywheel.lib.instance.InstanceTypes;
import com.zurrtum.create.client.flywheel.lib.instance.TransformedInstance;
import com.zurrtum.create.client.flywheel.lib.model.Models;
import com.zurrtum.create.content.contraptions.actors.psi.PortableStorageInterfaceBlock;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class PIInstance {
    private final InstancerProvider instancerProvider;
    private final BlockState blockState;
    private final BlockPos instancePos;
    private final float angleX;
    private final float angleY;
    private boolean lit;
    TransformedInstance middle;
    TransformedInstance top;

    public PIInstance(InstancerProvider instancerProvider, BlockState blockState, BlockPos instancePos, boolean lit) {
        this.instancerProvider = instancerProvider;
        this.blockState = blockState;
        this.instancePos = instancePos;
        Direction facing = (Direction)blockState.getValue((Property)PortableStorageInterfaceBlock.FACING);
        this.angleX = facing == Direction.UP ? 0.0f : (facing == Direction.DOWN ? 180.0f : 90.0f);
        this.angleY = AngleHelper.horizontalAngle(facing);
        this.lit = lit;
        this.middle = instancerProvider.instancer(InstanceTypes.TRANSFORMED, Models.partial(PortableStorageInterfaceRenderer.getMiddleForState(blockState, lit))).createInstance();
        this.top = instancerProvider.instancer(InstanceTypes.TRANSFORMED, Models.partial(PortableStorageInterfaceRenderer.getTopForState(blockState))).createInstance();
    }

    public void beginFrame(float progress) {
        ((TransformedInstance)((TransformedInstance)((TransformedInstance)((TransformedInstance)this.middle.setIdentityTransform().translate((Vec3i)this.instancePos)).center()).rotateYDegrees(this.angleY)).rotateXDegrees(this.angleX)).uncenter();
        ((TransformedInstance)((TransformedInstance)((TransformedInstance)((TransformedInstance)this.top.setIdentityTransform().translate((Vec3i)this.instancePos)).center()).rotateYDegrees(this.angleY)).rotateXDegrees(this.angleX)).uncenter();
        this.middle.translate(0.0f, progress * 0.5f + 0.375f, 0.0f);
        this.top.translate(0.0f, progress, 0.0f);
        this.middle.setChanged();
        this.top.setChanged();
    }

    public void tick(boolean lit) {
        if (this.lit != lit) {
            this.lit = lit;
            this.instancerProvider.instancer(InstanceTypes.TRANSFORMED, Models.partial(PortableStorageInterfaceRenderer.getMiddleForState(this.blockState, lit))).stealInstance(this.middle);
        }
    }

    public void remove() {
        this.middle.delete();
        this.top.delete();
    }

    public void collectCrumblingInstances(Consumer<Instance> consumer) {
        consumer.accept(this.middle);
        consumer.accept(this.top);
    }
}

