/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.contraptions.actors.psi;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.zurrtum.create.catnip.animation.LerpedFloat;
import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.client.api.behaviour.movement.MovementRenderBehaviour;
import com.zurrtum.create.client.api.behaviour.movement.MovementRenderState;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.content.contraptions.actors.psi.PSIActorVisual;
import com.zurrtum.create.client.content.contraptions.actors.psi.PortableStorageInterfaceRenderer;
import com.zurrtum.create.client.content.contraptions.render.ActorVisual;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationContext;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationManager;
import com.zurrtum.create.client.foundation.virtualWorld.VirtualRenderWorld;
import com.zurrtum.create.content.contraptions.actors.psi.PortableStorageInterfaceBlock;
import com.zurrtum.create.content.contraptions.actors.psi.PortableStorageInterfaceMovement;
import com.zurrtum.create.content.contraptions.behaviour.MovementContext;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.rendertype.RenderType;
import net.minecraft.client.renderer.rendertype.RenderTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

public class PortableStorageInterfaceMovementRender
implements MovementRenderBehaviour {
    @Override
    @Nullable
    public ActorVisual createVisual(VisualizationContext visualizationContext, VirtualRenderWorld simulationWorld, MovementContext movementContext) {
        return new PSIActorVisual(visualizationContext, simulationWorld, movementContext);
    }

    @Override
    public MovementRenderState getRenderState(Vec3 camera, Font textRenderer, MovementContext context, VirtualRenderWorld renderWorld, Matrix4f worldMatrix4f) {
        if (VisualizationManager.supportsVisualization((LevelAccessor)context.world)) {
            return null;
        }
        PortableStorageInterfaceMovementRenderState state = new PortableStorageInterfaceMovementRenderState(context.localPos);
        state.layer = RenderTypes.solidMovingBlock();
        BlockState blockState = context.state;
        float renderPartialTicks = AnimationTickHolder.getPartialTicks();
        LerpedFloat animation = PortableStorageInterfaceMovement.getAnimation(context);
        state.middle = CachedBuffers.partial(PortableStorageInterfaceRenderer.getMiddleForState(blockState, animation.settled()), blockState);
        state.top = CachedBuffers.partial(PortableStorageInterfaceRenderer.getTopForState(blockState), blockState);
        Direction facing = (Direction)blockState.getValue((Property)PortableStorageInterfaceBlock.FACING);
        state.yRot = (float)Math.PI / 180 * AngleHelper.horizontalAngle(facing);
        state.xRot = (float)Math.PI / 180 * (float)(facing == Direction.UP ? 0 : (facing == Direction.DOWN ? 180 : 90));
        state.topOffset = animation.getValue(renderPartialTicks);
        state.middleOffset = state.topOffset * 0.5f + 0.375f;
        state.light = LevelRenderer.getLightColor((BlockAndTintGetter)renderWorld, (BlockPos)context.localPos);
        state.world = context.world;
        state.worldMatrix4f = worldMatrix4f;
        return state;
    }

    public static class PortableStorageInterfaceMovementRenderState
    extends MovementRenderState
    implements SubmitNodeCollector.CustomGeometryRenderer {
        public RenderType layer;
        public SuperByteBuffer middle;
        public SuperByteBuffer top;
        public float yRot;
        public float xRot;
        public float middleOffset;
        public float topOffset;
        public int light;
        public Level world;
        public Matrix4f worldMatrix4f;

        public PortableStorageInterfaceMovementRenderState(BlockPos pos) {
            super(pos);
        }

        @Override
        public void render(PoseStack matrices, SubmitNodeCollector queue) {
            queue.submitCustomGeometry(matrices, this.layer, (SubmitNodeCollector.CustomGeometryRenderer)this);
        }

        public void render(PoseStack.Pose matricesEntry, VertexConsumer vertexConsumer) {
            ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)this.middle.center()).rotateY(this.yRot)).rotateX(this.xRot)).uncenter()).translate(0.0f, this.middleOffset, 0.0f)).light(this.light).useLevelLight((BlockAndTintGetter)this.world, this.worldMatrix4f).renderInto(matricesEntry, vertexConsumer);
            ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)this.top.center()).rotateY(this.yRot)).rotateX(this.xRot)).uncenter()).translate(0.0f, this.topOffset, 0.0f)).light(this.light).useLevelLight((BlockAndTintGetter)this.world, this.worldMatrix4f).renderInto(matricesEntry, vertexConsumer);
        }
    }
}

