/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.contraptions.actors.roller;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.api.behaviour.movement.MovementRenderBehaviour;
import com.zurrtum.create.client.api.behaviour.movement.MovementRenderState;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.content.contraptions.actors.roller.RollerActorVisual;
import com.zurrtum.create.client.content.contraptions.render.ActorVisual;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationContext;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationManager;
import com.zurrtum.create.client.foundation.virtualWorld.VirtualRenderWorld;
import com.zurrtum.create.content.contraptions.behaviour.MovementContext;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.rendertype.RenderType;
import net.minecraft.client.renderer.rendertype.RenderTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

public class RollerMovementRenderBehaviour
implements MovementRenderBehaviour {
    @Override
    @Nullable
    public ActorVisual createVisual(VisualizationContext visualizationContext, VirtualRenderWorld simulationWorld, MovementContext movementContext) {
        return new RollerActorVisual(visualizationContext, simulationWorld, movementContext);
    }

    @Override
    public MovementRenderState getRenderState(Vec3 camera, Font textRenderer, MovementContext context, VirtualRenderWorld renderWorld, Matrix4f worldMatrix4f) {
        float speed;
        if (VisualizationManager.supportsVisualization((LevelAccessor)context.world)) {
            return null;
        }
        RollerMovementRenderState state = new RollerMovementRenderState(context.localPos);
        state.layer = RenderTypes.cutoutMovingBlock();
        BlockState blockState = context.state;
        Direction facing = (Direction)blockState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        state.wheel = CachedBuffers.partial(AllPartialModels.ROLLER_WHEEL, blockState);
        float f = speed = !VecHelper.isVecPointingTowards(context.relativeMotion, facing.getOpposite()) ? context.getAnimationSpeed() : -context.getAnimationSpeed();
        if (context.contraption.stalled) {
            speed = 0.0f;
        }
        state.offset = Vec3.atLowerCornerOf((Vec3i)facing.getUnitVec3i()).scale(1.0625).add(0.0, -0.25, 0.0);
        float angle = AngleHelper.horizontalAngle(facing);
        state.wheelAngle = AngleHelper.rad(angle);
        float time = AnimationTickHolder.getRenderTime((LevelAccessor)context.world) / 20.0f;
        state.rotate = AngleHelper.rad(time * speed % 360.0f);
        state.light = LevelRenderer.getLightColor((BlockAndTintGetter)renderWorld, (BlockPos)context.localPos);
        state.world = context.world;
        state.worldMatrix4f = worldMatrix4f;
        state.yRot = 1.5707964f;
        state.frame = CachedBuffers.partial(AllPartialModels.ROLLER_FRAME, blockState);
        state.frameAngle = AngleHelper.rad(angle + 180.0f);
        return state;
    }

    public static class RollerMovementRenderState
    extends MovementRenderState
    implements SubmitNodeCollector.CustomGeometryRenderer {
        public RenderType layer;
        public SuperByteBuffer wheel;
        public Vec3 offset;
        public float wheelAngle;
        public float rotate;
        public int light;
        public Level world;
        public Matrix4f worldMatrix4f;
        public float yRot;
        public SuperByteBuffer frame;
        public float frameAngle;

        public RollerMovementRenderState(BlockPos pos) {
            super(pos);
        }

        @Override
        public void render(PoseStack matrices, SubmitNodeCollector queue) {
            queue.submitCustomGeometry(matrices, this.layer, (SubmitNodeCollector.CustomGeometryRenderer)this);
        }

        public void render(PoseStack.Pose matricesEntry, VertexConsumer vertexConsumer) {
            ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)this.wheel.translate(this.offset)).rotateCentered(this.wheelAngle, Direction.UP)).rotate(this.rotate, Direction.WEST)).translate(0.0, -0.5, 0.5)).rotateY(this.yRot)).light(this.light).useLevelLight((BlockAndTintGetter)this.world, this.worldMatrix4f).renderInto(matricesEntry, vertexConsumer);
            ((SuperByteBuffer)this.frame.rotateCentered(this.frameAngle, Direction.UP)).light(this.light).useLevelLight((BlockAndTintGetter)this.world, this.worldMatrix4f).renderInto(matricesEntry, vertexConsumer);
        }
    }
}

