/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.contraptions.actors.roller;

import com.mojang.blaze3d.vertex.PoseStack;
import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.client.flywheel.lib.transform.PoseTransformStack;
import com.zurrtum.create.client.flywheel.lib.transform.TransformStack;
import com.zurrtum.create.client.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.zurrtum.create.content.contraptions.actors.roller.RollerBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class RollerValueBox
extends ValueBoxTransform {
    private final int hOffset;

    public RollerValueBox(int hOffset) {
        this.hOffset = hOffset;
    }

    @Override
    public void rotate(BlockState state, PoseStack ms) {
        Direction facing = (Direction)state.getValue((Property)RollerBlock.FACING);
        float yRot = AngleHelper.horizontalAngle(facing) + 180.0f;
        ((PoseTransformStack)TransformStack.of(ms).rotateYDegrees(yRot)).rotateXDegrees(90.0f);
    }

    @Override
    public boolean testHit(LevelAccessor level, BlockPos pos, BlockState state, Vec3 localHit) {
        Vec3 offset = this.getLocalOffset(state);
        if (offset == null) {
            return false;
        }
        return localHit.distanceTo(offset) < (double)(this.scale / 3.0f);
    }

    @Override
    public Vec3 getLocalOffset(BlockState state) {
        Direction facing = (Direction)state.getValue((Property)RollerBlock.FACING);
        float stateAngle = AngleHelper.horizontalAngle(facing) + 180.0f;
        return VecHelper.rotateCentered(VecHelper.voxelSpace(8 + this.hOffset, 15.5, 11.0), stateAngle, Direction.Axis.Y);
    }
}

