/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.contraptions.bearing;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.api.behaviour.movement.MovementRenderBehaviour;
import com.zurrtum.create.client.api.behaviour.movement.MovementRenderState;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.content.contraptions.bearing.BearingVisual;
import com.zurrtum.create.client.content.contraptions.bearing.StabilizedBearingVisual;
import com.zurrtum.create.client.content.contraptions.render.ActorVisual;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationContext;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationManager;
import com.zurrtum.create.client.foundation.virtualWorld.VirtualRenderWorld;
import com.zurrtum.create.content.contraptions.AbstractContraptionEntity;
import com.zurrtum.create.content.contraptions.ControlledContraptionEntity;
import com.zurrtum.create.content.contraptions.OrientedContraptionEntity;
import com.zurrtum.create.content.contraptions.behaviour.MovementContext;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.rendertype.RenderType;
import net.minecraft.client.renderer.rendertype.RenderTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class StabilizedBearingMovementRenderBehaviour
implements MovementRenderBehaviour {
    @Override
    @Nullable
    public ActorVisual createVisual(VisualizationContext visualizationContext, VirtualRenderWorld simulationWorld, MovementContext movementContext) {
        return new StabilizedBearingVisual(visualizationContext, simulationWorld, movementContext);
    }

    @Override
    public MovementRenderState getRenderState(Vec3 camera, Font textRenderer, MovementContext context, VirtualRenderWorld renderWorld, Matrix4f worldMatrix4f) {
        if (VisualizationManager.supportsVisualization((LevelAccessor)context.world)) {
            return null;
        }
        StabilizedBearingMovementRenderState state = new StabilizedBearingMovementRenderState(context.localPos);
        state.layer = RenderTypes.solidMovingBlock();
        Direction facing = (Direction)context.state.getValue((Property)BlockStateProperties.FACING);
        state.top = CachedBuffers.partial(AllPartialModels.BEARING_TOP, context.state);
        Quaternionf orientation = BearingVisual.getBlockStateOrientation(facing);
        float angle = StabilizedBearingMovementRenderBehaviour.getCounterRotationAngle(context, facing, AnimationTickHolder.getPartialTicks()) * (float)facing.getAxisDirection().getStep();
        Quaternionf rotation = Axis.of((Vector3f)facing.step()).rotationDegrees(angle);
        state.orientation = rotation.mul((Quaternionfc)orientation);
        state.light = LevelRenderer.getLightColor((BlockAndTintGetter)renderWorld, (BlockPos)context.localPos);
        state.world = context.world;
        state.worldMatrix4f = worldMatrix4f;
        return state;
    }

    static float getCounterRotationAngle(MovementContext context, Direction facing, float renderPartialTicks) {
        if (!context.contraption.canBeStabilized(facing, context.localPos)) {
            return 0.0f;
        }
        float offset = 0.0f;
        Direction.Axis axis = facing.getAxis();
        AbstractContraptionEntity entity = context.contraption.entity;
        if (entity instanceof ControlledContraptionEntity) {
            ControlledContraptionEntity controlledCE = (ControlledContraptionEntity)entity;
            if (context.contraption.canBeStabilized(facing, context.localPos)) {
                offset = -controlledCE.getAngle(renderPartialTicks);
            }
        } else if (entity instanceof OrientedContraptionEntity) {
            OrientedContraptionEntity orientedCE = (OrientedContraptionEntity)entity;
            if (axis.isVertical()) {
                offset = -orientedCE.getViewYRot(renderPartialTicks);
            } else if (orientedCE.isInitialOrientationPresent() && orientedCE.getInitialOrientation().getAxis() == axis) {
                offset = -orientedCE.getViewXRot(renderPartialTicks);
            }
        }
        return offset;
    }

    public static class StabilizedBearingMovementRenderState
    extends MovementRenderState
    implements SubmitNodeCollector.CustomGeometryRenderer {
        public RenderType layer;
        public SuperByteBuffer top;
        public Quaternionf orientation;
        public int light;
        public Level world;
        public Matrix4f worldMatrix4f;

        public StabilizedBearingMovementRenderState(BlockPos pos) {
            super(pos);
        }

        @Override
        public void render(PoseStack matrices, SubmitNodeCollector queue) {
            queue.submitCustomGeometry(matrices, this.layer, (SubmitNodeCollector.CustomGeometryRenderer)this);
        }

        public void render(PoseStack.Pose matricesEntry, VertexConsumer vertexConsumer) {
            ((SuperByteBuffer)this.top.rotateCentered((Quaternionfc)this.orientation)).light(this.light).useLevelLight((BlockAndTintGetter)this.world, this.worldMatrix4f).renderInto(matricesEntry, vertexConsumer);
        }
    }
}

