/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.contraptions.bearing;

import com.mojang.math.Axis;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.content.contraptions.bearing.BearingVisual;
import com.zurrtum.create.client.content.contraptions.bearing.StabilizedBearingMovementRenderBehaviour;
import com.zurrtum.create.client.content.contraptions.render.ActorVisual;
import com.zurrtum.create.client.content.kinetics.base.KineticBlockEntityVisual;
import com.zurrtum.create.client.content.kinetics.base.RotatingInstance;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationContext;
import com.zurrtum.create.client.flywheel.lib.instance.InstanceTypes;
import com.zurrtum.create.client.flywheel.lib.instance.OrientedInstance;
import com.zurrtum.create.client.flywheel.lib.model.Models;
import com.zurrtum.create.client.foundation.render.AllInstanceTypes;
import com.zurrtum.create.client.foundation.virtualWorld.VirtualRenderWorld;
import com.zurrtum.create.content.contraptions.behaviour.MovementContext;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class StabilizedBearingVisual
extends ActorVisual {
    final OrientedInstance topInstance;
    final RotatingInstance shaft;
    final Direction facing;
    final Axis rotationAxis;
    final Quaternionf blockOrientation;

    public StabilizedBearingVisual(VisualizationContext visualizationContext, VirtualRenderWorld simulationWorld, MovementContext movementContext) {
        super(visualizationContext, (BlockAndTintGetter)simulationWorld, movementContext);
        BlockState blockState = movementContext.state;
        this.facing = (Direction)blockState.getValue((Property)BlockStateProperties.FACING);
        this.rotationAxis = Axis.of((Vector3f)Direction.get((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)this.facing.getAxis()).step());
        this.blockOrientation = BearingVisual.getBlockStateOrientation(this.facing);
        this.topInstance = this.instancerProvider.instancer(InstanceTypes.ORIENTED, Models.partial(AllPartialModels.BEARING_TOP)).createInstance();
        int blockLight = this.localBlockLight();
        this.topInstance.position((Vec3i)movementContext.localPos).rotation((Quaternionfc)this.blockOrientation).light(blockLight, 0).setChanged();
        this.shaft = this.instancerProvider.instancer(AllInstanceTypes.ROTATING, Models.partial(AllPartialModels.SHAFT_HALF)).createInstance();
        Direction.Axis axis = KineticBlockEntityVisual.rotationAxis(blockState);
        this.shaft.setRotationAxis(axis).setRotationOffset(KineticBlockEntityVisual.rotationOffset(blockState, axis, (Vec3i)movementContext.localPos)).setPosition((Vec3i)movementContext.localPos).rotateToFace(Direction.SOUTH, ((Direction)blockState.getValue((Property)BlockStateProperties.FACING)).getOpposite()).light(blockLight, 0).setChanged();
    }

    @Override
    public void beginFrame() {
        float counterRotationAngle = StabilizedBearingMovementRenderBehaviour.getCounterRotationAngle(this.context, this.facing, AnimationTickHolder.getPartialTicks());
        Quaternionf rotation = this.rotationAxis.rotationDegrees(counterRotationAngle);
        rotation.mul((Quaternionfc)this.blockOrientation);
        this.topInstance.rotation((Quaternionfc)rotation).setChanged();
    }

    @Override
    protected void _delete() {
        this.topInstance.delete();
        this.shaft.delete();
    }
}

