/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.contraptions.chassis;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.content.contraptions.chassis.StickerBlock;
import com.zurrtum.create.content.contraptions.chassis.StickerBlockEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.state.BlockEntityRenderState;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.rendertype.RenderType;
import net.minecraft.client.renderer.rendertype.RenderTypes;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class StickerRenderer
implements BlockEntityRenderer<StickerBlockEntity, StickerRenderState> {
    public StickerRenderer(BlockEntityRendererProvider.Context context) {
    }

    public StickerRenderState createRenderState() {
        return new StickerRenderState();
    }

    public void extractRenderState(StickerBlockEntity be, StickerRenderState state, float tickProgress, Vec3 cameraPos, @Nullable ModelFeatureRenderer.CrumblingOverlay crumblingOverlay) {
        Level world = be.getLevel();
        BlockEntityRenderState.extractBase((BlockEntity)be, (BlockEntityRenderState)state, (ModelFeatureRenderer.CrumblingOverlay)crumblingOverlay);
        state.layer = RenderTypes.solidMovingBlock();
        state.head = CachedBuffers.partial(AllPartialModels.STICKER_HEAD, state.blockState);
        state.seed = be.hashCode();
        Direction facing = (Direction)state.blockState.getValue((Property)StickerBlock.FACING);
        state.yRot = (float)Math.PI / 180 * AngleHelper.horizontalAngle(facing);
        state.xRot = (float)Math.PI / 180 * (AngleHelper.verticalAngle(facing) + 90.0f);
        float offset = !be.isVirtual() && world != Minecraft.getInstance().level ? ((Boolean)state.blockState.getValue((Property)StickerBlock.EXTENDED) != false ? 1.0f : 0.0f) : be.piston.getValue(AnimationTickHolder.getPartialTicks((LevelAccessor)world));
        state.offset = offset * offset * 4.0f / 16.0f;
    }

    public void submit(StickerRenderState state, PoseStack matrices, SubmitNodeCollector queue, CameraRenderState cameraState) {
        queue.submitCustomGeometry(matrices, state.layer, (SubmitNodeCollector.CustomGeometryRenderer)state);
    }

    public static class StickerRenderState
    extends BlockEntityRenderState
    implements SubmitNodeCollector.CustomGeometryRenderer {
        public RenderType layer;
        public SuperByteBuffer head;
        public int seed;
        public float yRot;
        public float xRot;
        public float offset;

        public void render(PoseStack.Pose matricesEntry, VertexConsumer vertexConsumer) {
            ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)this.head.nudge(this.seed)).center()).rotateY(this.yRot)).rotateX(this.xRot)).uncenter()).translate(0.0f, this.offset, 0.0f);
            this.head.light(this.lightCoords).renderInto(matricesEntry, vertexConsumer);
        }
    }
}

