/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.contraptions.elevator;

import com.google.common.collect.ImmutableList;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.catnip.data.Pair;
import com.zurrtum.create.client.catnip.gui.AbstractSimiScreen;
import com.zurrtum.create.client.catnip.gui.element.GuiGameElement;
import com.zurrtum.create.client.catnip.gui.widget.ElementWidget;
import com.zurrtum.create.client.content.decoration.slidingDoor.SlidingDoorRenderer;
import com.zurrtum.create.client.foundation.gui.AllGuiTextures;
import com.zurrtum.create.client.foundation.gui.AllIcons;
import com.zurrtum.create.client.foundation.gui.widget.IconButton;
import com.zurrtum.create.client.foundation.gui.widget.Label;
import com.zurrtum.create.client.foundation.gui.widget.ScrollInput;
import com.zurrtum.create.client.foundation.gui.widget.TooltipArea;
import com.zurrtum.create.client.foundation.utility.CreateLang;
import com.zurrtum.create.content.decoration.slidingDoor.DoorControl;
import com.zurrtum.create.infrastructure.packet.c2s.ElevatorContactEditPacket;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.client.input.MouseButtonInfo;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.util.FormattedCharSequence;

public class ElevatorContactScreen
extends AbstractSimiScreen {
    private AllGuiTextures background;
    private EditBox shortNameInput;
    private EditBox longNameInput;
    private IconButton confirm;
    private ElementWidget renderedItem;
    private String shortName;
    private String longName;
    private DoorControl doorControl;
    private BlockPos pos;

    public ElevatorContactScreen(BlockPos pos, String prevShortName, String prevLongName, DoorControl prevDoorControl) {
        super((Component)CreateLang.translateDirect("elevator_contact.title", new Object[0]));
        this.pos = pos;
        this.doorControl = prevDoorControl;
        this.background = AllGuiTextures.ELEVATOR_CONTACT;
        this.shortName = prevShortName;
        this.longName = prevLongName;
    }

    @Override
    public void init() {
        this.setWindowSize(this.background.getWidth() + 30, this.background.getHeight());
        super.init();
        int x = this.guiLeft;
        int y = this.guiTop;
        this.confirm = new IconButton(x + 200, y + 58, AllIcons.I_CONFIRM);
        this.confirm.withCallback(this::confirm);
        this.addRenderableWidget(this.confirm);
        this.shortNameInput = this.editBox(33, 30, 4);
        this.shortNameInput.setValue(this.shortName);
        this.centerInput(x);
        this.shortNameInput.setResponder(s -> {
            this.shortName = s;
            this.centerInput(x);
        });
        this.shortNameInput.setFocused(true);
        this.setFocused((GuiEventListener)this.shortNameInput);
        this.shortNameInput.setHighlightPos(0);
        this.longNameInput = this.editBox(63, 140, 30);
        this.longNameInput.setValue(this.longName);
        this.longNameInput.setResponder(s -> {
            this.longName = s;
        });
        MutableComponent rmbToEdit = CreateLang.translate("gui.schedule.lmb_edit", new Object[0]).style(ChatFormatting.DARK_GRAY).style(ChatFormatting.ITALIC).component();
        this.addRenderableOnly((Renderable)new TooltipArea(x + 21, y + 23, 30, 18).withTooltip((List<Component>)ImmutableList.of((Object)CreateLang.translate("elevator_contact.floor_identifier", new Object[0]).color(5476833).component(), (Object)rmbToEdit)));
        this.addRenderableOnly((Renderable)new TooltipArea(x + 57, y + 23, 147, 18).withTooltip((List<Component>)ImmutableList.of((Object)CreateLang.translate("elevator_contact.floor_description", new Object[0]).color(5476833).component(), (Object)CreateLang.translate("crafting_blueprint.optional", new Object[0]).style(ChatFormatting.GRAY).component(), (Object)rmbToEdit)));
        Pair<ScrollInput, Label> doorControlWidgets = SlidingDoorRenderer.createWidget(this.minecraft, x + 58, y + 57, mode -> {
            this.doorControl = mode;
        }, this.doorControl);
        this.addRenderableWidget(doorControlWidgets.getFirst());
        this.addRenderableWidget(doorControlWidgets.getSecond());
        this.renderedItem = new ElementWidget(x + this.background.getWidth() + 6, y + this.background.getHeight() - 56).showingElement(GuiGameElement.of(AllItems.ELEVATOR_CONTACT.getDefaultInstance()).scale(5.0f));
        this.addRenderableWidget(this.renderedItem);
    }

    public void onClose() {
        super.onClose();
        this.renderedItem.getRenderElement().clear();
    }

    private int centerInput(int x) {
        int centeredX = x + (this.shortName.isEmpty() ? 34 : 36 - this.font.width(this.shortName) / 2);
        this.shortNameInput.setX(centeredX);
        return centeredX;
    }

    private EditBox editBox(int x, int width, int chars) {
        EditBox editBox = new EditBox(this.font, this.guiLeft + x, this.guiTop + 30, width, 10, CommonComponents.EMPTY);
        editBox.setTextColor(-1);
        editBox.setTextColorUneditable(-1);
        editBox.setBordered(false);
        editBox.setMaxLength(chars);
        editBox.setFocused(false);
        editBox.mouseClicked(new MouseButtonEvent(0.0, 0.0, new MouseButtonInfo(0, 0)), false);
        this.addRenderableWidget((GuiEventListener)editBox);
        return editBox;
    }

    @Override
    protected void renderWindow(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        int x = this.guiLeft;
        int y = this.guiTop;
        this.background.render(graphics, x, y);
        FormattedCharSequence formattedcharsequence = this.title.getVisualOrderText();
        graphics.drawString(this.font, formattedcharsequence, x + (this.background.getWidth() - 8) / 2 - this.font.width(formattedcharsequence) / 2, y + 6, -13682888, false);
        graphics.renderItem(AllItems.TRAIN_DOOR.getDefaultInstance(), x + 37, y + 58);
    }

    public boolean mouseClicked(MouseButtonEvent click, boolean doubled) {
        boolean consumed = super.mouseClicked(click, doubled);
        if (!this.shortNameInput.isFocused()) {
            int length = this.shortNameInput.getValue().length();
            this.shortNameInput.setHighlightPos(length);
            this.shortNameInput.setCursorPosition(length);
        }
        if (this.shortNameInput.isHoveredOrFocused()) {
            this.longNameInput.mouseClicked(new MouseButtonEvent(0.0, 0.0, new MouseButtonInfo(0, 0)), false);
        }
        if (!consumed && click.x() > (double)(this.guiLeft + 22) && click.y() > (double)(this.guiTop + 24) && click.x() < (double)(this.guiLeft + 50) && click.y() < (double)(this.guiTop + 40)) {
            this.setFocused((GuiEventListener)this.shortNameInput);
            this.shortNameInput.setFocused(true);
            return true;
        }
        return consumed;
    }

    @Override
    public boolean keyPressed(KeyEvent input) {
        if (super.keyPressed(input)) {
            return true;
        }
        int keyCode = input.key();
        if (keyCode == 257) {
            this.confirm();
            return true;
        }
        if (keyCode == 256 && this.shouldCloseOnEsc()) {
            this.onClose();
            return true;
        }
        return false;
    }

    private void confirm() {
        this.minecraft.player.connection.send((Packet)new ElevatorContactEditPacket(this.pos, this.shortName, this.longName, this.doorControl));
        this.onClose();
    }
}

