/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.contraptions.gantry;

import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.content.contraptions.gantry.GantryCarriageRenderer;
import com.zurrtum.create.client.content.kinetics.base.KineticBlockEntityRenderer;
import com.zurrtum.create.client.content.kinetics.base.ShaftVisual;
import com.zurrtum.create.client.flywheel.api.instance.Instance;
import com.zurrtum.create.client.flywheel.api.visual.DynamicVisual;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationContext;
import com.zurrtum.create.client.flywheel.lib.instance.InstanceTypes;
import com.zurrtum.create.client.flywheel.lib.instance.TransformedInstance;
import com.zurrtum.create.client.flywheel.lib.model.Models;
import com.zurrtum.create.client.flywheel.lib.visual.SimpleDynamicVisual;
import com.zurrtum.create.content.contraptions.gantry.GantryCarriageBlock;
import com.zurrtum.create.content.contraptions.gantry.GantryCarriageBlockEntity;
import com.zurrtum.create.content.kinetics.base.KineticBlockEntity;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.state.properties.Property;

public class GantryCarriageVisual
extends ShaftVisual<GantryCarriageBlockEntity>
implements SimpleDynamicVisual {
    private final TransformedInstance gantryCogs;
    final Direction facing;
    final Boolean alongFirst;
    final Direction.Axis rotationAxis;
    final float rotationMult;
    final BlockPos visualPos;
    private float lastAngle = Float.NaN;

    public GantryCarriageVisual(VisualizationContext context, GantryCarriageBlockEntity blockEntity, float partialTick) {
        super(context, blockEntity, partialTick);
        this.gantryCogs = this.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.partial(AllPartialModels.GANTRY_COGS)).createInstance();
        this.facing = (Direction)this.blockState.getValue((Property)GantryCarriageBlock.FACING);
        this.alongFirst = (Boolean)this.blockState.getValue((Property)GantryCarriageBlock.AXIS_ALONG_FIRST_COORDINATE);
        this.rotationAxis = KineticBlockEntityRenderer.getRotationAxisOf(blockEntity);
        this.rotationMult = GantryCarriageVisual.getRotationMultiplier(this.getGantryAxis(), this.facing);
        this.visualPos = this.facing.getAxisDirection() == Direction.AxisDirection.POSITIVE ? blockEntity.getBlockPos() : blockEntity.getBlockPos().relative(this.facing.getOpposite());
        this.animateCogs(this.getCogAngle());
    }

    @Override
    public void beginFrame(DynamicVisual.Context ctx) {
        float cogAngle = this.getCogAngle();
        if (Mth.equal((float)cogAngle, (float)this.lastAngle)) {
            return;
        }
        this.animateCogs(cogAngle);
    }

    private float getCogAngle() {
        return GantryCarriageRenderer.getAngleForBE((KineticBlockEntity)this.blockEntity, this.visualPos, this.rotationAxis) * this.rotationMult;
    }

    private void animateCogs(float cogAngle) {
        ((TransformedInstance)((TransformedInstance)((TransformedInstance)((TransformedInstance)((TransformedInstance)((TransformedInstance)((TransformedInstance)this.gantryCogs.setIdentityTransform().translate((Vec3i)this.getVisualPosition())).center()).rotateYDegrees(AngleHelper.horizontalAngle(this.facing))).rotateXDegrees(this.facing == Direction.UP ? 0.0f : (this.facing == Direction.DOWN ? 180.0f : 90.0f))).rotateYDegrees(this.alongFirst ^ this.facing.getAxis() == Direction.Axis.X ? 0.0f : 90.0f)).translate(0.0f, -0.5625f, 0.0f).rotateXDegrees(-cogAngle)).translate(0.0f, 0.5625f, 0.0f).uncenter()).setChanged();
    }

    static float getRotationMultiplier(Direction.Axis gantryAxis, Direction facing) {
        float multiplier = 1.0f;
        if (gantryAxis == Direction.Axis.X && facing == Direction.UP) {
            multiplier *= -1.0f;
        }
        if (gantryAxis == Direction.Axis.Y && (facing == Direction.NORTH || facing == Direction.EAST)) {
            multiplier *= -1.0f;
        }
        return multiplier;
    }

    private Direction.Axis getGantryAxis() {
        Direction.Axis gantryAxis = Direction.Axis.X;
        for (Direction.Axis axis : Iterate.axes) {
            if (axis == this.rotationAxis || axis == this.facing.getAxis()) continue;
            gantryAxis = axis;
        }
        return gantryAxis;
    }

    @Override
    public void updateLight(float partialTick) {
        this.relight(this.gantryCogs, this.rotatingModel);
    }

    @Override
    protected void _delete() {
        super._delete();
        this.gantryCogs.delete();
    }

    @Override
    public void collectCrumblingInstances(Consumer<Instance> consumer) {
        super.collectCrumblingInstances(consumer);
        consumer.accept(this.gantryCogs);
    }
}

