/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.contraptions.pulley;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.SpriteShiftEntry;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.content.kinetics.base.KineticBlockEntityRenderer;
import com.zurrtum.create.client.flywheel.lib.model.baked.PartialModel;
import com.zurrtum.create.content.kinetics.base.KineticBlockEntity;
import com.zurrtum.create.infrastructure.config.AllConfigs;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.rendertype.RenderType;
import net.minecraft.client.renderer.rendertype.RenderTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractPulleyRenderer<T extends KineticBlockEntity>
extends KineticBlockEntityRenderer<T, PulleyRenderState> {
    private final PartialModel halfRope;
    private final PartialModel halfMagnet;

    public AbstractPulleyRenderer(BlockEntityRendererProvider.Context context, PartialModel halfRope, PartialModel halfMagnet) {
        super(context);
        this.halfRope = halfRope;
        this.halfMagnet = halfMagnet;
    }

    public boolean shouldRenderOffScreen() {
        return true;
    }

    @Override
    public PulleyRenderState createRenderState() {
        return new PulleyRenderState();
    }

    @Override
    public void extractRenderState(T be, PulleyRenderState state, float tickProgress, Vec3 cameraPos, @Nullable ModelFeatureRenderer.CrumblingOverlay crumblingOverlay) {
        float f;
        super.extractRenderState(be, state, tickProgress, cameraPos, crumblingOverlay);
        if (state.support) {
            return;
        }
        float offset = this.getOffset(be, tickProgress);
        boolean running = this.isRunning(be);
        state.coil = this.getRotatedCoil(be);
        state.coilShift = this.getCoilShift();
        state.coilScroll = AbstractPulleyRenderer.getCoilVScroll(state.coilShift, offset, 1.0f);
        Level world = be.getLevel();
        BlockState blockState = be.getBlockState();
        if (running || offset == 0.0f) {
            state.magnet = offset > 0.25f ? this.renderMagnet(be) : CachedBuffers.partial(this.halfMagnet, blockState);
            state.magnetOffset = -offset;
            state.magnetLight = LevelRenderer.getLightColor((BlockAndTintGetter)world, (BlockPos)state.blockPos.below((int)offset));
        }
        if (offset > 0.75f && ((f = offset % 1.0f) < 0.25f || f > 0.75f)) {
            state.halfRope = CachedBuffers.partial(this.halfRope, blockState);
            float down = f > 0.75f ? f - 1.0f : f;
            state.halfRopeOffset = -down;
            state.halfRopeLight = LevelRenderer.getLightColor((BlockAndTintGetter)world, (BlockPos)state.blockPos.below((int)down));
        }
        if (!running || offset <= 1.25f) {
            return;
        }
        state.rope = this.renderRope(be);
        int size = (int)Math.ceil(offset - 1.25f);
        float[] offsets = new float[size];
        int[] lights = new int[size];
        for (int i = 0; i < size; ++i) {
            float down = offset - (float)i - 1.0f;
            int light = LevelRenderer.getLightColor((BlockAndTintGetter)world, (BlockPos)state.blockPos.below((int)down));
            offsets[i] = -down;
            lights[i] = light;
        }
        state.offsets = offsets;
        state.lights = lights;
    }

    @Override
    protected RenderType getRenderType(T be, BlockState state) {
        return RenderTypes.solidMovingBlock();
    }

    protected abstract Direction.Axis getShaftAxis(T var1);

    protected abstract PartialModel getCoil();

    protected abstract SpriteShiftEntry getCoilShift();

    protected abstract SuperByteBuffer renderRope(T var1);

    protected abstract SuperByteBuffer renderMagnet(T var1);

    protected abstract float getOffset(T var1, float var2);

    protected abstract boolean isRunning(T var1);

    @Override
    protected BlockState getRenderedBlockState(T be) {
        return AbstractPulleyRenderer.shaft(this.getShaftAxis(be));
    }

    protected SuperByteBuffer getRotatedCoil(T be) {
        BlockState blockState = be.getBlockState();
        return CachedBuffers.partialFacing(this.getCoil(), blockState, Direction.get((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)this.getShaftAxis(be)));
    }

    public static float getCoilVScroll(SpriteShiftEntry coilShift, float offset, float speedModifier) {
        if (offset == 0.0f) {
            return 0.0f;
        }
        float spriteSize = coilShift.getTarget().getV1() - coilShift.getTarget().getV0();
        double coilScroll = (double)(-((offset *= speedModifier / 2.0f) + 0.1875f)) - Math.floor((offset + 0.1875f) * -2.0f) / 2.0;
        return (float)coilScroll * spriteSize;
    }

    public int getViewDistance() {
        return (Integer)AllConfigs.server().kinetics.maxRopeLength.get();
    }

    public static class PulleyRenderState
    extends KineticBlockEntityRenderer.KineticRenderState {
        public SuperByteBuffer coil;
        public SpriteShiftEntry coilShift;
        public float coilScroll;
        public SuperByteBuffer magnet;
        public float magnetOffset;
        public int magnetLight;
        public SuperByteBuffer halfRope;
        public float halfRopeOffset;
        public int halfRopeLight;
        public SuperByteBuffer rope;
        public float[] offsets;
        public int[] lights;

        @Override
        public void render(PoseStack.Pose matricesEntry, VertexConsumer vertexConsumer) {
            super.render(matricesEntry, vertexConsumer);
            if (this.coilScroll != 0.0f) {
                this.coil.shiftUVScrolling(this.coilShift, this.coilScroll);
            }
            this.coil.light(this.lightCoords).renderInto(matricesEntry, vertexConsumer);
            if (this.magnet != null) {
                ((SuperByteBuffer)this.magnet.translate(0.0f, this.magnetOffset, 0.0f)).light(this.magnetLight).renderInto(matricesEntry, vertexConsumer);
            }
            if (this.halfRope != null) {
                ((SuperByteBuffer)this.halfRope.translate(0.0f, this.halfRopeOffset, 0.0f)).light(this.halfRopeLight).renderInto(matricesEntry, vertexConsumer);
            }
            if (this.rope != null) {
                int size = this.offsets.length;
                for (int i = 0; i < size; ++i) {
                    ((SuperByteBuffer)this.rope.translate(0.0f, this.offsets[i], 0.0f)).light(this.lights[i]).renderInto(matricesEntry, vertexConsumer);
                }
            }
        }
    }
}

