/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.contraptions.pulley;

import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.AllSpriteShifts;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.SpriteShiftEntry;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.content.contraptions.pulley.AbstractPulleyRenderer;
import com.zurrtum.create.client.flywheel.lib.model.baked.PartialModel;
import com.zurrtum.create.content.contraptions.AbstractContraptionEntity;
import com.zurrtum.create.content.contraptions.pulley.PulleyBlock;
import com.zurrtum.create.content.contraptions.pulley.PulleyBlockEntity;
import com.zurrtum.create.content.contraptions.pulley.PulleyContraption;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.state.properties.Property;

public class PulleyRenderer
extends AbstractPulleyRenderer<PulleyBlockEntity> {
    public PulleyRenderer(BlockEntityRendererProvider.Context context) {
        super(context, AllPartialModels.ROPE_HALF, AllPartialModels.ROPE_HALF_MAGNET);
    }

    @Override
    protected Direction.Axis getShaftAxis(PulleyBlockEntity be) {
        return (Direction.Axis)be.getBlockState().getValue((Property)PulleyBlock.HORIZONTAL_AXIS);
    }

    @Override
    protected PartialModel getCoil() {
        return AllPartialModels.ROPE_COIL;
    }

    @Override
    protected SuperByteBuffer renderRope(PulleyBlockEntity be) {
        return CachedBuffers.block(AllBlocks.ROPE.defaultBlockState());
    }

    @Override
    protected SuperByteBuffer renderMagnet(PulleyBlockEntity be) {
        return CachedBuffers.block(AllBlocks.PULLEY_MAGNET.defaultBlockState());
    }

    @Override
    protected float getOffset(PulleyBlockEntity be, float partialTicks) {
        return PulleyRenderer.getBlockEntityOffset(partialTicks, be);
    }

    @Override
    protected boolean isRunning(PulleyBlockEntity be) {
        return PulleyRenderer.isPulleyRunning(be);
    }

    public static boolean isPulleyRunning(PulleyBlockEntity be) {
        return be.running || be.getMirrorParent() != null || be.isVirtual();
    }

    @Override
    protected SpriteShiftEntry getCoilShift() {
        return AllSpriteShifts.ROPE_PULLEY_COIL;
    }

    public static float getBlockEntityOffset(float partialTicks, PulleyBlockEntity blockEntity) {
        float offset = blockEntity.getInterpolatedOffset(partialTicks);
        AbstractContraptionEntity attachedContraption = blockEntity.getAttachedContraption();
        if (attachedContraption != null) {
            PulleyContraption c = (PulleyContraption)attachedContraption.getContraption();
            double entityPos = Mth.lerp((double)partialTicks, (double)attachedContraption.yOld, (double)attachedContraption.getY());
            offset = (float)(-(entityPos - (double)c.anchor.getY() - (double)c.getInitialOffset()));
        }
        return offset;
    }
}

