/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.contraptions.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.zurrtum.create.client.content.contraptions.render.ContraptionEntityRenderer;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

public class ContraptionMatrices {
    private final PoseStack modelViewProjection = new PoseStack();
    private final PoseStack viewProjection = new PoseStack();
    private final PoseStack model = new PoseStack();
    private final Matrix4f world = new Matrix4f();
    private final Matrix4f light = new Matrix4f();

    <S extends ContraptionEntityRenderer.AbstractContraptionState> void setup(ContraptionEntityRenderer<?, S> renderer, PoseStack viewProjection, S state) {
        this.viewProjection.pushPose();
        ContraptionMatrices.transform(this.viewProjection, viewProjection);
        this.model.pushPose();
        renderer.transform(state, this.model);
        this.modelViewProjection.pushPose();
        ContraptionMatrices.transform(this.modelViewProjection, viewProjection);
        ContraptionMatrices.transform(this.modelViewProjection, this.model);
        ContraptionMatrices.translateToEntity(this.world, state);
        this.light.set((Matrix4fc)this.world);
        this.light.mul((Matrix4fc)this.model.last().pose());
    }

    void clear() {
        ContraptionMatrices.clearStack(this.modelViewProjection);
        ContraptionMatrices.clearStack(this.viewProjection);
        ContraptionMatrices.clearStack(this.model);
        this.world.identity();
        this.light.identity();
    }

    public PoseStack getModelViewProjection() {
        return this.modelViewProjection;
    }

    public PoseStack getViewProjection() {
        return this.viewProjection;
    }

    public PoseStack getModel() {
        return this.model;
    }

    public Matrix4f getWorld() {
        return this.world;
    }

    public Matrix4f getLight() {
        return this.light;
    }

    public static void transform(PoseStack ms, PoseStack transform) {
        ms.last().pose().mul((Matrix4fc)transform.last().pose());
        ms.last().normal().mul((Matrix3fc)transform.last().normal());
    }

    public static void translateToEntity(Matrix4f matrix, ContraptionEntityRenderer.AbstractContraptionState state) {
        matrix.setTranslation((float)state.x, (float)state.y, (float)state.z);
    }

    public static void clearStack(PoseStack ms) {
        while (!ms.isEmpty()) {
            ms.popPose();
        }
    }
}

