/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.contraptions.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.zurrtum.create.api.behaviour.movement.MovementBehaviour;
import com.zurrtum.create.client.api.behaviour.movement.MovementRenderBehaviour;
import com.zurrtum.create.client.content.contraptions.render.ActorVisual;
import com.zurrtum.create.client.content.contraptions.render.ClientContraption;
import com.zurrtum.create.client.flywheel.api.instance.Instancer;
import com.zurrtum.create.client.flywheel.api.material.CardinalLightingMode;
import com.zurrtum.create.client.flywheel.api.material.Material;
import com.zurrtum.create.client.flywheel.api.task.Plan;
import com.zurrtum.create.client.flywheel.api.visual.BlockEntityVisual;
import com.zurrtum.create.client.flywheel.api.visual.DynamicVisual;
import com.zurrtum.create.client.flywheel.api.visual.SectionTrackedVisual;
import com.zurrtum.create.client.flywheel.api.visual.ShaderLightVisual;
import com.zurrtum.create.client.flywheel.api.visual.TickableVisual;
import com.zurrtum.create.client.flywheel.api.visual.Visual;
import com.zurrtum.create.client.flywheel.api.visualization.BlockEntityVisualizer;
import com.zurrtum.create.client.flywheel.api.visualization.VisualEmbedding;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationContext;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizerRegistry;
import com.zurrtum.create.client.flywheel.lib.instance.InstanceTypes;
import com.zurrtum.create.client.flywheel.lib.instance.TransformedInstance;
import com.zurrtum.create.client.flywheel.lib.material.SimpleMaterial;
import com.zurrtum.create.client.flywheel.lib.model.ModelUtil;
import com.zurrtum.create.client.flywheel.lib.model.SimpleModel;
import com.zurrtum.create.client.flywheel.lib.model.baked.BlockModelBuilder;
import com.zurrtum.create.client.flywheel.lib.task.ForEachPlan;
import com.zurrtum.create.client.flywheel.lib.task.NestedPlan;
import com.zurrtum.create.client.flywheel.lib.task.PlanMap;
import com.zurrtum.create.client.flywheel.lib.task.RunnablePlan;
import com.zurrtum.create.client.flywheel.lib.visual.AbstractEntityVisual;
import com.zurrtum.create.client.foundation.utility.worldWrappers.WrappedBlockAndTintGetter;
import com.zurrtum.create.client.foundation.virtualWorld.VirtualRenderWorld;
import com.zurrtum.create.content.contraptions.AbstractContraptionEntity;
import com.zurrtum.create.content.contraptions.Contraption;
import com.zurrtum.create.content.contraptions.behaviour.MovementContext;
import it.unimi.dsi.fastutil.longs.LongArraySet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateHolder;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.AABB;
import org.apache.commons.lang3.tuple.MutablePair;
import org.joml.Matrix3fc;
import org.joml.Matrix4fc;

public class ContraptionVisual<E extends AbstractContraptionEntity>
extends AbstractEntityVisual<E>
implements DynamicVisual,
TickableVisual,
ShaderLightVisual {
    protected static final int DEFAULT_LIGHT_PADDING = 1;
    protected final VisualEmbedding embedding;
    protected final List<BlockEntityVisual<?>> children = new ArrayList();
    protected final List<ActorVisual> actors = new ArrayList<ActorVisual>();
    protected final PlanMap<DynamicVisual, DynamicVisual.Context> dynamicVisuals = new PlanMap();
    protected final PlanMap<TickableVisual, TickableVisual.Context> tickableVisuals = new PlanMap();
    protected TransformedInstance structure;
    protected SectionTrackedVisual.SectionCollector sectionCollector;
    protected long minSection;
    protected long maxSection;
    protected int lightPaddingBlocks = 1;
    protected int lastStructureVersion;
    protected int lastVersionChildren;
    private final PoseStack contraptionMatrix = new PoseStack();

    public ContraptionVisual(VisualizationContext ctx, E entity, float partialTick) {
        super(ctx, entity, partialTick);
        this.embedding = ctx.createEmbedding(Vec3i.ZERO);
        this.setEmbeddingMatrices(partialTick);
        Contraption contraption = ((AbstractContraptionEntity)((Object)entity)).getContraption();
        if (contraption == null) {
            return;
        }
        ClientContraption clientContraption = this.getOrCreateClientContraptionLazy(contraption);
        this.setupStructure(clientContraption);
        this.setupChildren(contraption, clientContraption, partialTick);
    }

    private void setupStructure(ClientContraption clientContraption) {
        VirtualRenderWorld renderLevel = clientContraption.getRenderLevel();
        final ClientContraption.RenderedBlocks blocks = clientContraption.getRenderedBlocks();
        WrappedBlockAndTintGetter modelWorld = new WrappedBlockAndTintGetter(this, (BlockAndTintGetter)renderLevel){

            @Override
            public BlockState getBlockState(BlockPos pos) {
                return blocks.lookup().apply(pos);
            }
        };
        SimpleModel model = new BlockModelBuilder(modelWorld, blocks.positions()).materialFunc((renderType, shaded) -> {
            Material material = ModelUtil.getMaterial(renderType, shaded);
            if (material != null && material.cardinalLightingMode() == CardinalLightingMode.ENTITY) {
                return SimpleMaterial.builderOf(material).cardinalLightingMode(CardinalLightingMode.CHUNK).build();
            }
            return material;
        }).build();
        Instancer<TransformedInstance> instancer = this.embedding.instancerProvider().instancer(InstanceTypes.TRANSFORMED, model);
        if (this.structure == null) {
            this.structure = instancer.createInstance();
        } else {
            instancer.stealInstance(this.structure);
        }
        this.structure.setChanged();
        this.lastStructureVersion = clientContraption.structureVersion();
    }

    public ClientContraption getOrCreateClientContraptionLazy(Contraption contraption) {
        AtomicReference<?> clientContraption = contraption.clientContraption;
        ClientContraption out = (ClientContraption)clientContraption.getAcquire();
        if (out == null) {
            clientContraption.compareAndExchangeRelease(null, this.createClientContraption(contraption));
            out = (ClientContraption)clientContraption.getAcquire();
        }
        return out;
    }

    protected ClientContraption createClientContraption(Contraption contraption) {
        return new ClientContraption(contraption);
    }

    private void setupChildren(Contraption contraption, ClientContraption clientContraption, float partialTick) {
        this.children.forEach(Visual::delete);
        this.children.clear();
        this.dynamicVisuals.clear();
        this.tickableVisuals.clear();
        for (BlockEntity be : clientContraption.renderedBlockEntityView) {
            this.setupVisualizer(be, partialTick);
        }
        VirtualRenderWorld renderLevel = clientContraption.getRenderLevel();
        this.actors.forEach(ActorVisual::delete);
        this.actors.clear();
        for (MutablePair<StructureTemplate.StructureBlockInfo, MovementContext> actor : contraption.getActors()) {
            this.setupActor(actor, renderLevel);
        }
        this.lastVersionChildren = clientContraption.childrenVersion();
    }

    protected <T extends BlockEntity> void setupVisualizer(T be, float partialTicks) {
        BlockEntityVisualizer<T> visualizer = VisualizerRegistry.getVisualizer(be.getType());
        if (visualizer == null) {
            return;
        }
        BlockEntityVisual visual = visualizer.createVisual(this.embedding, be, partialTicks);
        this.children.add(visual);
        if (visual instanceof DynamicVisual) {
            DynamicVisual dynamic = (DynamicVisual)((Object)visual);
            this.dynamicVisuals.add(dynamic, dynamic.planFrame());
        }
        if (visual instanceof TickableVisual) {
            TickableVisual tickable = (TickableVisual)((Object)visual);
            this.tickableVisuals.add(tickable, tickable.planTick());
        }
    }

    protected void setupActor(MutablePair<StructureTemplate.StructureBlockInfo, MovementContext> actor, VirtualRenderWorld renderLevel) {
        StructureTemplate.StructureBlockInfo blockInfo;
        MovementBehaviour movementBehaviour;
        MovementContext context = (MovementContext)actor.getRight();
        if (context == null) {
            return;
        }
        if (context.world == null) {
            context.world = this.level;
        }
        if ((movementBehaviour = MovementBehaviour.REGISTRY.get((StateHolder<Block, ?>)(blockInfo = (StructureTemplate.StructureBlockInfo)actor.getLeft()).state())) == null || movementBehaviour.attachRender == null) {
            return;
        }
        MovementRenderBehaviour render = (MovementRenderBehaviour)movementBehaviour.attachRender;
        ActorVisual visual = render.createVisual(this.embedding, renderLevel, context);
        if (visual == null) {
            return;
        }
        this.actors.add(visual);
    }

    @Override
    public Plan<TickableVisual.Context> planTick() {
        return NestedPlan.of(ForEachPlan.of(() -> this.actors, ActorVisual::tick), this.tickableVisuals);
    }

    @Override
    public Plan<DynamicVisual.Context> planFrame() {
        return RunnablePlan.of(this::beginFrame).then(NestedPlan.of(ForEachPlan.of(() -> this.actors, ActorVisual::beginFrame), this.dynamicVisuals));
    }

    protected void beginFrame(DynamicVisual.Context context) {
        float partialTick = context.partialTick();
        this.setEmbeddingMatrices(partialTick);
        this.checkAndUpdateLightSections();
        Contraption contraption = ((AbstractContraptionEntity)this.entity).getContraption();
        ClientContraption clientContraption = this.getOrCreateClientContraptionLazy(contraption);
        if (this.lastStructureVersion != clientContraption.structureVersion()) {
            this.setupStructure(clientContraption);
        }
        if (this.lastVersionChildren != clientContraption.childrenVersion()) {
            this.setupChildren(contraption, clientContraption, partialTick);
        }
    }

    private void setEmbeddingMatrices(float partialTick) {
        double z;
        double y;
        double x;
        Vec3i origin = this.renderOrigin();
        if (((AbstractContraptionEntity)this.entity).isPrevPosInvalid()) {
            x = ((AbstractContraptionEntity)this.entity).getX() - (double)origin.getX();
            y = ((AbstractContraptionEntity)this.entity).getY() - (double)origin.getY();
            z = ((AbstractContraptionEntity)this.entity).getZ() - (double)origin.getZ();
        } else {
            x = Mth.lerp((double)partialTick, (double)((AbstractContraptionEntity)this.entity).xo, (double)((AbstractContraptionEntity)this.entity).getX()) - (double)origin.getX();
            y = Mth.lerp((double)partialTick, (double)((AbstractContraptionEntity)this.entity).yo, (double)((AbstractContraptionEntity)this.entity).getY()) - (double)origin.getY();
            z = Mth.lerp((double)partialTick, (double)((AbstractContraptionEntity)this.entity).zo, (double)((AbstractContraptionEntity)this.entity).getZ()) - (double)origin.getZ();
        }
        this.contraptionMatrix.setIdentity();
        this.contraptionMatrix.translate(x, y, z);
        this.transform(this.contraptionMatrix, partialTick);
        this.embedding.transforms((Matrix4fc)this.contraptionMatrix.last().pose(), (Matrix3fc)this.contraptionMatrix.last().normal());
    }

    public void transform(PoseStack contraptionMatrix, float partialTick) {
    }

    @Override
    public void setSectionCollector(SectionTrackedVisual.SectionCollector collector) {
        this.sectionCollector = collector;
        this.checkAndUpdateLightSections();
    }

    private void checkAndUpdateLightSections() {
        AABB boundingBox = ((AbstractContraptionEntity)this.entity).getBoundingBox();
        int minSectionX = SectionPos.posToSectionCoord((double)(Mth.floor((double)boundingBox.minX) - this.lightPaddingBlocks));
        int minSectionY = SectionPos.posToSectionCoord((double)(Mth.floor((double)boundingBox.minY) - this.lightPaddingBlocks));
        int minSectionZ = SectionPos.posToSectionCoord((double)(Mth.floor((double)boundingBox.minZ) - this.lightPaddingBlocks));
        int maxSectionX = SectionPos.posToSectionCoord((double)(Mth.ceil((double)boundingBox.maxX) + this.lightPaddingBlocks));
        int maxSectionY = SectionPos.posToSectionCoord((double)(Mth.ceil((double)boundingBox.maxY) + this.lightPaddingBlocks));
        int maxSectionZ = SectionPos.posToSectionCoord((double)(Mth.ceil((double)boundingBox.maxZ) + this.lightPaddingBlocks));
        if (this.minSection == SectionPos.asLong((int)minSectionX, (int)minSectionY, (int)minSectionZ) && this.maxSection == SectionPos.asLong((int)maxSectionX, (int)maxSectionY, (int)maxSectionZ)) {
            return;
        }
        this.minSection = SectionPos.asLong((int)minSectionX, (int)minSectionY, (int)minSectionZ);
        this.maxSection = SectionPos.asLong((int)maxSectionX, (int)maxSectionY, (int)maxSectionZ);
        LongArraySet longSet = new LongArraySet();
        for (int x = minSectionX; x <= maxSectionX; ++x) {
            for (int y = minSectionY; y <= maxSectionY; ++y) {
                for (int z = minSectionZ; z <= maxSectionZ; ++z) {
                    longSet.add(SectionPos.asLong((int)x, (int)y, (int)z));
                }
            }
        }
        this.sectionCollector.sections((LongSet)longSet);
    }

    @Override
    protected void _delete() {
        this.children.forEach(Visual::delete);
        this.actors.forEach(ActorVisual::delete);
        if (this.structure != null) {
            this.structure.delete();
        }
        this.embedding.delete();
    }
}

