/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.contraptions.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.client.content.contraptions.render.ContraptionEntityRenderer;
import com.zurrtum.create.client.flywheel.lib.transform.PoseTransformStack;
import com.zurrtum.create.client.flywheel.lib.transform.TransformStack;
import com.zurrtum.create.content.contraptions.ControlledContraptionEntity;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.core.Direction;

public class ControlledContraptionEntityRenderer
extends ContraptionEntityRenderer<ControlledContraptionEntity, ControlledContraptionState> {
    public ControlledContraptionEntityRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    @Override
    public ControlledContraptionState createRenderState() {
        return new ControlledContraptionState();
    }

    @Override
    public void extractRenderState(ControlledContraptionEntity entity, ControlledContraptionState state, float tickProgress) {
        state.angle = (float)Math.PI / 180 * (tickProgress == 1.0f ? entity.angle : AngleHelper.angleLerp(tickProgress, entity.prevAngle, entity.angle));
        state.axis = entity.getRotationAxis();
        state.seed = entity.getId();
        super.extractRenderState(entity, state, tickProgress);
    }

    @Override
    public void transform(ControlledContraptionState state, PoseStack matrixStack) {
        PoseTransformStack transformStack = (PoseTransformStack)TransformStack.of(matrixStack).nudge(state.seed);
        if (state.axis != null) {
            ((PoseTransformStack)((PoseTransformStack)transformStack.center()).rotate(state.angle, state.axis)).uncenter();
        }
    }

    public static class ControlledContraptionState
    extends ContraptionEntityRenderer.AbstractContraptionState {
        float angle;
        int seed;
        Direction.Axis axis;
    }
}

