/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.contraptions.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.zurrtum.create.AllContraptionTypeTags;
import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.client.content.contraptions.render.ContraptionEntityRenderer;
import com.zurrtum.create.client.content.contraptions.render.OrientedContraptionVisual;
import com.zurrtum.create.client.flywheel.lib.transform.PoseTransformStack;
import com.zurrtum.create.client.flywheel.lib.transform.TransformStack;
import com.zurrtum.create.content.contraptions.AbstractContraptionEntity;
import com.zurrtum.create.content.contraptions.OrientedContraptionEntity;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.vehicle.minecart.AbstractMinecart;
import net.minecraft.world.phys.Vec3;

public class OrientedContraptionEntityRenderer<C extends OrientedContraptionEntity, S extends OrientedContraptionState>
extends ContraptionEntityRenderer<C, S> {
    public OrientedContraptionEntityRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    @Override
    public S createRenderState() {
        return (S)((Object)new OrientedContraptionState());
    }

    @Override
    public boolean shouldRender(C entity, Frustum frustum, double cameraX, double cameraY, double cameraZ) {
        if (!super.shouldRender(entity, frustum, cameraX, cameraY, cameraZ)) {
            return false;
        }
        return entity.getVehicle() != null || !((AbstractContraptionEntity)((Object)entity)).getContraption().getType().is(AllContraptionTypeTags.REQUIRES_VEHICLE_FOR_RENDER);
    }

    @Override
    public void extractRenderState(C entity, S state, float tickProgress) {
        Entity ridingEntity = entity.getVehicle();
        if (ridingEntity instanceof AbstractMinecart) {
            AbstractMinecart cart = (AbstractMinecart)ridingEntity;
            ((OrientedContraptionState)((Object)state)).offset = OrientedContraptionVisual.getCartOffset(tickProgress, cart);
        } else if (ridingEntity instanceof AbstractContraptionEntity) {
            AbstractContraptionEntity be = (AbstractContraptionEntity)ridingEntity;
            Entity entity2 = ridingEntity.getVehicle();
            if (entity2 instanceof AbstractMinecart) {
                AbstractMinecart cart = (AbstractMinecart)entity2;
                ((OrientedContraptionState)((Object)state)).offset = OrientedContraptionVisual.getCartOffset(tickProgress, cart);
            } else {
                ((OrientedContraptionState)((Object)state)).offset = OrientedContraptionVisual.getContraptionOffset(entity, tickProgress, be);
            }
        }
        ((OrientedContraptionState)((Object)state)).seed = entity.getId();
        boolean done = tickProgress == 1.0f;
        ((OrientedContraptionState)((Object)state)).angleYaw = (float)Math.PI / 180 * (done ? -((OrientedContraptionEntity)((Object)entity)).yaw : -AngleHelper.angleLerp(tickProgress, ((OrientedContraptionEntity)((Object)entity)).prevYaw, ((OrientedContraptionEntity)((Object)entity)).yaw));
        ((OrientedContraptionState)((Object)state)).anglePitch = (float)Math.PI / 180 * (done ? ((OrientedContraptionEntity)((Object)entity)).pitch : AngleHelper.angleLerp(tickProgress, ((OrientedContraptionEntity)((Object)entity)).prevPitch, ((OrientedContraptionEntity)((Object)entity)).pitch));
        ((OrientedContraptionState)((Object)state)).angleInitialYaw = (float)Math.PI / 180 * ((OrientedContraptionEntity)((Object)entity)).getInitialYaw();
        super.extractRenderState(entity, state, tickProgress);
    }

    @Override
    public void transform(OrientedContraptionState state, PoseStack matrixStack) {
        matrixStack.translate(-0.5f, 0.0f, -0.5f);
        if (state.offset != null) {
            matrixStack.translate(state.offset);
        }
        ((PoseTransformStack)((PoseTransformStack)((PoseTransformStack)((PoseTransformStack)((PoseTransformStack)TransformStack.of(matrixStack).nudge(state.seed)).center()).rotateY(state.angleYaw)).rotateZ(state.anglePitch)).rotateY(state.angleInitialYaw)).uncenter();
    }

    public static class OrientedContraptionState
    extends ContraptionEntityRenderer.AbstractContraptionState {
        public float angleYaw;
        public float anglePitch;
        public float angleInitialYaw;
        int seed;
        Vec3 offset;
    }
}

