/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.contraptions.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.zurrtum.create.client.content.contraptions.render.ContraptionVisual;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationContext;
import com.zurrtum.create.client.flywheel.lib.transform.PoseTransformStack;
import com.zurrtum.create.client.flywheel.lib.transform.TransformStack;
import com.zurrtum.create.content.contraptions.AbstractContraptionEntity;
import com.zurrtum.create.content.contraptions.OrientedContraptionEntity;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.vehicle.minecart.AbstractMinecart;
import net.minecraft.world.entity.vehicle.minecart.MinecartBehavior;
import net.minecraft.world.entity.vehicle.minecart.OldMinecartBehavior;
import net.minecraft.world.phys.Vec3;

public class OrientedContraptionVisual<T extends OrientedContraptionEntity>
extends ContraptionVisual<T> {
    public OrientedContraptionVisual(VisualizationContext ctx, T entity, float partialTick) {
        super(ctx, entity, partialTick);
    }

    @Override
    public void transform(PoseStack matrixStack, float partialTicks) {
        float angleInitialYaw = ((OrientedContraptionEntity)this.entity).getInitialYaw();
        float angleYaw = ((OrientedContraptionEntity)this.entity).getViewYRot(partialTicks);
        float anglePitch = ((OrientedContraptionEntity)this.entity).getViewXRot(partialTicks);
        matrixStack.translate(-0.5f, 0.0f, -0.5f);
        Entity ridingEntity = ((OrientedContraptionEntity)this.entity).getVehicle();
        if (ridingEntity instanceof AbstractMinecart) {
            AbstractMinecart cart = (AbstractMinecart)ridingEntity;
            OrientedContraptionVisual.repositionOnCart(matrixStack, partialTicks, cart);
        } else if (ridingEntity instanceof AbstractContraptionEntity) {
            AbstractContraptionEntity be = (AbstractContraptionEntity)ridingEntity;
            Entity entity = ridingEntity.getVehicle();
            if (entity instanceof AbstractMinecart) {
                AbstractMinecart cart = (AbstractMinecart)entity;
                OrientedContraptionVisual.repositionOnCart(matrixStack, partialTicks, cart);
            } else {
                OrientedContraptionVisual.repositionOnContraption((OrientedContraptionEntity)this.entity, matrixStack, partialTicks, be);
            }
        }
        ((PoseTransformStack)((PoseTransformStack)((PoseTransformStack)((PoseTransformStack)((PoseTransformStack)TransformStack.of(matrixStack).nudge(((OrientedContraptionEntity)this.entity).getId())).center()).rotateYDegrees(angleYaw)).rotateZDegrees(anglePitch)).rotateYDegrees(angleInitialYaw)).uncenter();
    }

    public static void repositionOnCart(PoseStack matrixStack, float partialTicks, AbstractMinecart ridingEntity) {
        Vec3 cartPos = OrientedContraptionVisual.getCartOffset(partialTicks, ridingEntity);
        if (cartPos == Vec3.ZERO) {
            return;
        }
        matrixStack.translate(cartPos.x, cartPos.y, cartPos.z);
    }

    public static Vec3 getCartOffset(float partialTicks, AbstractMinecart cart) {
        MinecartBehavior minecartBehavior = cart.getBehavior();
        if (!(minecartBehavior instanceof OldMinecartBehavior)) {
            return Vec3.ZERO;
        }
        OldMinecartBehavior controller = (OldMinecartBehavior)minecartBehavior;
        double cartX = Mth.lerp((double)partialTicks, (double)cart.xOld, (double)cart.getX());
        double cartY = Mth.lerp((double)partialTicks, (double)cart.yOld, (double)cart.getY());
        double cartZ = Mth.lerp((double)partialTicks, (double)cart.zOld, (double)cart.getZ());
        Vec3 cartPos = controller.getPos(cartX, cartY, cartZ);
        if (cartPos != null) {
            Vec3 cartPosFront = controller.getPosOffs(cartX, cartY, cartZ, (double)0.3f);
            Vec3 cartPosBack = controller.getPosOffs(cartX, cartY, cartZ, (double)-0.3f);
            if (cartPosFront == null) {
                cartPosFront = cartPos;
            }
            if (cartPosBack == null) {
                cartPosBack = cartPos;
            }
            cartX = cartPos.x - cartX;
            cartY = (cartPosFront.y + cartPosBack.y) / 2.0 - cartY;
            cartZ = cartPos.z - cartZ;
            return new Vec3(cartX, cartY, cartZ);
        }
        return Vec3.ZERO;
    }

    public static void repositionOnContraption(OrientedContraptionEntity entity, PoseStack matrixStack, float partialTicks, AbstractContraptionEntity ridingEntity) {
        Vec3 pos = OrientedContraptionVisual.getContraptionOffset(entity, partialTicks, ridingEntity);
        matrixStack.translate(pos.x, pos.y, pos.z);
    }

    public static Vec3 getContraptionOffset(OrientedContraptionEntity entity, float partialTicks, AbstractContraptionEntity parent) {
        Vec3 passengerPosition = parent.getPassengerPosition(entity, partialTicks);
        if (passengerPosition == null) {
            return Vec3.ZERO;
        }
        double x = passengerPosition.x - Mth.lerp((double)partialTicks, (double)entity.xOld, (double)entity.getX());
        double y = passengerPosition.y - Mth.lerp((double)partialTicks, (double)entity.yOld, (double)entity.getY());
        double z = passengerPosition.z - Mth.lerp((double)partialTicks, (double)entity.zOld, (double)entity.getZ());
        return new Vec3(x, y, z);
    }
}

