/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.decoration.slidingDoor;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.zurrtum.create.catnip.data.Couple;
import com.zurrtum.create.catnip.data.Pair;
import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.catnip.lang.Lang;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.flywheel.lib.model.baked.PartialModel;
import com.zurrtum.create.client.foundation.gui.widget.Label;
import com.zurrtum.create.client.foundation.gui.widget.ScrollInput;
import com.zurrtum.create.client.foundation.gui.widget.SelectionScrollInput;
import com.zurrtum.create.client.foundation.utility.CreateLang;
import com.zurrtum.create.content.decoration.slidingDoor.DoorControl;
import com.zurrtum.create.content.decoration.slidingDoor.SlidingDoorBlock;
import com.zurrtum.create.content.decoration.slidingDoor.SlidingDoorBlockEntity;
import java.util.Arrays;
import java.util.Locale;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.state.BlockEntityRenderState;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.rendertype.RenderType;
import net.minecraft.client.renderer.rendertype.RenderTypes;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoorHingeSide;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class SlidingDoorRenderer
implements BlockEntityRenderer<SlidingDoorBlockEntity, DoorRenderState> {
    public SlidingDoorRenderer(BlockEntityRendererProvider.Context context) {
    }

    public DoorRenderState createRenderState() {
        return new DoorRenderState();
    }

    public void extractRenderState(SlidingDoorBlockEntity be, DoorRenderState state, float tickProgress, Vec3 cameraPos, @Nullable ModelFeatureRenderer.CrumblingOverlay crumblingOverlay) {
        state.blockState = be.getBlockState();
        if (!be.shouldRenderSpecial(state.blockState)) {
            return;
        }
        state.blockPos = be.getBlockPos();
        state.blockEntityType = be.getType();
        Level world = be.getLevel();
        state.lightCoords = world != null ? LevelRenderer.getLightColor((BlockAndTintGetter)world, (BlockPos)state.blockPos) : 0xF000F0;
        state.layer = RenderTypes.cutoutMovingBlock();
        Direction facing = (Direction)state.blockState.getValue((Property)DoorBlock.FACING);
        Direction movementDirection = facing.getClockWise();
        boolean isLeft = state.blockState.getValue((Property)DoorBlock.HINGE) == DoorHingeSide.LEFT;
        float value = be.animation.getValue(tickProgress);
        Vec3 offset = Vec3.atLowerCornerOf((Vec3i)facing.getUnitVec3i()).scale((double)(Mth.clamp((float)(value * 10.0f), (float)0.0f, (float)1.0f) * 1.0f / 32.0f));
        SlidingDoorBlock block = (SlidingDoorBlock)state.blockState.getBlock();
        if (block.isFoldingDoor()) {
            FoldingDoorRenderState renderState = new FoldingDoorRenderState();
            renderState.offsetY = -0.001953125f;
            renderState.offset = offset;
            renderState.angle = (float)Math.PI / 180 * AngleHelper.horizontalAngle(movementDirection);
            float f = isLeft ? 1.0f : -1.0f;
            float v = f * value * value;
            renderState.yRot = 1.5882496f * v;
            renderState.flip = !isLeft;
            Couple<PartialModel> partials = AllPartialModels.FOLDING_DOORS.get(BuiltInRegistries.BLOCK.getKey((Object)block));
            renderState.left = CachedBuffers.partial(partials.get(isLeft), state.blockState);
            renderState.right = CachedBuffers.partial(partials.get(renderState.flip), state.blockState);
            renderState.rightOffset = f / 2.0f;
            renderState.rightYRot = -3.159046f * v;
            renderState.light = state.lightCoords;
            state.renderer = renderState;
        } else {
            if (isLeft) {
                movementDirection = movementDirection.getOpposite();
            }
            SlidingDoorRenderState renderState = new SlidingDoorRenderState();
            BlockState blockState = (BlockState)state.blockState.setValue((Property)DoorBlock.OPEN, (Comparable)Boolean.valueOf(false));
            renderState.upper = CachedBuffers.block((BlockState)blockState.setValue((Property)DoorBlock.HALF, (Comparable)DoubleBlockHalf.UPPER));
            renderState.lower = CachedBuffers.block((BlockState)blockState.setValue((Property)DoorBlock.HALF, (Comparable)DoubleBlockHalf.LOWER));
            renderState.upperOffset = 0.9980469f;
            renderState.offset = Vec3.atLowerCornerOf((Vec3i)movementDirection.getUnitVec3i()).scale((double)(value * value * 13.0f / 16.0f)).add(offset);
            renderState.light = state.lightCoords;
            state.renderer = renderState;
        }
    }

    public void submit(DoorRenderState state, PoseStack matrices, SubmitNodeCollector queue, CameraRenderState cameraState) {
        if (state.renderer != null) {
            queue.submitCustomGeometry(matrices, state.layer, state.renderer);
        }
    }

    public static Pair<ScrollInput, Label> createWidget(Minecraft mc, int x, int y, Consumer<DoorControl> callback, DoorControl initial) {
        DoorControl doorControl;
        Entity entity = mc.getCameraEntity();
        if (entity != null) {
            switch (entity.getDirection()) {
                case EAST: {
                    doorControl = DoorControl.EAST;
                    break;
                }
                case WEST: {
                    doorControl = DoorControl.WEST;
                    break;
                }
                case NORTH: {
                    doorControl = DoorControl.NORTH;
                    break;
                }
                case SOUTH: {
                    doorControl = DoorControl.SOUTH;
                    break;
                }
                default: {
                    doorControl = DoorControl.NONE;
                    break;
                }
            }
        } else {
            doorControl = DoorControl.NONE;
        }
        DoorControl playerFacing = doorControl;
        Label label = new Label(x + 4, y + 6, (Component)Component.empty()).withShadow();
        ScrollInput input = new SelectionScrollInput(x, y, 53, 16).forOptions(CreateLang.translatedOptions("contraption.door_control", SlidingDoorRenderer.valuesAsString())).titled(CreateLang.translateDirect("contraption.door_control", new Object[0])).calling(s -> {
            DoorControl mode = DoorControl.values()[s];
            label.text = CreateLang.translateDirect("contraption.door_control." + Lang.asId(mode.name()) + ".short", new Object[0]);
            callback.accept(mode);
        }).addHint(CreateLang.translateDirect("contraption.door_control.player_facing", CreateLang.translateDirect("contraption.door_control." + Lang.asId(playerFacing.name()) + ".short", new Object[0]))).setState(initial.ordinal());
        input.onChanged();
        return Pair.of(input, label);
    }

    public static String[] valuesAsString() {
        DoorControl[] values = DoorControl.values();
        return Arrays.stream(values).map(dc -> dc.name().toLowerCase(Locale.ROOT)).toList().toArray(new String[values.length]);
    }

    public static class DoorRenderState
    extends BlockEntityRenderState {
        public SubmitNodeCollector.CustomGeometryRenderer renderer;
        public RenderType layer;
    }

    public static class FoldingDoorRenderState
    implements SubmitNodeCollector.CustomGeometryRenderer {
        public float offsetY;
        public Vec3 offset;
        public float angle;
        public float yRot;
        public boolean flip;
        public SuperByteBuffer left;
        public SuperByteBuffer right;
        public float rightOffset;
        public float rightYRot;
        public int light;

        public void render(PoseStack.Pose matricesEntry, VertexConsumer vertexConsumer) {
            ((SuperByteBuffer)((SuperByteBuffer)this.left.translate(0.0f, this.offsetY, 0.0f)).translate(this.offset)).rotateCentered(this.angle, Direction.UP);
            if (this.flip) {
                this.left.translate(0.0f, 0.0f, 1.0f);
            }
            this.left.rotateY(this.yRot);
            if (this.flip) {
                this.left.translate(0.0f, 0.0f, -0.5f);
            }
            this.left.light(this.light).renderInto(matricesEntry, vertexConsumer);
            ((SuperByteBuffer)((SuperByteBuffer)this.right.translate(0.0f, this.offsetY, 0.0f)).translate(this.offset)).rotateCentered(this.angle, Direction.UP);
            if (this.flip) {
                this.right.translate(0.0f, 0.0f, 1.0f);
            }
            ((SuperByteBuffer)((SuperByteBuffer)this.right.rotateY(this.yRot)).translate(0.0f, 0.0f, this.rightOffset)).rotateY(this.rightYRot);
            if (this.flip) {
                this.right.translate(0.0f, 0.0f, -0.5f);
            }
            this.right.light(this.light).renderInto(matricesEntry, vertexConsumer);
        }
    }

    public static class SlidingDoorRenderState
    implements SubmitNodeCollector.CustomGeometryRenderer {
        public SuperByteBuffer upper;
        public SuperByteBuffer lower;
        public float upperOffset;
        public Vec3 offset;
        public int light;

        public void render(PoseStack.Pose matricesEntry, VertexConsumer vertexConsumer) {
            ((SuperByteBuffer)((SuperByteBuffer)this.upper.translate(0.0f, this.upperOffset, 0.0f)).translate(this.offset)).light(this.light).renderInto(matricesEntry, vertexConsumer);
            ((SuperByteBuffer)this.lower.translate(this.offset)).light(this.light).renderInto(matricesEntry, vertexConsumer);
        }
    }
}

