/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.equipment.blueprint;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.zurrtum.create.AllPackets;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.catnip.gui.element.GuiGameElement;
import com.zurrtum.create.client.catnip.gui.widget.ElementWidget;
import com.zurrtum.create.client.foundation.gui.AllGuiTextures;
import com.zurrtum.create.client.foundation.gui.AllIcons;
import com.zurrtum.create.client.foundation.gui.menu.AbstractSimiContainerScreen;
import com.zurrtum.create.client.foundation.gui.widget.IconButton;
import com.zurrtum.create.client.foundation.utility.CreateLang;
import com.zurrtum.create.content.equipment.blueprint.BlueprintEntity;
import com.zurrtum.create.content.equipment.blueprint.BlueprintMenu;
import com.zurrtum.create.foundation.gui.menu.MenuType;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import org.joml.Quaternionfc;

public class BlueprintScreen
extends AbstractSimiContainerScreen<BlueprintMenu> {
    protected AllGuiTextures background;
    private List<Rect2i> extraAreas = Collections.emptyList();
    private IconButton resetButton;
    private IconButton confirmButton;
    private ElementWidget renderedItem;

    public BlueprintScreen(BlueprintMenu menu, Inventory inv, Component title) {
        super(menu, inv, title);
        this.background = AllGuiTextures.BLUEPRINT;
    }

    public static BlueprintScreen create(Minecraft mc, MenuType<BlueprintEntity.BlueprintSection> type, int syncId, Inventory inventory, Component title, RegistryFriendlyByteBuf extraData) {
        int entityID = extraData.readVarInt();
        int section = extraData.readVarInt();
        Entity entityByID = mc.level.getEntity(entityID);
        if (!(entityByID instanceof BlueprintEntity)) {
            return null;
        }
        BlueprintEntity blueprintEntity = (BlueprintEntity)entityByID;
        return (BlueprintScreen)((Object)type.create(BlueprintScreen::new, syncId, inventory, title, blueprintEntity.getSection(section)));
    }

    @Override
    protected void init() {
        this.setWindowSize(this.background.getWidth(), this.background.getHeight() + 4 + AllGuiTextures.PLAYER_INVENTORY.getHeight());
        this.setWindowOffset(1, 0);
        super.init();
        this.resetButton = new IconButton(this.leftPos + this.background.getWidth() - 62, this.topPos + this.background.getHeight() - 24, AllIcons.I_TRASH);
        this.resetButton.withCallback(() -> {
            ((BlueprintMenu)this.menu).clearContents();
            this.contentsCleared();
            this.minecraft.player.connection.send((Packet)AllPackets.CLEAR_CONTAINER);
        });
        this.confirmButton = new IconButton(this.leftPos + this.background.getWidth() - 33, this.topPos + this.background.getHeight() - 24, AllIcons.I_CONFIRM);
        this.confirmButton.withCallback(() -> this.minecraft.player.closeContainer());
        this.addRenderableWidget(this.resetButton);
        this.addRenderableWidget(this.confirmButton);
        this.extraAreas = ImmutableList.of((Object)new Rect2i(this.leftPos + this.background.getWidth(), this.topPos + this.background.getHeight() - 36, 56, 44));
        this.renderedItem = new ElementWidget(this.leftPos + this.background.getWidth() + 1, this.topPos + this.background.getHeight() - 34).showingElement(GuiGameElement.of(AllPartialModels.CRAFTING_BLUEPRINT_1x1).scale(2.5f).transform(this::transform).padding(13));
        this.addRenderableWidget(this.renderedItem);
    }

    private void transform(PoseStack ms, float p) {
        ms.translate(0.48f, 0.04f, 0.0f);
        ms.scale(1.0f, -1.0f, 1.0f);
        ms.mulPose((Quaternionfc)Axis.ZP.rotationDegrees(22.5f));
        ms.mulPose((Quaternionfc)Axis.XP.rotationDegrees(45.0f));
        ms.mulPose((Quaternionfc)Axis.YP.rotationDegrees(-45.0f));
    }

    public void onClose() {
        super.onClose();
        this.renderedItem.getRenderElement().clear();
    }

    protected void renderBg(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        int invX = this.getLeftOfCentered(AllGuiTextures.PLAYER_INVENTORY.getWidth());
        int invY = this.topPos + this.background.getHeight() + 4;
        this.renderPlayerInventory(graphics, invX, invY);
        this.background.render(graphics, this.leftPos, this.topPos);
        graphics.drawString(this.font, this.title, this.leftPos + 15, this.topPos + 4, -1, false);
    }

    protected void renderTooltip(GuiGraphics graphics, int x, int y) {
        if (!((BlueprintMenu)this.menu).getCarried().isEmpty() || this.hoveredSlot == null || this.hoveredSlot.container == ((BlueprintMenu)this.menu).playerInventory) {
            super.renderTooltip(graphics, x, y);
            return;
        }
        List<Object> list = new LinkedList<Component>();
        if (this.hoveredSlot.hasItem()) {
            list = this.getTooltipFromContainerItem(this.hoveredSlot.getItem());
        }
        graphics.setComponentTooltipForNextFrame(this.font, this.addToTooltip(list, this.hoveredSlot.getContainerSlot()), x, y);
    }

    private List<Component> addToTooltip(List<Component> list, int slot) {
        if (slot < 0 || slot > 10) {
            return list;
        }
        if (slot < 9) {
            list.add((Component)CreateLang.translateDirect("crafting_blueprint.crafting_slot", new Object[0]).withStyle(ChatFormatting.GOLD));
            list.add((Component)CreateLang.translateDirect("crafting_blueprint.filter_items_viable", new Object[0]).withStyle(ChatFormatting.GRAY));
        } else if (slot == 9) {
            list.add((Component)CreateLang.translateDirect("crafting_blueprint.display_slot", new Object[0]).withStyle(ChatFormatting.GOLD));
        } else {
            list.add((Component)CreateLang.translateDirect("crafting_blueprint.secondary_display_slot", new Object[0]).withStyle(ChatFormatting.GOLD));
            list.add((Component)CreateLang.translateDirect("crafting_blueprint.optional", new Object[0]).withStyle(ChatFormatting.GRAY));
        }
        return list;
    }

    @Override
    protected void containerTick() {
        if (!((BlueprintEntity.BlueprintSection)((BlueprintMenu)this.menu).contentHolder).isEntityAlive()) {
            this.minecraft.player.closeContainer();
        }
        super.containerTick();
    }

    protected void contentsCleared() {
    }

    @Override
    public List<Rect2i> getExtraAreas() {
        return this.extraAreas;
    }
}

