/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.equipment.hats;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.content.equipment.hats.HatState;
import com.zurrtum.create.client.content.trains.schedule.hat.TrainHatInfo;
import com.zurrtum.create.client.content.trains.schedule.hat.TrainHatInfoReloadListener;
import com.zurrtum.create.client.flywheel.lib.model.baked.PartialModel;
import com.zurrtum.create.client.flywheel.lib.transform.PoseTransformStack;
import com.zurrtum.create.client.flywheel.lib.transform.TransformStack;
import java.util.List;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class HatFeatureRenderer<S extends LivingEntityRenderState, M extends EntityModel<? super S>>
extends RenderLayer<S, M> {
    public HatFeatureRenderer(RenderLayerParent<S, M> context) {
        super(context);
    }

    public void submit(PoseStack ms, SubmitNodeCollector queue, int light, S renderState, float limbAngle, float limbDistance) {
        List<ModelPart> partsToHead;
        HatState hatState = (HatState)renderState;
        PartialModel hat = hatState.create$getHat();
        if (hat == null) {
            return;
        }
        EntityModel entityModel = this.getParentModel();
        ms.pushPose();
        PoseTransformStack msr = TransformStack.of(ms);
        TrainHatInfo info = hatState.create$getHatInfo();
        if (entityModel instanceof HeadedModel) {
            HeadedModel model = (HeadedModel)entityModel;
            partsToHead = TrainHatInfo.getAdjustedPart(info, model.getHead(), "");
            partsToHead.addFirst(entityModel.root());
        } else if (info != TrainHatInfoReloadListener.DEFAULT) {
            partsToHead = TrainHatInfo.getAdjustedPart(info, entityModel.root(), "head");
        } else {
            ms.popPose();
            return;
        }
        if (!partsToHead.isEmpty()) {
            partsToHead.forEach(part -> part.translateAndRotate(ms));
            ModelPart lastChild = partsToHead.get(partsToHead.size() - 1);
            if (!lastChild.isEmpty()) {
                ModelPart.Cube cube = (ModelPart.Cube)lastChild.cubes.get(Mth.clamp((int)info.cubeIndex(), (int)0, (int)(lastChild.cubes.size() - 1)));
                ms.translate(info.offset().x() / 16.0, ((double)(cube.minY - cube.maxY) + info.offset().y()) / 16.0, info.offset().z() / 16.0);
                float max = Math.max(cube.maxX - cube.minX, cube.maxZ - cube.minZ) / 8.0f * info.scale();
                ms.scale(max, max, max);
            }
            ms.scale(1.0f, -1.0f, -1.0f);
            ms.translate(0.0f, -0.140625f, 0.0f);
            msr.rotateXDegrees(-8.5f);
            BlockState air = Blocks.AIR.defaultBlockState();
            HatRenderState state = new HatRenderState(CachedBuffers.partial(hat, air), light);
            queue.submitCustomGeometry(ms, Sheets.cutoutBlockSheet(), (SubmitNodeCollector.CustomGeometryRenderer)state);
        }
        ms.popPose();
    }

    public record HatRenderState(SuperByteBuffer hat, int light) implements SubmitNodeCollector.CustomGeometryRenderer
    {
        public void render(PoseStack.Pose matricesEntry, VertexConsumer vertexConsumer) {
            this.hat.disableDiffuse().light(this.light).renderInto(matricesEntry, vertexConsumer);
        }
    }
}

