/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.equipment.toolbox;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.platform.Window;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.catnip.theme.Color;
import com.zurrtum.create.client.AllKeys;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.catnip.gui.AbstractSimiScreen;
import com.zurrtum.create.client.content.equipment.toolbox.ToolboxHandlerClient;
import com.zurrtum.create.client.foundation.gui.AllGuiTextures;
import com.zurrtum.create.client.foundation.gui.AllIcons;
import com.zurrtum.create.client.foundation.utility.CreateLang;
import com.zurrtum.create.content.equipment.toolbox.ToolboxBlockEntity;
import com.zurrtum.create.content.equipment.toolbox.ToolboxInventory;
import com.zurrtum.create.infrastructure.packet.c2s.ToolboxDisposeAllPacket;
import com.zurrtum.create.infrastructure.packet.c2s.ToolboxEquipPacket;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.client.input.MouseButtonInfo;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3x2fStack;

public class RadialToolboxMenu
extends AbstractSimiScreen {
    private State state;
    private int ticksOpen;
    private int hoveredSlot;
    private boolean scrollMode;
    private int scrollSlot = 0;
    private final List<ToolboxBlockEntity> toolboxes;
    private ToolboxBlockEntity selectedBox;
    private static final int DEPOSIT = -7;
    private static final int UNEQUIP = -5;

    public RadialToolboxMenu(List<ToolboxBlockEntity> toolboxes, State state, @Nullable ToolboxBlockEntity selectedBox) {
        this.toolboxes = toolboxes;
        this.state = state;
        this.hoveredSlot = -1;
        if (selectedBox != null) {
            this.selectedBox = selectedBox;
        }
    }

    public void prevSlot(int slot) {
        this.scrollSlot = slot;
    }

    @Override
    protected void renderWindow(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        boolean renderCenterSlot;
        float hoveredY;
        float fade = Mth.clamp((float)(((float)this.ticksOpen + AnimationTickHolder.getPartialTicks()) / 10.0f), (float)0.001953125f, (float)1.0f);
        this.hoveredSlot = -1;
        Window window = this.minecraft.getWindow();
        float hoveredX = mouseX - window.getGuiScaledWidth() / 2;
        float distance = hoveredX * hoveredX + (hoveredY = (float)(mouseY - window.getGuiScaledHeight() / 2)) * hoveredY;
        if (distance > 25.0f && distance < 10000.0f) {
            this.hoveredSlot = Mth.floor((float)(AngleHelper.deg(Mth.atan2((double)hoveredY, (double)hoveredX)) + 360.0f + 180.0f - 22.5f)) % 360 / 45;
        }
        boolean bl = renderCenterSlot = this.state == State.SELECT_ITEM_UNEQUIP;
        if (this.scrollMode && distance > 150.0f) {
            this.scrollMode = false;
        }
        if (renderCenterSlot && distance <= 150.0f) {
            this.hoveredSlot = -5;
        }
        Matrix3x2fStack ms = graphics.pose();
        ms.pushMatrix();
        ms.translate((float)(this.width / 2), (float)(this.height / 2));
        MutableComponent tip = null;
        if (this.state == State.DETACH) {
            tip = CreateLang.translateDirect("toolbox.outOfRange", new Object[0]);
            if (hoveredX > -20.0f && hoveredX < 20.0f && hoveredY > -80.0f && hoveredY < -20.0f) {
                this.hoveredSlot = -5;
            }
            ms.pushMatrix();
            AllGuiTextures.TOOLBELT_INACTIVE_SLOT.render(graphics, -12, -12);
            graphics.renderItem(AllItems.BROWN_TOOLBOX.getDefaultInstance(), -9, -9);
            ms.translate(0.0f, -40.0f + 10.0f * (1.0f - fade) * (1.0f - fade));
            AllGuiTextures.TOOLBELT_SLOT.render(graphics, -12, -12);
            ms.translate(-0.5f, 0.5f);
            AllIcons.I_DISABLE.render(graphics, -9, -9);
            ms.translate(0.5f, -0.5f);
            if (!this.scrollMode && this.hoveredSlot == -5) {
                AllGuiTextures.TOOLBELT_SLOT_HIGHLIGHT.render(graphics, -13, -13);
                tip = CreateLang.translateDirect("toolbox.detach", new Object[0]).withStyle(ChatFormatting.GOLD);
            }
            ms.popMatrix();
        } else {
            if (hoveredX > 60.0f && hoveredX < 100.0f && hoveredY > -20.0f && hoveredY < 20.0f) {
                this.hoveredSlot = -7;
            }
            ms.pushMatrix();
            ms.translate(80.0f + -5.0f * (1.0f - fade) * (1.0f - fade), 0.0f);
            AllGuiTextures.TOOLBELT_SLOT.render(graphics, -12, -12);
            ms.translate(-0.5f, 0.5f);
            AllIcons.I_TOOLBOX.render(graphics, -9, -9);
            ms.translate(0.5f, -0.5f);
            if (!this.scrollMode && this.hoveredSlot == -7) {
                AllGuiTextures.TOOLBELT_SLOT_HIGHLIGHT.render(graphics, -13, -13);
                tip = CreateLang.translateDirect(this.state == State.SELECT_BOX ? "toolbox.depositAll" : "toolbox.depositBox", new Object[0]).withStyle(ChatFormatting.GOLD);
            }
            ms.popMatrix();
            for (int slot = 0; slot < 8; ++slot) {
                ms.pushMatrix();
                ms.rotate((float)Math.PI / 180 * (float)(slot * 45 - 45));
                ms.translate(0.0f, -40.0f + 10.0f * (1.0f - fade) * (1.0f - fade));
                ms.rotate((float)Math.PI / 180 * (float)(-slot * 45 + 45));
                ms.translate(-12.0f, -12.0f);
                if (this.state == State.SELECT_ITEM || this.state == State.SELECT_ITEM_UNEQUIP) {
                    ToolboxInventory inv = this.selectedBox.inventory;
                    ItemStack stackInSlot = (ItemStack)inv.filters.get(slot);
                    if (!stackInSlot.isEmpty()) {
                        boolean empty = inv.getItem(slot * 4).isEmpty();
                        (empty ? AllGuiTextures.TOOLBELT_INACTIVE_SLOT : AllGuiTextures.TOOLBELT_SLOT).render(graphics, 0, 0);
                        graphics.renderItem(stackInSlot, 3, 3);
                        if (slot == (this.scrollMode ? this.scrollSlot : this.hoveredSlot) && !empty) {
                            AllGuiTextures.TOOLBELT_SLOT_HIGHLIGHT.render(graphics, -1, -1);
                            tip = stackInSlot.getHoverName();
                        }
                    } else {
                        AllGuiTextures.TOOLBELT_EMPTY_SLOT.render(graphics, 0, 0);
                    }
                } else if (this.state == State.SELECT_BOX) {
                    if (slot < this.toolboxes.size()) {
                        AllGuiTextures.TOOLBELT_SLOT.render(graphics, 0, 0);
                        ToolboxBlockEntity toolboxBlockEntity = this.toolboxes.get(slot);
                        ItemStack stack = toolboxBlockEntity.getBlockState().getBlock().asItem().getDefaultInstance();
                        graphics.renderItem(stack, 3, 3);
                        if (slot == (this.scrollMode ? this.scrollSlot : this.hoveredSlot)) {
                            AllGuiTextures.TOOLBELT_SLOT_HIGHLIGHT.render(graphics, -1, -1);
                            tip = toolboxBlockEntity.getDisplayName();
                        }
                    } else {
                        AllGuiTextures.TOOLBELT_EMPTY_SLOT.render(graphics, 0, 0);
                    }
                }
                ms.popMatrix();
            }
            if (renderCenterSlot) {
                ms.pushMatrix();
                AllGuiTextures.TOOLBELT_SLOT.render(graphics, -12, -12);
                (this.scrollMode ? AllIcons.I_REFRESH : AllIcons.I_FLIP).render(graphics, -9, -9);
                if (!this.scrollMode && -5 == this.hoveredSlot) {
                    AllGuiTextures.TOOLBELT_SLOT_HIGHLIGHT.render(graphics, -13, -13);
                    tip = CreateLang.translateDirect("toolbox.unequip", this.minecraft.player.getMainHandItem().getHoverName()).withStyle(ChatFormatting.GOLD);
                }
                ms.popMatrix();
            }
        }
        ms.popMatrix();
        if (tip != null) {
            int i1 = (int)(fade * 255.0f);
            if (i1 > 255) {
                i1 = 255;
            }
            if (i1 > 8) {
                ms.pushMatrix();
                ms.translate((float)(this.width / 2), (float)(this.height - 68));
                int k1 = 0xFFFFFF;
                int k = i1 << 24 & 0xFF000000;
                int l = this.font.width((FormattedText)tip);
                graphics.drawString(this.font, (Component)tip, Math.round((float)(-l) / 2.0f), -4, k1 | k, false);
                ms.popMatrix();
            }
        }
    }

    public void renderBackground(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        Color color = BACKGROUND_COLOR.scaleAlpha(Math.min(1.0f, ((float)this.ticksOpen + AnimationTickHolder.getPartialTicks()) / 20.0f));
        pGuiGraphics.fillGradient(0, 0, this.width, this.height, color.getRGB(), color.getRGB());
    }

    @Override
    public void tick() {
        ++this.ticksOpen;
        super.tick();
    }

    public void removed() {
        int selected;
        super.removed();
        int n = selected = this.scrollMode ? this.scrollSlot : this.hoveredSlot;
        if (selected == -7) {
            if (this.state == State.DETACH) {
                return;
            }
            if (this.state == State.SELECT_BOX) {
                this.toolboxes.forEach(be -> this.minecraft.player.connection.send((Packet)new ToolboxDisposeAllPacket(be.getBlockPos())));
            } else {
                this.minecraft.player.connection.send((Packet)new ToolboxDisposeAllPacket(this.selectedBox.getBlockPos()));
            }
            return;
        }
        if (this.state == State.SELECT_BOX) {
            return;
        }
        if (this.state == State.DETACH) {
            if (selected == -5) {
                this.minecraft.player.connection.send((Packet)new ToolboxEquipPacket(null, selected, this.minecraft.player.getInventory().getSelectedSlot()));
            }
            return;
        }
        if (selected == -5) {
            this.minecraft.player.connection.send((Packet)new ToolboxEquipPacket(this.selectedBox.getBlockPos(), selected, this.minecraft.player.getInventory().getSelectedSlot()));
        }
        if (selected < 0) {
            return;
        }
        ToolboxInventory inv = this.selectedBox.inventory;
        ItemStack stackInSlot = (ItemStack)inv.filters.get(selected);
        if (stackInSlot.isEmpty()) {
            return;
        }
        if (inv.getItem(selected * 4).isEmpty()) {
            return;
        }
        this.minecraft.player.connection.send((Packet)new ToolboxEquipPacket(this.selectedBox.getBlockPos(), selected, this.minecraft.player.getInventory().getSelectedSlot()));
    }

    public boolean mouseScrolled(double pMouseX, double pMouseY, double pScrollX, double pScrollY) {
        double hoveredY;
        Window window = this.minecraft.getWindow();
        double hoveredX = pMouseY - (double)(window.getGuiScaledWidth() / 2);
        double distance = hoveredX * hoveredX + (hoveredY = pMouseY - (double)(window.getGuiScaledHeight() / 2)) * hoveredY;
        if (distance <= 150.0) {
            this.scrollMode = true;
            this.scrollSlot = ((int)((double)this.scrollSlot - pScrollY) + 8) % 8;
            for (int i = 0; i < 10; ++i) {
                if (this.state == State.SELECT_ITEM || this.state == State.SELECT_ITEM_UNEQUIP) {
                    ToolboxInventory inv = this.selectedBox.inventory;
                    ItemStack stackInSlot = (ItemStack)inv.filters.get(this.scrollSlot);
                    if (!stackInSlot.isEmpty() && !inv.getItem(this.scrollSlot * 4).isEmpty()) break;
                }
                if (this.state == State.SELECT_BOX && this.scrollSlot < this.toolboxes.size() || this.state == State.DETACH) break;
                this.scrollSlot -= Mth.sign((double)pScrollY);
                this.scrollSlot = (this.scrollSlot + 8) % 8;
            }
            return true;
        }
        return super.mouseScrolled(pMouseX, pMouseY, pScrollX, pScrollY);
    }

    public boolean mouseClicked(MouseButtonEvent click, boolean doubled) {
        int selected = this.scrollMode ? this.scrollSlot : this.hoveredSlot;
        int button = click.button();
        if (button == 0) {
            if (selected == -7) {
                this.onClose();
                ToolboxHandlerClient.COOLDOWN = 2;
                return true;
            }
            if (this.state == State.SELECT_BOX && selected >= 0 && selected < this.toolboxes.size()) {
                this.state = State.SELECT_ITEM;
                this.selectedBox = this.toolboxes.get(selected);
                return true;
            }
            if (!(this.state != State.DETACH && this.state != State.SELECT_ITEM && this.state != State.SELECT_ITEM_UNEQUIP || selected != -5 && selected < 0)) {
                this.onClose();
                ToolboxHandlerClient.COOLDOWN = 2;
                return true;
            }
        }
        if (button == 1) {
            if (this.state == State.SELECT_ITEM && this.toolboxes.size() > 1) {
                this.state = State.SELECT_BOX;
                return true;
            }
            if (this.state == State.SELECT_ITEM_UNEQUIP && selected == -5) {
                if (this.toolboxes.size() > 1) {
                    this.minecraft.player.connection.send((Packet)new ToolboxEquipPacket(this.selectedBox.getBlockPos(), selected, this.minecraft.player.getInventory().getSelectedSlot()));
                    this.state = State.SELECT_BOX;
                    return true;
                }
                this.onClose();
                ToolboxHandlerClient.COOLDOWN = 2;
                return true;
            }
        }
        return super.mouseClicked(click, doubled);
    }

    @Override
    public boolean keyPressed(KeyEvent input) {
        KeyMapping[] hotbarBinds = this.minecraft.options.keyHotbarSlots;
        for (int i = 0; i < hotbarBinds.length && i < 8; ++i) {
            if (!hotbarBinds[i].matches(input)) continue;
            if (this.state == State.SELECT_ITEM || this.state == State.SELECT_ITEM_UNEQUIP) {
                ToolboxInventory inv = this.selectedBox.inventory;
                ItemStack stackInSlot = (ItemStack)inv.filters.get(i);
                if (stackInSlot.isEmpty() || inv.getItem(i * 4).isEmpty()) {
                    return false;
                }
            }
            if (this.state == State.SELECT_BOX && i >= this.toolboxes.size()) {
                return false;
            }
            this.scrollMode = true;
            this.scrollSlot = i;
            this.mouseClicked(new MouseButtonEvent(0.0, 0.0, new MouseButtonInfo(0, 0)), false);
            return true;
        }
        return super.keyPressed(input);
    }

    public boolean keyReleased(KeyEvent input) {
        InputConstants.Key mouseKey = InputConstants.getKey((KeyEvent)input);
        if (mouseKey == AllKeys.TOOLBELT.key) {
            this.onClose();
            return true;
        }
        return super.keyReleased(input);
    }

    public static enum State {
        SELECT_BOX,
        SELECT_ITEM,
        SELECT_ITEM_UNEQUIP,
        DETACH;

    }
}

