/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.equipment.toolbox;

import com.google.common.collect.ImmutableList;
import com.zurrtum.create.AllSynchedDatas;
import com.zurrtum.create.client.AllKeys;
import com.zurrtum.create.client.catnip.gui.ScreenOpener;
import com.zurrtum.create.client.content.equipment.toolbox.RadialToolboxMenu;
import com.zurrtum.create.client.foundation.gui.AllGuiTextures;
import com.zurrtum.create.content.equipment.toolbox.ToolboxBlockEntity;
import com.zurrtum.create.content.equipment.toolbox.ToolboxHandler;
import com.zurrtum.create.content.equipment.toolbox.ToolboxInventory;
import com.zurrtum.create.infrastructure.packet.c2s.ToolboxEquipPacket;
import java.util.Comparator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;

public class ToolboxHandlerClient {
    static int COOLDOWN = 0;

    public static void clientTick() {
        if (!(COOLDOWN <= 0 || AllKeys.TOOLBELT.consumeClick() || AllKeys.TOOLBELT.key == AllKeys.TOOL_MENU.key && AllKeys.TOOL_MENU.consumeClick())) {
            --COOLDOWN;
        }
    }

    public static boolean onPickItem(Minecraft mc) {
        LocalPlayer player = mc.player;
        if (player == null) {
            return false;
        }
        Level level = player.level();
        HitResult hitResult = mc.hitResult;
        if (hitResult == null || hitResult.getType() == HitResult.Type.MISS) {
            return false;
        }
        if (player.isCreative()) {
            return false;
        }
        ItemStack result = ItemStack.EMPTY;
        List<ToolboxBlockEntity> toolboxes = ToolboxHandler.getNearest((LevelAccessor)player.level(), (Player)player, 8);
        if (toolboxes.isEmpty()) {
            return false;
        }
        if (hitResult.getType() == HitResult.Type.BLOCK) {
            BlockPos pos = ((BlockHitResult)hitResult).getBlockPos();
            BlockState state = level.getBlockState(pos);
            if (state.isAir()) {
                return false;
            }
            result = state.getCloneItemStack((LevelReader)level, pos, true);
        } else if (hitResult.getType() == HitResult.Type.ENTITY) {
            Entity entity = ((EntityHitResult)hitResult).getEntity();
            result = entity.getPickResult();
        }
        if (result.isEmpty()) {
            return false;
        }
        for (ToolboxBlockEntity toolboxBlockEntity : toolboxes) {
            ToolboxInventory inventory = toolboxBlockEntity.inventory;
            for (int comp = 0; comp < 8; ++comp) {
                ItemStack inSlot = inventory.takeFromCompartment(1, comp, true);
                if (inSlot.isEmpty() || inSlot.getItem() != result.getItem() || !ItemStack.matches((ItemStack)inSlot, (ItemStack)result)) continue;
                player.connection.send((Packet)new ToolboxEquipPacket(toolboxBlockEntity.getBlockPos(), comp, player.getInventory().getSelectedSlot()));
                return true;
            }
        }
        return false;
    }

    public static boolean onKeyInput(Minecraft mc, KeyEvent input) {
        if (!AllKeys.TOOLBELT.matches(input)) {
            return false;
        }
        if (mc.gameMode == null || mc.gameMode.getPlayerMode() == GameType.SPECTATOR) {
            return false;
        }
        if (COOLDOWN > 0) {
            return false;
        }
        LocalPlayer player = mc.player;
        if (player == null) {
            return false;
        }
        Level level = player.level();
        List<ToolboxBlockEntity> toolboxes = ToolboxHandler.getNearest((LevelAccessor)player.level(), (Player)player, 8);
        toolboxes.sort(Comparator.comparing(ToolboxBlockEntity::getUniqueId));
        CompoundTag compound = AllSynchedDatas.TOOLBOX.get((Entity)player);
        String slotKey = String.valueOf(player.getInventory().getSelectedSlot());
        boolean equipped = compound.contains(slotKey);
        if (equipped) {
            BlockEntity blockEntity;
            boolean canReachToolbox;
            CompoundTag slotCompound = compound.getCompoundOrEmpty(slotKey);
            BlockPos pos = slotCompound.read("Pos", BlockPos.CODEC).orElse(BlockPos.ZERO);
            double max = ToolboxHandler.getMaxRange((Player)player);
            boolean bl = canReachToolbox = ToolboxHandler.distance(player.position(), pos) < max * max;
            if (canReachToolbox && (blockEntity = level.getBlockEntity(pos)) instanceof ToolboxBlockEntity) {
                RadialToolboxMenu screen = new RadialToolboxMenu(toolboxes, RadialToolboxMenu.State.SELECT_ITEM_UNEQUIP, (ToolboxBlockEntity)blockEntity);
                screen.prevSlot(slotCompound.getIntOr("Slot", 0));
                ScreenOpener.open(screen);
                return true;
            }
            ScreenOpener.open(new RadialToolboxMenu((List<ToolboxBlockEntity>)ImmutableList.of(), RadialToolboxMenu.State.DETACH, null));
            return true;
        }
        if (toolboxes.isEmpty()) {
            return false;
        }
        if (toolboxes.size() == 1) {
            ScreenOpener.open(new RadialToolboxMenu(toolboxes, RadialToolboxMenu.State.SELECT_ITEM, toolboxes.getFirst()));
        } else {
            ScreenOpener.open(new RadialToolboxMenu(toolboxes, RadialToolboxMenu.State.SELECT_BOX, null));
        }
        return true;
    }

    public static void renderOverlay(Minecraft mc, GuiGraphics guiGraphics) {
        int width = guiGraphics.guiWidth();
        int height = guiGraphics.guiHeight();
        int x = width / 2 - 90;
        int y = height - 23;
        LocalPlayer player = mc.player;
        CompoundTag compound = AllSynchedDatas.TOOLBOX.get((Entity)player);
        if (compound.isEmpty()) {
            return;
        }
        int selectedSlot = player.getInventory().getSelectedSlot();
        for (int slot = 0; slot < 9; ++slot) {
            int offset;
            String key = String.valueOf(slot);
            if (!compound.contains(key)) continue;
            BlockPos pos = compound.getCompoundOrEmpty(key).read("Pos", BlockPos.CODEC).orElse(BlockPos.ZERO);
            double max = ToolboxHandler.getMaxRange((Player)player);
            boolean selected = slot == selectedSlot;
            int n = offset = selected ? 1 : 0;
            AllGuiTextures texture = ToolboxHandler.distance(player.position(), pos) < max * max ? (selected ? AllGuiTextures.TOOLBELT_SELECTED_ON : AllGuiTextures.TOOLBELT_HOTBAR_ON) : (selected ? AllGuiTextures.TOOLBELT_SELECTED_OFF : AllGuiTextures.TOOLBELT_HOTBAR_OFF);
            texture.render(guiGraphics, x + 20 * slot - offset, y + offset);
        }
    }
}

