/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.equipment.toolbox;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.content.equipment.toolbox.ToolboxBlock;
import com.zurrtum.create.content.equipment.toolbox.ToolboxBlockEntity;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.state.BlockEntityRenderState;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.rendertype.RenderType;
import net.minecraft.client.renderer.rendertype.RenderTypes;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class ToolboxRenderer
implements BlockEntityRenderer<ToolboxBlockEntity, ToolboxRenderState> {
    public ToolboxRenderer(BlockEntityRendererProvider.Context context) {
    }

    public ToolboxRenderState createRenderState() {
        return new ToolboxRenderState();
    }

    public void extractRenderState(ToolboxBlockEntity be, ToolboxRenderState state, float tickProgress, Vec3 cameraPos, @Nullable ModelFeatureRenderer.CrumblingOverlay crumblingOverlay) {
        BlockEntityRenderState.extractBase((BlockEntity)be, (BlockEntityRenderState)state, (ModelFeatureRenderer.CrumblingOverlay)crumblingOverlay);
        state.layer = RenderTypes.cutoutMovingBlock();
        state.lid = CachedBuffers.partial(AllPartialModels.TOOLBOX_LIDS.get(be.getColor()), state.blockState);
        state.drawer = CachedBuffers.partial(AllPartialModels.TOOLBOX_DRAWER, state.blockState);
        Direction facing = ((Direction)state.blockState.getValue((Property)ToolboxBlock.FACING)).getOpposite();
        state.yRot = (float)Math.PI / 180 * -facing.toYRot();
        state.xRot = 2.3561945f * be.lid.getValue(tickProgress);
        float drawerOffset = be.drawers.getValue(tickProgress);
        state.offset1 = -drawerOffset * 0.175f;
        state.offset2 = state.offset1 * 2.0f;
    }

    public void submit(ToolboxRenderState state, PoseStack matrices, SubmitNodeCollector queue, CameraRenderState cameraState) {
        queue.submitCustomGeometry(matrices, state.layer, (SubmitNodeCollector.CustomGeometryRenderer)state);
    }

    public static class ToolboxRenderState
    extends BlockEntityRenderState
    implements SubmitNodeCollector.CustomGeometryRenderer {
        public RenderType layer;
        public SuperByteBuffer lid;
        public SuperByteBuffer drawer;
        public float yRot;
        public float xRot;
        public float offset1;
        public float offset2;

        public void render(PoseStack.Pose matricesEntry, VertexConsumer vertexConsumer) {
            ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)this.lid.center()).rotateY(this.yRot)).uncenter()).translate(0.0f, 0.375f, 0.75f)).rotateX(this.xRot)).translate(0.0f, -0.375f, -0.75f)).light(this.lightCoords).renderInto(matricesEntry, vertexConsumer);
            ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)this.drawer.center()).rotateY(this.yRot)).uncenter()).translate(0.0f, 0.125f, this.offset1)).light(this.lightCoords).renderInto(matricesEntry, vertexConsumer);
            ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)this.drawer.center()).rotateY(this.yRot)).uncenter()).translate(0.0f, 0.0f, this.offset2)).light(this.lightCoords).renderInto(matricesEntry, vertexConsumer);
        }
    }
}

