/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.fluids.drain;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.client.catnip.render.FluidRenderHelper;
import com.zurrtum.create.client.flywheel.lib.transform.PoseTransformStack;
import com.zurrtum.create.client.flywheel.lib.transform.TransformStack;
import com.zurrtum.create.content.fluids.drain.ItemDrainBlockEntity;
import com.zurrtum.create.content.fluids.transfer.GenericItemEmptying;
import com.zurrtum.create.content.kinetics.belt.BeltHelper;
import com.zurrtum.create.content.kinetics.belt.transport.TransportedItemStack;
import com.zurrtum.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour;
import com.zurrtum.create.infrastructure.fluids.FluidStack;
import java.util.Random;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.state.BlockEntityRenderState;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.item.ItemModelResolver;
import net.minecraft.client.renderer.item.ItemStackRenderState;
import net.minecraft.client.renderer.rendertype.RenderType;
import net.minecraft.client.renderer.rendertype.RenderTypes;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionfc;

public class ItemDrainRenderer
implements BlockEntityRenderer<ItemDrainBlockEntity, ItemDrainRenderState> {
    protected final ItemModelResolver itemModelManager;

    public ItemDrainRenderer(BlockEntityRendererProvider.Context context) {
        this.itemModelManager = context.itemModelResolver();
    }

    public ItemDrainRenderState createRenderState() {
        return new ItemDrainRenderState();
    }

    public void extractRenderState(ItemDrainBlockEntity be, ItemDrainRenderState state, float tickProgress, Vec3 cameraPos, @Nullable ModelFeatureRenderer.CrumblingOverlay crumblingOverlay) {
        BlockEntityRenderState.extractBase((BlockEntity)be, (BlockEntityRenderState)state, (ModelFeatureRenderer.CrumblingOverlay)crumblingOverlay);
        ItemDrainRenderer.updateFluidRenderState(be, state, tickProgress);
        ItemDrainRenderer.updateItemRenderState(be, state, this.itemModelManager, tickProgress);
    }

    public void submit(ItemDrainRenderState state, PoseStack matrices, SubmitNodeCollector queue, CameraRenderState cameraState) {
        if (state.process != null) {
            queue.submitCustomGeometry(matrices, state.process.layer, (SubmitNodeCollector.CustomGeometryRenderer)state.process);
        }
        if (state.item != null) {
            state.item.render(matrices, queue, cameraState.pos, state.lightCoords);
        }
        if (state.fluid != null) {
            matrices.translate(0.0f, state.fluid.offset, 0.0f);
            queue.submitCustomGeometry(matrices, state.fluid.layer, (SubmitNodeCollector.CustomGeometryRenderer)state.fluid);
        }
    }

    public static void updateFluidRenderState(ItemDrainBlockEntity be, ItemDrainRenderState state, float tickProgress) {
        ItemStack heldItemStack;
        float level;
        SmartFluidTankBehaviour tank = be.internalTank;
        if (tank == null) {
            return;
        }
        SmartFluidTankBehaviour.TankSegment primaryTank = tank.getPrimaryTank();
        FluidStack fluidStack = primaryTank.getRenderedFluid();
        if (!fluidStack.isEmpty() && (level = primaryTank.getFluidLevel().getValue(tickProgress)) != 0.0f) {
            float yMax = 0.3125f;
            float min = 0.125f;
            float max = min + 0.75f;
            float yOffset = 0.4375f * level;
            float yMin = yMax - yOffset;
            state.fluid = new FluidRenderState(RenderTypes.translucentMovingBlock(), fluidStack.getFluid(), fluidStack.getComponentChanges(), min, max, yMin, yMax, yOffset, state.lightCoords);
        }
        if ((heldItemStack = be.getHeldItemStack()).isEmpty()) {
            return;
        }
        int processingTicks = be.processingTicks;
        if (processingTicks == -1) {
            return;
        }
        FluidStack fluidStack2 = GenericItemEmptying.emptyItem(be.getLevel(), heldItemStack, true).getFirst();
        if (fluidStack2.isEmpty()) {
            if (fluidStack.isEmpty()) {
                return;
            }
            fluidStack2 = fluidStack;
        }
        float processingPT = (float)processingTicks - tickProgress;
        float processingProgress = 1.0f - (processingPT - 5.0f) / 10.0f;
        processingProgress = Mth.clamp((float)processingProgress, (float)0.0f, (float)1.0f);
        float radius = (float)(Math.pow(2.0f * processingProgress - 1.0f, 2.0) - 1.0);
        AABB box = new AABB(0.5, 1.0, 0.5, 0.5, 0.25, 0.5).inflate((double)(radius / 32.0f));
        state.process = new ProcessRenderState(RenderTypes.translucentMovingBlock(), fluidStack2.getFluid(), fluidStack2.getComponentChanges(), box, state.lightCoords);
    }

    public static void updateItemRenderState(ItemDrainBlockEntity be, ItemDrainRenderState state, ItemModelResolver itemModelManager, float tickProgress) {
        boolean alongX;
        TransportedItemStack transported = be.heldItem;
        if (transported == null) {
            return;
        }
        Direction insertedFrom = transported.insertedFrom;
        if (!insertedFrom.getAxis().isHorizontal()) {
            return;
        }
        HeldItemRenderState item = state.item = new HeldItemRenderState();
        item.itemPosition = VecHelper.getCenterOf((Vec3i)state.blockPos);
        float offset = Mth.lerp((float)tickProgress, (float)transported.prevBeltPosition, (float)transported.beltPosition);
        float sideOffset = Mth.lerp((float)tickProgress, (float)transported.prevSideOffset, (float)transported.sideOffset);
        item.offsetVec = Vec3.atLowerCornerOf((Vec3i)insertedFrom.getOpposite().getUnitVec3i()).scale((double)(0.5f - offset));
        boolean bl = alongX = insertedFrom.getClockWise().getAxis() == Direction.Axis.X;
        if (!alongX) {
            sideOffset *= -1.0f;
        }
        item.translate = item.offsetVec.add(alongX ? (double)sideOffset : 0.0, 0.0, alongX ? 0.0 : (double)sideOffset);
        ItemStack itemStack = transported.stack;
        item.count = Mth.log2((int)itemStack.getCount()) / 2;
        item.upright = BeltHelper.isItemUpright(itemStack);
        int positive = insertedFrom.getAxisDirection().getStep();
        item.axis = insertedFrom.getAxis();
        item.verticalAngle = (float)positive * offset * 360.0f;
        ItemStackRenderState renderState = state.item.state = new ItemStackRenderState();
        renderState.displayContext = ItemDisplayContext.FIXED;
        itemModelManager.appendItemLayers(renderState, itemStack, renderState.displayContext, be.getLevel(), null, 0);
    }

    public static class ItemDrainRenderState
    extends BlockEntityRenderState {
        public FluidRenderState fluid;
        public ProcessRenderState process;
        public HeldItemRenderState item;
    }

    public record ProcessRenderState(RenderType layer, Fluid fluid, DataComponentPatch changes, AABB box, int light) implements SubmitNodeCollector.CustomGeometryRenderer
    {
        public void render(PoseStack.Pose matricesEntry, VertexConsumer vertexConsumer) {
            FluidRenderHelper.renderFluidBox(this.fluid, this.changes, (float)this.box.minX, (float)this.box.minY, (float)this.box.minZ, (float)this.box.maxX, (float)this.box.maxY, (float)this.box.maxZ, vertexConsumer, matricesEntry, this.light, true, false);
        }
    }

    public static class HeldItemRenderState {
        public ItemStackRenderState state;
        public Vec3 itemPosition;
        public Vec3 translate;
        public Vec3 offsetVec;
        public int count;
        public boolean upright;
        public Direction.Axis axis;
        public float verticalAngle;

        public void render(PoseStack matrices, SubmitNodeCollector queue, Vec3 positionVec, int light) {
            PoseTransformStack msr = TransformStack.of(matrices);
            matrices.pushPose();
            matrices.translate(0.5f, 0.9375f, 0.5f);
            msr.nudge(0);
            matrices.translate(this.translate);
            boolean renderUpright = this.upright;
            if (renderUpright) {
                matrices.translate(0.0, 0.09375, 0.0);
            }
            if (this.axis != Direction.Axis.X) {
                msr.rotateXDegrees(this.verticalAngle);
            }
            if (this.axis != Direction.Axis.Z) {
                msr.rotateZDegrees(-this.verticalAngle);
            }
            if (renderUpright) {
                Vec3 vectorForOffset = this.itemPosition.add(this.offsetVec);
                Vec3 diff = vectorForOffset.subtract(positionVec);
                if (this.axis != Direction.Axis.X) {
                    diff = VecHelper.rotate(diff, this.verticalAngle, Direction.Axis.X);
                }
                if (this.axis != Direction.Axis.Z) {
                    diff = VecHelper.rotate(diff, -this.verticalAngle, Direction.Axis.Z);
                }
                float yRot = (float)Mth.atan2((double)diff.z, (double)(-diff.x));
                matrices.mulPose((Quaternionfc)Axis.YP.rotation((float)((double)yRot - 1.5707963267948966)));
                matrices.translate(0.0f, 0.0f, -0.0625f);
            }
            Random r = new Random(0L);
            boolean blockItem = this.state.usesBlockLight();
            for (int i = 0; i < this.count; ++i) {
                matrices.pushPose();
                if (blockItem) {
                    matrices.translate(r.nextFloat() * 0.0625f * (float)i, 0.0f, r.nextFloat() * 0.0625f * (float)i);
                }
                matrices.scale(0.5f, 0.5f, 0.5f);
                if (!blockItem && !renderUpright) {
                    msr.rotateXDegrees(90.0f);
                }
                this.state.submit(matrices, queue, light, OverlayTexture.NO_OVERLAY, 0);
                matrices.popPose();
                if (!renderUpright) {
                    if (!blockItem) {
                        msr.rotateYDegrees(10.0f);
                    }
                    matrices.translate(0.0, blockItem ? 0.015625 : 0.0625, 0.0);
                    continue;
                }
                matrices.translate(0.0f, 0.0f, -0.0625f);
            }
            matrices.pushPose();
            if (blockItem) {
                matrices.translate(r.nextFloat() * 0.0625f * (float)this.count, 0.0f, r.nextFloat() * 0.0625f * (float)this.count);
            }
            matrices.scale(0.5f, 0.5f, 0.5f);
            if (!blockItem && !renderUpright) {
                msr.rotateXDegrees(90.0f);
            }
            this.state.submit(matrices, queue, light, OverlayTexture.NO_OVERLAY, 0);
            matrices.popPose();
            matrices.popPose();
        }
    }

    public record FluidRenderState(RenderType layer, Fluid fluid, DataComponentPatch changes, float min, float max, float yMin, float yMax, float offset, int light) implements SubmitNodeCollector.CustomGeometryRenderer
    {
        public void render(PoseStack.Pose matricesEntry, VertexConsumer vertexConsumer) {
            FluidRenderHelper.renderFluidBox(this.fluid, this.changes, this.min, this.yMin, this.min, this.max, this.yMax, this.max, vertexConsumer, matricesEntry, this.light, false, false);
        }
    }
}

