/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.fluids.pipes.valve;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.content.kinetics.base.KineticBlockEntityRenderer;
import com.zurrtum.create.content.fluids.pipes.valve.FluidValveBlock;
import com.zurrtum.create.content.fluids.pipes.valve.FluidValveBlockEntity;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.rendertype.RenderType;
import net.minecraft.client.renderer.rendertype.RenderTypes;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class FluidValveRenderer
extends KineticBlockEntityRenderer<FluidValveBlockEntity, FluidValveRenderState> {
    public FluidValveRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    @Override
    public FluidValveRenderState createRenderState() {
        return new FluidValveRenderState();
    }

    @Override
    public void extractRenderState(FluidValveBlockEntity be, FluidValveRenderState state, float tickProgress, Vec3 cameraPos, @Nullable ModelFeatureRenderer.CrumblingOverlay crumblingOverlay) {
        super.extractRenderState(be, state, tickProgress, cameraPos, crumblingOverlay);
        if (state.support) {
            return;
        }
        BlockState blockState = be.getBlockState();
        state.pointer = CachedBuffers.partial(AllPartialModels.FLUID_VALVE_POINTER, blockState);
        Direction facing = (Direction)blockState.getValue((Property)FluidValveBlock.FACING);
        state.yRot = (float)Math.PI / 180 * AngleHelper.horizontalAngle(facing);
        state.xRot = (float)Math.PI / 180 * (float)(facing == Direction.UP ? 0 : (facing == Direction.DOWN ? 180 : 90));
        Direction.Axis pipeAxis = FluidValveBlock.getPipeAxis(blockState);
        float pointerRotation = Mth.lerpInt((float)be.pointer.getValue(tickProgress), (int)0, (int)-90);
        state.yRot2 = pipeAxis.isHorizontal() && FluidValveRenderer.getRotationAxisOf(be) == Direction.Axis.X || pipeAxis.isVertical() ? (float)Math.PI / 180 * (90.0f + pointerRotation) : (float)Math.PI / 180 * pointerRotation;
    }

    @Override
    protected RenderType getRenderType(FluidValveBlockEntity be, BlockState state) {
        return RenderTypes.solidMovingBlock();
    }

    @Override
    protected BlockState getRenderedBlockState(FluidValveBlockEntity be) {
        return FluidValveRenderer.shaft(FluidValveRenderer.getRotationAxisOf(be));
    }

    public static class FluidValveRenderState
    extends KineticBlockEntityRenderer.KineticRenderState {
        public SuperByteBuffer pointer;
        public float yRot;
        public float xRot;
        public float yRot2;

        @Override
        public void render(PoseStack.Pose matricesEntry, VertexConsumer vertexConsumer) {
            super.render(matricesEntry, vertexConsumer);
            ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)this.pointer.center()).rotateY(this.yRot)).rotateX(this.xRot)).rotateY(this.yRot2)).uncenter();
            this.pointer.light(this.lightCoords).renderInto(matricesEntry, vertexConsumer);
        }
    }
}

