/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.fluids.spout;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.FluidRenderHelper;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.content.fluids.spout.SpoutBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour;
import com.zurrtum.create.infrastructure.fluids.FluidStack;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.state.BlockEntityRenderState;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.rendertype.RenderType;
import net.minecraft.client.renderer.rendertype.RenderTypes;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class SpoutRenderer
implements BlockEntityRenderer<SpoutBlockEntity, SpoutRenderState> {
    public SpoutRenderer(BlockEntityRendererProvider.Context context) {
    }

    public SpoutRenderState createRenderState() {
        return new SpoutRenderState();
    }

    public void extractRenderState(SpoutBlockEntity be, SpoutRenderState state, float tickProgress, Vec3 cameraPos, @Nullable ModelFeatureRenderer.CrumblingOverlay crumblingOverlay) {
        SmartFluidTankBehaviour tank = be.tank;
        if (tank == null) {
            return;
        }
        BlockEntityRenderState.extractBase((BlockEntity)be, (BlockEntityRenderState)state, (ModelFeatureRenderer.CrumblingOverlay)crumblingOverlay);
        SmartFluidTankBehaviour.TankSegment primaryTank = tank.getPrimaryTank();
        FluidStack fluidStack = primaryTank.getRenderedFluid();
        float radius = 0.0f;
        int processingTicks = be.processingTicks;
        float processingPT = (float)processingTicks - tickProgress;
        if (!fluidStack.isEmpty()) {
            float level = primaryTank.getFluidLevel().getValue(tickProgress);
            if (level != 0.0f) {
                boolean top = false;
                float min = 0.15625f;
                float n = 0.6875f;
                float max = min + n;
                float yOffset = n * Math.max(level, 0.175f);
                float yMin = min - yOffset;
                float offset = top ? max - min : yOffset;
                state.fluid = new FluidRenderState(RenderTypes.translucentMovingBlock(), fluidStack.getFluid(), fluidStack.getComponentChanges(), min, max, yMin, offset, state.lightCoords);
            }
            if (processingTicks != -1) {
                float processingProgress = 1.0f - (processingPT - 5.0f) / 10.0f;
                processingProgress = Mth.clamp((float)processingProgress, (float)0.0f, (float)1.0f);
                radius = (float)(Math.pow(2.0f * processingProgress - 1.0f, 2.0) - 1.0);
                AABB box = new AABB(0.5, 0.0, 0.5, 0.5, -1.2, 0.5).inflate((double)(radius / 32.0f));
                state.process = new ProcessRenderState(RenderTypes.translucentMovingBlock(), fluidStack.getFluid(), fluidStack.getComponentChanges(), box, state.lightCoords);
            }
        }
        float squeeze = processingPT < 0.0f ? 0.0f : (processingPT < 2.0f ? (float)Mth.lerpInt((float)(processingPT / 2.0f), (int)0, (int)-1) : (processingPT < 10.0f ? -1.0f : radius));
        SuperByteBuffer top = CachedBuffers.partial(AllPartialModels.SPOUT_TOP, state.blockState);
        SuperByteBuffer middle = CachedBuffers.partial(AllPartialModels.SPOUT_MIDDLE, state.blockState);
        SuperByteBuffer bottom = CachedBuffers.partial(AllPartialModels.SPOUT_BOTTOM, state.blockState);
        float offset = -3.0f * squeeze / 32.0f;
        state.bits = new BitsRenderState(RenderTypes.solidMovingBlock(), top, middle, bottom, offset, state.lightCoords);
    }

    public void submit(SpoutRenderState state, PoseStack matrices, SubmitNodeCollector queue, CameraRenderState cameraState) {
        if (state.process != null) {
            queue.submitCustomGeometry(matrices, state.process.layer, (SubmitNodeCollector.CustomGeometryRenderer)state.process);
        }
        queue.submitCustomGeometry(matrices, state.bits.layer, (SubmitNodeCollector.CustomGeometryRenderer)state.bits);
        if (state.fluid != null) {
            matrices.translate(0.0f, state.fluid.offset, 0.0f);
            queue.submitCustomGeometry(matrices, state.fluid.layer, (SubmitNodeCollector.CustomGeometryRenderer)state.fluid);
        }
    }

    public static class SpoutRenderState
    extends BlockEntityRenderState {
        public FluidRenderState fluid;
        public ProcessRenderState process;
        public BitsRenderState bits;
    }

    public record FluidRenderState(RenderType layer, Fluid fluid, DataComponentPatch changes, float min, float max, float yMin, float offset, int light) implements SubmitNodeCollector.CustomGeometryRenderer
    {
        public void render(PoseStack.Pose matricesEntry, VertexConsumer vertexConsumer) {
            FluidRenderHelper.renderFluidBox(this.fluid, this.changes, this.min, this.yMin, this.min, this.max, this.min, this.max, vertexConsumer, matricesEntry, this.light, false, true);
        }
    }

    public record ProcessRenderState(RenderType layer, Fluid fluid, DataComponentPatch changes, AABB box, int light) implements SubmitNodeCollector.CustomGeometryRenderer
    {
        public void render(PoseStack.Pose matricesEntry, VertexConsumer vertexConsumer) {
            FluidRenderHelper.renderFluidBox(this.fluid, this.changes, (float)this.box.minX, (float)this.box.minY, (float)this.box.minZ, (float)this.box.maxX, (float)this.box.maxY, (float)this.box.maxZ, vertexConsumer, matricesEntry, this.light, true, true);
        }
    }

    public record BitsRenderState(RenderType layer, SuperByteBuffer top, SuperByteBuffer middle, SuperByteBuffer bottom, float offset, int light) implements SubmitNodeCollector.CustomGeometryRenderer
    {
        public void render(PoseStack.Pose matricesEntry, VertexConsumer vertexConsumer) {
            this.top.light(this.light).renderInto(matricesEntry, vertexConsumer);
            matricesEntry.translate(0.0f, this.offset, 0.0f);
            this.middle.light(this.light).renderInto(matricesEntry, vertexConsumer);
            matricesEntry.translate(0.0f, this.offset, 0.0f);
            this.bottom.light(this.light).renderInto(matricesEntry, vertexConsumer);
        }
    }
}

