/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.kinetics.base;

import com.zurrtum.create.catnip.theme.Color;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.content.equipment.armor.BacktankRenderer;
import com.zurrtum.create.client.content.kinetics.base.KineticBlockEntityVisual;
import com.zurrtum.create.client.content.kinetics.base.RotatingInstance;
import com.zurrtum.create.client.flywheel.api.instance.Instance;
import com.zurrtum.create.client.flywheel.api.model.Model;
import com.zurrtum.create.client.flywheel.api.visual.TickableVisual;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationContext;
import com.zurrtum.create.client.flywheel.lib.model.Models;
import com.zurrtum.create.client.flywheel.lib.model.baked.PartialModel;
import com.zurrtum.create.client.flywheel.lib.visual.SimpleTickableVisual;
import com.zurrtum.create.client.flywheel.lib.visualization.SimpleBlockEntityVisualizer;
import com.zurrtum.create.client.foundation.render.AllInstanceTypes;
import com.zurrtum.create.content.kinetics.base.KineticBlockEntity;
import java.util.function.Consumer;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;

public class SingleAxisRotatingVisual<T extends KineticBlockEntity>
extends KineticBlockEntityVisual<T>
implements SimpleTickableVisual {
    public static boolean rainbowMode = false;
    protected final RotatingInstance rotatingModel;

    public SingleAxisRotatingVisual(VisualizationContext context, T blockEntity, float partialTick, Model model) {
        this(context, blockEntity, partialTick, Direction.UP, model);
    }

    public SingleAxisRotatingVisual(VisualizationContext context, T blockEntity, float partialTick, Direction from, Model model) {
        super(context, blockEntity, partialTick);
        this.rotatingModel = this.instancerProvider().instancer(AllInstanceTypes.ROTATING, model).createInstance().rotateToFace(from, this.rotationAxis()).setup((KineticBlockEntity)blockEntity).setPosition((Vec3i)this.getVisualPosition());
        this.rotatingModel.setChanged();
    }

    public static <T extends KineticBlockEntity> SimpleBlockEntityVisualizer.Factory<T> of(PartialModel partial) {
        return (context, blockEntity, partialTick) -> new SingleAxisRotatingVisual<KineticBlockEntity>(context, (KineticBlockEntity)blockEntity, partialTick, Models.partial(partial));
    }

    public static <T extends KineticBlockEntity> SimpleBlockEntityVisualizer.Factory<T> ofZ(PartialModel partial) {
        return (context, blockEntity, partialTick) -> new SingleAxisRotatingVisual<KineticBlockEntity>(context, (KineticBlockEntity)blockEntity, partialTick, Direction.SOUTH, Models.partial(partial));
    }

    public static <T extends KineticBlockEntity> SingleAxisRotatingVisual<T> shaft(VisualizationContext context, T blockEntity, float partialTick) {
        return new SingleAxisRotatingVisual<T>(context, blockEntity, partialTick, Models.partial(AllPartialModels.SHAFT));
    }

    public static <T extends KineticBlockEntity> SingleAxisRotatingVisual<T> backtank(VisualizationContext context, T blockEntity, float partialTick) {
        Model model = Models.partial(BacktankRenderer.getShaftModel(blockEntity.getBlockState()));
        return new SingleAxisRotatingVisual<T>(context, blockEntity, partialTick, model);
    }

    @Override
    public void update(float pt) {
        this.rotatingModel.setup((KineticBlockEntity)this.blockEntity).setChanged();
    }

    @Override
    public void tick(TickableVisual.Context context) {
        float overStressedEffect = ((KineticBlockEntity)this.blockEntity).effects.overStressedEffect;
        if (overStressedEffect != 0.0f) {
            boolean overstressed = overStressedEffect > 0.0f;
            Color color = overstressed ? Color.RED : Color.SPRING_GREEN;
            float weight = overstressed ? overStressedEffect : -overStressedEffect;
            this.rotatingModel.setColor(Color.WHITE.mixWith(color, weight));
        } else {
            this.rotatingModel.setColor(Color.WHITE);
        }
        this.rotatingModel.setChanged();
    }

    @Override
    public void updateLight(float partialTick) {
        this.relight(this.rotatingModel);
    }

    @Override
    protected void _delete() {
        this.rotatingModel.delete();
    }

    @Override
    public void collectCrumblingInstances(Consumer<Instance> consumer) {
        consumer.accept(this.rotatingModel);
    }
}

