/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.kinetics.chainConveyor;

import com.google.common.cache.Cache;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.zurrtum.create.AllItemTags;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.catnip.data.WorldAttached;
import com.zurrtum.create.catnip.theme.Color;
import com.zurrtum.create.client.catnip.outliner.Outliner;
import com.zurrtum.create.client.content.kinetics.chainConveyor.ChainConveyorRidingHandler;
import com.zurrtum.create.client.content.kinetics.chainConveyor.ChainConveyorShape;
import com.zurrtum.create.client.content.logistics.packagePort.PackagePortTargetSelectionHandler;
import com.zurrtum.create.client.foundation.utility.RaycastHelper;
import com.zurrtum.create.content.logistics.box.PackageItem;
import com.zurrtum.create.content.logistics.packagePort.PackagePortTarget;
import com.zurrtum.create.foundation.utility.TickBasedCache;
import com.zurrtum.create.infrastructure.packet.c2s.ChainConveyorConnectionPacket;
import com.zurrtum.create.infrastructure.packet.c2s.ChainPackageInteractionPacket;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.rendertype.RenderTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.protocol.Packet;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class ChainConveyorInteractionHandler {
    public static WorldAttached<Cache<BlockPos, List<ChainConveyorShape>>> loadedChains = new WorldAttached<Cache>($ -> new TickBasedCache(60, true));
    public static BlockPos selectedLift;
    public static float selectedChainPosition;
    public static BlockPos selectedConnection;
    public static Vec3 selectedBakedPosition;
    public static ChainConveyorShape selectedShape;

    public static void clientTick(Minecraft mc) {
        if (!ChainConveyorInteractionHandler.isActive(mc)) {
            selectedLift = null;
            return;
        }
        LocalPlayer player = mc.player;
        boolean isWrench = player.isHolding(i -> i.is(AllItemTags.TOOLS_WRENCH));
        boolean dismantling = isWrench && player.isShiftKeyDown();
        double range = player.getAttributeValue(Attributes.BLOCK_INTERACTION_RANGE) + 1.0;
        Vec3 from = player.getEyePosition();
        Vec3 to = RaycastHelper.getTraceTarget((Player)player, range, from);
        HitResult hitResult = mc.hitResult;
        double bestDiff = 3.4028234663852886E38;
        if (hitResult != null) {
            bestDiff = hitResult.getLocation().distanceToSqr(from);
        }
        BlockPos bestLift = null;
        ChainConveyorShape bestShape = null;
        selectedConnection = null;
        for (Map.Entry entry : loadedChains.get((LevelAccessor)mc.level).asMap().entrySet()) {
            BlockPos liftPos = (BlockPos)entry.getKey();
            for (ChainConveyorShape chainConveyorShape : (List)entry.getValue()) {
                double distanceToSqr;
                Vec3 liftVec;
                Vec3 intersect;
                if (chainConveyorShape instanceof ChainConveyorShape.ChainConveyorBB && dismantling || (intersect = chainConveyorShape.intersect(from.subtract(liftVec = Vec3.atLowerCornerOf((Vec3i)liftPos)), to.subtract(liftVec))) == null || (distanceToSqr = intersect.add(liftVec).distanceToSqr(from)) > bestDiff) continue;
                bestDiff = distanceToSqr;
                bestLift = liftPos;
                bestShape = chainConveyorShape;
                selectedChainPosition = chainConveyorShape.getChainPosition(intersect);
                if (!(chainConveyorShape instanceof ChainConveyorShape.ChainConveyorOBB)) continue;
                ChainConveyorShape.ChainConveyorOBB obb = (ChainConveyorShape.ChainConveyorOBB)chainConveyorShape;
                selectedConnection = obb.connection;
            }
        }
        selectedLift = bestLift;
        if (bestLift == null) {
            return;
        }
        selectedShape = bestShape;
        selectedBakedPosition = bestShape.getVec(bestLift, selectedChainPosition);
        if (!isWrench) {
            Outliner.getInstance().chaseAABB("ChainPointSelection", new AABB(selectedBakedPosition, selectedBakedPosition)).colored(Color.WHITE).lineWidth(0.16666667f).disableLineNormals();
        }
    }

    private static boolean isActive(Minecraft mc) {
        ItemStack mainHandItem = mc.player.getMainHandItem();
        return mc.player.isHolding(i -> i.is(AllItemTags.CHAIN_RIDEABLE)) || mainHandItem.is((Item)AllItems.PACKAGE_FROGPORT) || PackageItem.isPackage(mainHandItem);
    }

    public static boolean onUse(Minecraft mc) {
        if (selectedLift == null) {
            return false;
        }
        LocalPlayer player = mc.player;
        ItemStack mainHandItem = player.getMainHandItem();
        if (player.isHolding(i -> i.is(AllItemTags.CHAIN_RIDEABLE))) {
            ItemStack usedItem;
            ItemStack itemStack = usedItem = mainHandItem.is(AllItemTags.CHAIN_RIDEABLE) ? mainHandItem : player.getOffhandItem();
            if (!player.isShiftKeyDown()) {
                ChainConveyorRidingHandler.embark(mc, selectedLift, selectedChainPosition, selectedConnection);
                return true;
            }
            player.connection.send((Packet)new ChainConveyorConnectionPacket(selectedLift, selectedLift.offset((Vec3i)selectedConnection), usedItem, false));
            return true;
        }
        if (mainHandItem.is((Item)AllItems.PACKAGE_FROGPORT)) {
            PackagePortTargetSelectionHandler.exactPositionOfTarget = selectedBakedPosition;
            PackagePortTargetSelectionHandler.activePackageTarget = new PackagePortTarget.ChainConveyorFrogportTarget(selectedLift, selectedChainPosition, selectedConnection, false);
            return true;
        }
        if (PackageItem.isPackage(mainHandItem)) {
            player.connection.send((Packet)new ChainPackageInteractionPacket(selectedLift, selectedConnection == null ? BlockPos.ZERO : selectedConnection, selectedChainPosition, false));
            return true;
        }
        return true;
    }

    public static void drawCustomBlockSelection(PoseStack ms, MultiBufferSource buffer, Vec3 camera) {
        if (selectedLift == null || selectedShape == null) {
            return;
        }
        VertexConsumer vb = buffer.getBuffer(RenderTypes.lines());
        ms.pushPose();
        ms.translate((double)selectedLift.getX() - camera.x, (double)selectedLift.getY() - camera.y, (double)selectedLift.getZ() - camera.z);
        selectedShape.drawOutline(selectedLift, ms, vb);
        ms.popPose();
    }

    public static boolean hideVanillaBlockSelection() {
        return selectedLift != null && selectedShape != null;
    }
}

